<!-- input form for SHELX and CRANK2 -->
<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page import="model.*"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<p>
	The file formats accepted for input are <a
		href='http://www.ccp4.ac.uk/html/mtzformat.html#fileformat'
		target="_blank">mtz</a>, <a
		href='http://shelx.uni-ac.gwdg.de/tutorial/english/xprep.htm'
		target="_blank">hkl</a>, <a
		href='http://xds.mpimf-heidelberg.mpg.de/html_doc/xds_files.html'
		target="_blank">HKL</a>, <a
		href='http://xray0.princeton.edu/~phil/Facility/Guides/DataWrangling.html#scalepack'
		target="_blank">sca</a>
	<!--
					<a
					href='http://www.ebi.ac.uk/msd/documentation/mmcif.html'
					target="blank">cif</a> 
					-->
	(structure factors) and <a href="javascript:showHelp4()">FASTA</a>,
	PIR, SEQ (sequence target).
</p>

<p>NB. We collect anonymous job statistics on the type of
	experiment, element search, resolution cutoffs, correlation
	coefficients, number of residues and chains, and the achieved
	R-factors. None of this will include information that could be used to
	identify the user.</p>

<!-- FILE ERRORS -->
<c:forEach items="${model.programRunErrors}" var="error">
	<span class='error'>&nbsp;${error}&nbsp;</span>
	<br />
</c:forEach>

<!-- FORM -->
<div id="form3" data-ng-app="ShelxApp"
	data-ng-controller="ShelxCtrl as main" class="pure-form">

	<!--
					<form novalidate method="post" enctype="multipart/form-data"
						action="servlet/controller/RunnableProgramsRun" name="shelxForm"
						data-ng-controller="ShelxCtrl as main">
					-->

	<form novalidate method="post" enctype="multipart/form-data"
		name="shelxForm" action="servlet/controller/RunnableProgramsRun"
		class="pure-form">

		<c:if test="${not empty param.repeat}">
			<input type="hidden" name="repeat" value="true" />
		</c:if>

		<fieldset>
			<table class="pure-table form-table">

				<tbody>
					<tr>
						<th>&nbsp;Select the experiment type:&nbsp;</th>
						<td><select id="experimentTypeSelection"
							name="experimentType" data-ng-model="main.shelx.experimentType"
							data-ng-change="changeExperimentType(main.shelx.experimentType)">
								<option value="SAD">SAD</option>
								<option value="SIRAS">SIRAS</option>
								<option value="MAD2">MAD - 2 wavelengths</option>
								<option value="MAD3">MAD - 3 wavelengths</option>
								<option value="MAD4">MAD - 4 wavelengths</option>
						</select>&nbsp;</td>
					</tr>

					<tr data-ng-if="main.shelx.experimentType">
						<th>&nbsp;Job title (optional):&nbsp;</th>
						<td><input name="jobtitle" maxlength="30" /></td>
					</tr>
				</tbody>

				<!-- upload of the structure factors file for SAD or SIRAS -->
				<tbody data-ng-if="main.shelx.isSAD || main.shelx.isSIRAS"
					class="start-section">

					<tr>
						<th>&nbsp;Anomalous dataset:&nbsp;</th>
						<td><input type="file" name="structureFactorsFile1" size="75"
							data-file-model="main.shelx.files.structureFactorsFile1.file" />
						</td>
					</tr>

					<c:if test="${programType=='CRANK2'}">
						<tr>
							<th>&nbsp;Atomic anomalous scattering coefficients:&nbsp;</th>
							<td>&nbsp;f'<sub>1</sub><input name="fprime1" size="3"
								data-ng-model="main.shelx.fp1"></input>&nbsp;f''<sub>1</sub><input
								name="fprimeprime1" size="3" data-ng-model="main.shelx.fpp1"></input></td>
						</tr>
					</c:if>

				</tbody>

				<tbody data-ng-if="main.shelx.experimentType && main.shelx.isMAD"
					class="start-section">

					<tr>
						<th>&nbsp;Anomalous dataset 1:&nbsp;</th>
						<td><input type="file" name="structureFactorsFile1" size="75"
							data-file-model="main.shelx.files.structureFactorsFile1.file" />
							&nbsp;Data type:&nbsp;<select name="dataType1"
							data-ng-model="main.shelx.dataType1">
								<option value="peak">peak</option>
								<option value="inflection">inflection</option>
								<option value="high">high remote</option>
								<option value="low">low remote</option>
						</select>&nbsp;</td>
					</tr>

					<c:if test="${programType=='CRANK2'}">
						<tr>
							<th>&nbsp;Atomic anomalous scattering coefficients:&nbsp;</th>
							<td>f'<sub>1</sub><input name="fprime1" size="3"
								data-ng-model="main.shelx.fp1"></input>f''<sub>1</sub><input
								name="fprimeprime1" size="3" data-ng-model="main.shelx.fpp1"></input></td>
						</tr>
					</c:if>

				</tbody>

				<!--  column label selection if the file is mtz format -->
				<tbody data-ng-if="main.shelx.files.structureFactorsFile1.isMTZ"
					data-my-tag="1"
					data-mtz-labels="main.shelx.files.structureFactorsFile1.file"></tbody>

				<tbody data-ng-if="main.shelx.experimentType && main.shelx.isMAD"
					class="start-section">

					<tr>
						<th>&nbsp;Anomalous dataset 2:&nbsp;</th>
						<td><input type="file" name="structureFactorsFile2" size="75"
							data-file-model="main.shelx.files.structureFactorsFile2.file" />
							&nbsp;Data type:&nbsp;<select name="dataType2"
							data-ng-model="main.shelx.dataType2">
								<option value="peak">peak</option>
								<option value="inflection">inflection</option>
								<option value="high">high remote</option>
								<option value="low">low remote</option>
						</select>&nbsp;</td>
					</tr>

					<c:if test="${programType=='CRANK2'}">
						<tr>
							<th>&nbsp;Atomic anomalous scattering coefficients:&nbsp;</th>
							<td>f'<sub>2</sub><input name="fprime2" size="3"
								data-ng-model="main.shelx.fp2"></input>f''<sub>2</sub><input
								name="fprimeprime2" size="3" data-ng-model="main.shelx.fpp2"></input></td>
						</tr>
					</c:if>

				</tbody>

				<!--  column label selection if the file is mtz format -->
				<tbody
					data-ng-if="main.shelx.isMAD && main.shelx.files.structureFactorsFile2.isMTZ"
					data-my-tag="2"
					data-mtz-labels="main.shelx.files.structureFactorsFile2.file"></tbody>

				<tbody
					data-ng-if="main.shelx.experimentType && (main.shelx.nwl > 2)"
					class="start-section">

					<tr>
						<th>&nbsp;Anomalous dataset 3:&nbsp;</th>
						<td><input type="file" name="structureFactorsFile3" size="75"
							data-file-model="main.shelx.files.structureFactorsFile3.file" />
							&nbsp;Data type:&nbsp;<select name="dataType3"
							data-ng-model="main.shelx.dataType3">
								<option value="peak">peak</option>
								<option value="inflection">inflection</option>
								<option value="high">high remote</option>
								<option value="low">low remote</option>
						</select>&nbsp;</td>
					</tr>

					<c:if test="${programType=='CRANK2'}">
						<tr>
							<th>&nbsp;Atomic anomalous scattering coefficients:&nbsp;</th>
							<td>f'<sub>3</sub><input name="fprime3" size="3"
								data-ng-model="main.shelx.fp3"></input>f''<sub>3</sub><input
								name="fprimeprime3" size="3" data-ng-model="main.shelx.fpp3"></input></td>
						</tr>
					</c:if>

				</tbody>

				<!--  column label selection if the file is mtz format -->
				<tbody
					data-ng-if="main.shelx.files.structureFactorsFile3.isMTZ && (main.shelx.nwl > 2)"
					data-my-tag="3"
					data-mtz-labels="main.shelx.files.structureFactorsFile3.file"></tbody>

				<tbody
					data-ng-if="main.shelx.experimentType && (main.shelx.nwl > 3)"
					class="start-section">

					<tr>
						<th>&nbsp;Anomalous dataset 4:&nbsp;</th>
						<td><input type="file" name="structureFactorsFile4" size="75"
							data-file-model="main.shelx.files.structureFactorsFile4.file" />
							&nbsp;Data type:&nbsp;<select name="dataType4"
							data-ng-model="main.shelx.dataType4">
								<option value="peak">peak</option>
								<option value="inflection">inflection</option>
								<option value="high">high remote</option>
								<option value="low">low remote</option>
						</select>&nbsp;</td>
					</tr>

					<c:if test="${programType=='CRANK2'}">
						<tr>
							<th>&nbsp;Atomic anomalous scattering coefficients:&nbsp;</th>
							<td>f'<sub>4</sub><input name="fprime4" size="3"
								data-ng-model="main.shelx.fp4"></input>f''<sub>4</sub><input
								name="fprimeprime4" size="3" data-ng-model="main.shelx.fpp4"></input></td>
						</tr>
					</c:if>

				</tbody>

				<!--  column label selection if the file is mtz format -->
				<tbody
					data-ng-if="main.shelx.files.structureFactorsFile4.isMTZ && (main.shelx.nwl > 3)"
					data-my-tag="4"
					data-mtz-labels="main.shelx.files.structureFactorsFile4.file"></tbody>

				<tbody
					data-ng-if="main.shelx.experimentType && main.shelx.askNative && main.shelx.Optional"
					class="start-section">
					<tr>
						<th>&nbsp;Optional native dataset:&nbsp;</th>
						<td><input type="file"
							name="structureFactorsFileNativeOptional" size="75"
							data-file-model="main.shelx.files.structureFactorsFileNativeOptional.file" />
						</td>
					</tr>
				</tbody>

				<!--  column label selection if the file is mtz format -->
				<tbody
					data-ng-if="main.shelx.files.structureFactorsFileNativeOptional.isMTZ"
					data-my-tag="Native"
					data-mtz-labels="main.shelx.files.structureFactorsFileNativeOptional.file"></tbody>

				<tbody
					data-ng-if="main.shelx.experimentType && main.shelx.askNative && !main.shelx.Optional"
					class="start-section">
					<tr>
						<th>&nbsp;Native dataset:&nbsp;</th>
						<td><input type="file" name="structureFactorsFileNative"
							size="75"
							data-file-model="main.shelx.files.structureFactorsFileNative.file" />
						</td>
					</tr>
				</tbody>

				<!--  column label selection if the file is mtz format -->
				<tbody
					data-ng-if="main.shelx.files.structureFactorsFileNative.isMTZ"
					data-my-tag="Native"
					data-mtz-labels="main.shelx.files.structureFactorsFileNative.file"></tbody>

				<tbody data-ng-if="main.shelx.cellrequired" class="start-section">
					<!-- cell parameter input, if the file is not mtz format -->
					<tr>
						<th>&nbsp;Cell parameters:&nbsp;</th>
						<td>a:&nbsp;<input name="a1" size="5" maxlength="7"
							data-ng-model="main.shelx.cell.a"></input>&nbsp; b:&nbsp;<input
							name="b1" size="5" maxlength="7"
							data-ng-model="main.shelx.cell.b"></input>&nbsp; c:&nbsp;<input
							name="c1" size="5" maxlength="7"
							data-ng-model="main.shelx.cell.c"></input><br /> &alpha;:&nbsp;<input
							name="alpha1" size="5" maxlength="7"
							data-ng-model="main.shelx.cell.alpha"></input>&nbsp;
							&beta;:&nbsp;<input name="beta1" size="5" maxlength="7"
							data-ng-model="main.shelx.cell.beta"></input>&nbsp;
							&gamma;:&nbsp;<input name="gamma1" size="5" maxlength="7"
							data-ng-model="main.shelx.cell.gamma"></input>&nbsp;
						</td>
					</tr>

					<!-- spacegroup input, if the file is not mtz format -->
					<tr>
						<th>&nbsp;Space group name:&nbsp;</th>
						<td><input name="spacegroup1" size="7" maxlength="10"
							data-ng-model="main.shelx.spacegroup"></input></td>
					</tr>
				</tbody>


				<tbody class="start-section" data-ng-if="main.shelx.experimentType">
					<tr id="sequenceTargetRow">
						<th>&nbsp;Sequence Target:&nbsp;</th>
						<td><input type="file" name="sequenceTargetFile" size="75"
							data-file-model="main.shelx.files.sequenceFile.file" />&nbsp;</td>
					</tr>

					<tr>
						<th>&nbsp;</th>
						<td><strong>&nbsp;Instead of entering a Sequence
								Target file you can paste your <a href="javascript:showHelp4()">FASTA</a>
								sequence below:
						</strong> <br /> <strong>&nbsp;(Note that a comment line
								beginning with a '>' character must preceed each sequence)</strong></td>
					</tr>

					<tr>
						<th>&nbsp;</th>
						<td><textarea class="textarea2" name="sequenceTargetTextarea"
								rows="10" cols="60" data-ng-model="main.shelx.sequence"></textarea></td>
					</tr>

					<!-- if the sequence is not given, then the number of residues is required -->
					<tr>
						<th>The number of residues in a monomer:&nbsp;</th>
						<td><input name="num_resid" size="2"
							data-ng-model="main.shelx.num_resid">&nbsp;(please give
							either this or the sequence target)</td>
					</tr>
				</tbody>

				<tbody class="start-section">
					<tr id="substructureAtomSelectionRow"
						data-ng-if="main.shelx.experimentType">
						<th>&nbsp;Substructure atom:&nbsp;</th>
						<td><input name="substructureAtom" size="2"
							data-ng-model="main.shelx.substructureAtom"
							data-ng-change="checkSubstructureAtom(main.shelx.substructureAtom)">
						</td>
					</tr>

					<tr data-ng-if="main.shelx.experimentType">
						<th>&nbsp;{{main.shelx.nosubstructureatomstext}}
							(optional):&nbsp;</th>
						<td><input name="exp_num_atoms" size="2"></td>
					</tr>

					<tr id="disulphidesRow"
						data-ng-if="main.shelx.experimentType && main.shelx.isSulphur">
						<th>&nbsp;No. of disulphides to be treated as S-S pairs<br />
							(Optional, but recommended. A default value will be used, if left
							blank.)
						</th>
						<td><input id="DSULField" name="DSUL" size="2"></td>
					</tr>
				</tbody>

				<tbody class="start-section">
					<tr id="cutoffRow" data-ng-if="main.shelx.experimentType">
						<th>&nbsp;High resolution cutoff (in &Aring;,
							optional):&nbsp;</th>
						<td><input id="cutoffField" name="cutoff" size="10"></td>
					</tr>
					<c:if test="${programType=='SHELX'}">
						<tr data-ng-if="main.shelx.experimentType">
							<th>&nbsp; No. of substructure detection trials
								(optional):&nbsp;</th>
							<td><input name="num_trials" size="2"></td>
						</tr>
					</c:if>
				</tbody>

				<c:if test="${programType=='CRANK2'}">
					<tbody class="start-section">
						<tr data-ng-if="main.shelx.experimentType">
							<th>&nbsp;Is this a new/unsolved structure?&nbsp;</th>
							<td><input type="checkbox" name="newStructure"/></td>
						</tr>
					</tbody>
				</c:if>

				<!--
				<c:if test="${programType=='SHELX'}">
					<tbody class="start-section">
						<tr data-ng-if="main.shelx.experimentType">
							<th>&nbsp;I have the SHELX licence:&nbsp;</th>
							<td><input type="checkbox" name="shelxLicence"
								data-ng-model="main.shelx.licence" />&nbsp;(You can get the
								licence from the <a
								href="http://main.shelx.uni-ac.gwdg.de/SHELX/">SHELX website</a>.)</td>
						</tr>
					</tbody>
				</c:if>
				-->

			</table>

			<input type="hidden" name="id" value="${id}" /> <input type="hidden"
				name="page" value="1" />

			<!-- validation errors after pressing the validate button below -->
			<errors></errors>

			<submit></submit>

			<validate></validate>

			<button type="reset"
				class="pure-button pure-button-active submitButton" id='resetButton'
				data-ng-click="init()" data-ng-if="main.shelx.experimentType">Reset</button>

		</fieldset>

	</form>
</div>
<script>
	var job = {
		programType : "${programType}",
		id : "${id}",
	};
</script>
<script src="./resources/angular.min.js" type="text/javascript"></script>
<script src="./resources/lodash.min.js" type="text/javascript"></script>
<script src="./resources/shelx/shelx.js" type="text/javascript"></script>
<script src="./resources/shelx/shelx-controller.js"
	type="text/javascript"></script>
<script src="./resources/shelx/filereader-service.js"
	type="text/javascript"></script>
<script src="./resources/shelx/services.js" type="text/javascript"></script>
<script src="./resources/shelx/directives.js" type="text/javascript"></script>