<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page errorPage="ErrorPage.jsp"%>
<%@ page import="model.*"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session" />

<!DOCTYPE html>

<c:set var="programType" scope="session"
	value="${model.runnableProgramsType}"></c:set>
<c:set var="startedId" scope="session" value="${model.runStartedId}"></c:set>
<c:set var="expTime" scope="session"
	value="${initParam['filesExpireTime']}"></c:set>

<c:if test="${empty startedId}">
	<c:set var="startedId" scope="session" value="${param.startedId}"></c:set>
</c:if>

<%
	if (model.getUsername().equals("")) {
		throw new ServletException("No model found in runnableProgramsTable.jsp");
	}
	if (!model.getRunStartedId().equals("")) {
		model.setRunStartedId("");
	}
%>

<%
	String navBar = "<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>&nbsp;>&nbsp;"
			+ model.getRunnableProgramsType();
%>

<html lang="EN">
<head>
<meta charset="UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=9;chrome=1" />
<title>CCP4 online</title>
<!--<link rel="stylesheet" href="http://yui.yahooapis.com/pure/0.6.0/pure-min.css">-->
<c:set var="url">${pageContext.request.requestURL}</c:set>
<%@include file="initialisation.jsp"%>
<jsp:include page="initialisation.jsp" flush="false" />
<script src="./resources/jquery.js"></script>
<!--<script src="http://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>-->
</head>

<body>

	<!-- testing Vaadin embedding
	<div id="embedded-app" class="v-app">
		<div class="v-app-loading"></div>
		<noscript>You should enable javascript to use this app</noscript>
	</div>
	-->

	<div id="container">

		<%@ include file="./header.jsp"%>

		<div id="header">
			<div id="breadcrumb">
				<ul>
					<div id='leftNav'><%=navBar%></div>
					<div id='rightNav'>
						Username: <strong><%=model.getUsername()%></strong>
					</div>
				</ul>
				<div class="clear">&nbsp;</div>
			</div>
		</div>

		<%
			String programType = model.getRunnableProgramsType();
		%>

		<div id="content-container">

			<div id="container2">

				<c:if test="${programType=='CRANK2'}">
				<img src="./images/crank2.svg" height="80" alt="" style="float: left; padding-right: 2em; "></img>
				<img src="./images/Leiden-University-Logo.png" height="70" alt="" style="float: right;"></img>
				</c:if>
				<c:if test="${programType=='SHELX'}">
				<img src="./images/goettingen.jpg" height="60" alt="" style="float: right;"></img>
				</c:if>
				<c:if test="${programType=='AMPLE'}">
				<img src="./images/University-of-Liverpool-logo.gif" height="50" alt="" style="float: right;"></img>
				</c:if>
				<c:if test="${programType=='MoRDa'}">
				<img src="./images/morda.png" height="80" alt="" style="float: left; padding-right: 5em; "></img>
				</c:if>
				<c:if test="${programType=='Zanuda'}">
				<img src="./images/zanudamistic.jpg" height="80" alt="" style="float: left; padding-right: 1em; "></img>
				</c:if>

				<h2><%=programType%></h2>

				<c:if test="${programType=='MoRDa'}">
				<p>
				Please cite the following paper, if you used a solution from MoRDa:<br/>
				A. Vagin, A. Lebedev, <em>Acta Cryst.</em> (2015). A71, s19
				</p>

				<p>MoRDa <a href="http://www.biomexsolutions.co.uk/morda">homepage</a> contains more details and instructions for local installation.</p>
				</c:if>

				<c:if test="${programType=='Zanuda'}">
				<p>
				Please cite the following paper if you found Zanuda results useful:<br/>
				Lebedev, A. A. &amp; Isupov M. N. (2014). <em>Acta Cryst.</em> D<b>70</b>, 2430-2443.
				</p>
				</c:if>

				<p id="demo"></p>

				<c:if test="${sessionScope.submitError=='true'}">
					<p>
						<span class="error">&nbsp;Sorry, an error has occurred in
							this application! - please notify ccp4@stfc.ac.uk of this
							problem.</span>
					</p>

					<p>
						<c:set var="now" value="<%=new java.util.Date()%>" />
						Please include this time stamp in your report: ${now}
					</p>

					<p>You can also try to resubmit your job.</p>
					<c:set var="submitError" value="false" scope="session" />
				</c:if>

				<c:if test="${model.runnableProgramsType=='MrBUMP'}">
					<p>
						If you have any questions on running MrBUMP, please contact <a
							href="mailto:ronan.keegan@stfc.ac.uk">Ronan Keegan</a>.
					</p>
				</c:if>

				<br /> <a href="servlet/controller/RunnableProgramsTable"><strong>CLICK
						HERE TO START A NEW <%=programType.toUpperCase()%> RUN
				</strong></a> <br /> <br />

				<!--
                    <strong>NB: No new jobs will be started at the moment. The service will be up again in the next days.</strong>
                    <br/><br/>
                    -->

				<c:if
					test="${model.username=='testUser' and model.runnableProgramsType=='SHELX'}">
					<p>
						For developers only: <a
							href="servlet/controller/DownloadFile?file=SHELX/report.txt">Download
							the usage data.</a>
					</p>
				</c:if>

				<c:if test="${not empty startedId}">
					<div style="margin-bottom: 5px;" id="runstartingmessage">
						<span class='greenText'>&nbsp;Your run is starting (id =
							${startedId}) - please click on the 'results' link below&nbsp;</span>
					</div>
				</c:if>
				<div style="margin-bottom: 5px;" id="runtablemessage">The
					table below shows your current ${programType} runs - note that runs
					are automatically deleted after ${expTime} days</div>

				<!--
				<div id="currentRunsTable">
				-->
				<div>

					<!--<table id="jobtable">-->
					<table class="pure-table pure-table-striped" id="jobtable">

						<thead>
							<tr>
								<th>&nbsp;id&nbsp;</th>
								<th>&nbsp;Job Title&nbsp;</th>
								<th>&nbsp;Delete/Stop&nbsp;</th>
								<th>&nbsp;Date&nbsp;</th>
								<th>&nbsp;Status&nbsp;</th>
								<!--<a href='servlet/controller/RunnableProgramsRefreshTable'>REFRESH</a>&nbsp;-->
								<th>&nbsp;View Results&nbsp;</th>
							</tr>
						</thead>

						<tbody id="jobrows">
							<!--<tbody>-->
							<%
								List list = model.getProgramRunList();
								for (Iterator it = list.iterator(); it.hasNext();) {
									request.setAttribute("adminTable", it.next());
							%>
							<jsp:useBean id="adminTable" scope="request" type="model.Admin" />

							<%
								String deleteString = "";
									if (adminTable.getStatus().equals("process ended") || adminTable.getStatus().equals("process stopped")
											|| adminTable.getStatus().equals("stopping process")
											|| adminTable.getStatus().equals("process failed")) {
										deleteString = "<a onclick='return confirmSubmit(\"Are you sure you want to delete this program run?\")' href='servlet/controller/RunnableProgramsDeleteProcess?id="
												+ adminTable.getId() + "'>delete</a>";
									} else if (adminTable.getStatus().equals("process running")
											|| adminTable.getStatus().equals("starting process")
											|| adminTable.getStatus().equals("process queuing")) {
										deleteString = "<a onclick='return confirmSubmit(\"Are you sure you want to stop this program run?\")' href='servlet/controller/RunnableProgramsStopProcess?id="
												+ adminTable.getId() + "'>stop</a>";
									} else {
										deleteString = "N/A";
									}
							%>

							<%
								if (!adminTable.getStatus().equals("deleting run")) {
							%>
							<tr>
								<td><jsp:getProperty name="adminTable" property="id" /></td>
								<td><jsp:getProperty name="adminTable" property="title" /></td>
								<td><%=deleteString%></td>
								<td><jsp:getProperty name="adminTable" property="date" /></td>
								<td><span class="status"><jsp:getProperty
											name="adminTable" property="status" /></span></td>
								<td>&nbsp;<a
									href="servlet/controller/RunnableProgramsViewResults?id=<%=adminTable.getId()%>">results</a>&nbsp;
								</td>
							</tr>
							<%
								}
							%>

							<%
								}
							%>
						</tbody>

					</table>

				</div>

				<br /> <br />

			</div>

			<div class="clear">&nbsp;</div>

		</div>

	</div>

	<jsp:include page="WEB-INF/jspf/footer.jspf" />

	<script>
		var statsElem = document.getElementById("stats");
		var showElem = document.getElementById("showStats");
		var showThem = false;
		var showStats = function() {
			console.log("button clicked");
			if (showThem) {
				showThem = false;
				statsElem.style.display = 'none';
				showElem.innerHTML = "See the usage statistics";
			} else {
				showThem = true;
				statsElem.style.display = 'table';
				showElem.innerHTML = "Hide the usage statistics";
			}
		}
		var n = 0;
		$(document).ready(function() {
			$.ajaxSetup({
				cache : false
			}); //<!-- Stops IE from caching data //-->
			setInterval("update()", 30000); // update the list every 30 s
			$('#runstartingmessage').delay(10000).fadeOut();
		});
		function update() {
			$
					.getJSON(
							"./rest/${model.runnableProgramsType}/${model.username}",
							function(data) {
								var items = [];
								$
										.each(
												data,
												function(i, admin) {
													if (admin.status != "deleting run") {
														var date = admin.day
																+ "&nbsp;"
																+ admin.month
																+ "&nbsp;"
																+ admin.year
																+ "&nbsp;["
																+ admin.hour
																+ ":"
																+ admin.minute
																+ "]";
														var deleteString = (admin.status == "process ended"
																|| admin.status == "process stopped"
																|| admin.status == "stopping process" || admin.status == "process failed") ? "<a onclick='return confirmSubmit(\"Are you sure you want to delete this program run?\")' href='servlet/controller/RunnableProgramsDeleteProcess?id="
																+ admin.id
																+ "'>delete</a>"
																: "N/A";
														if (admin.status == "process running"
																|| admin.status == "starting process"
																|| admin.status == "process queuing") {
															deleteString = "<a onclick='return confirmSubmit(\"Are you sure you want to stop this program run?\")' href='servlet/controller/RunnableProgramsStopProcess?id="
																	+ admin.id
																	+ "'>stop</a>"
														}
														items
																.push("<tr class='jobrow' id='" + admin.id + "'><td>"
																		+ admin.id
																		+ '</td><td>'
																		+ admin.title
																		+ '</td><td>'
																		+ deleteString
																		+ '</td><td>'
																		+ date
																		+ '</td><td><span class="status">'
																		+ admin.status
																		+ '</span></td><td>'
																		+ '&nbsp;<a href="servlet/controller/RunnableProgramsViewResults?id='
																		+ admin.id
																		+ '">results</a>&nbsp;'
																		+ "</tr>");
													}
													;
												});
								$("#jobrows").remove();
								$('#jobtable').append($("<tbody/>", {
									"id" : "jobrows",
									html : items.join("")
								}));
								n++;
								//$('#demo').html("No. updates: "+n);
							});
		}
	</script>
</body>

</html>
