<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page errorPage="ErrorPage.jsp"%>
<%@ page import="model.*"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session" />

<%
	if (model.getUsername().equals("")) {
		throw new ServletException("No model found in runnableProgramsRunmain.shelx.jsp ");
	}
%>

<!--  job id -->
<c:if test="${not empty param.id}">
	<c:set var="id" value="${param.id}" />
</c:if>
<c:if test="${empty param.id}">
	<c:set var="id" value="${model.uniqueId}" />
</c:if>
<c:set target="${model}" property="runnableProgramsExistingId"
	value="${id}" />
<c:set target="${model}" property="userDir"
	value="${runnableProgramsInputBaseDir}/${programType}/${model.username}" />

<c:set var="programType" value="${model.runnableProgramsType}" />
<c:set var="navBar"
	value="<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsTable.jsp'>${programType}</a>&nbsp;>&nbsp;New ${programType} Run" />

<!DOCTYPE html>

<html lang="EN">
<head>
<title>CCP4 online</title>
<meta charset="UTF-8"></meta>
<link rel="stylesheet"
	href="http://yui.yahooapis.com/pure/0.6.0/pure-min.css">
<%@include file="initialisation.jsp"%>
</head>

<body>

	<div id="container">

		<%@ include file="./header.jsp"%>

		<div id="header">
			<div id="breadcrumb">
				<ul>
					<div id='leftNav'>${navBar}</div>
					<div id='rightNav'>
						Username: <strong>${model.username}</strong>
					</div>
				</ul>
				<div class="clear">&nbsp;</div>
			</div>
		</div>

		<div id="content-container">

			<div id="container2">

				<ul style="display: flex; justify-content: space-between; list-style: none;">
				<li><img src="./images/Leiden-University-Logo.png" height="70" alt=""></img></li>
				<li><img src="./images/goettingen.jpg" height="60" alt=""></img></li>
				</ul>

				<h2>New ${programType} Run</h2>
				
				<!-- Include the form.
				Static (compile-time) include is more efficient in this case, 
				as the same fragment is always used. -->
				<%@include file="shelxForm.jsp" %>

				<br />

				<div class="clear">&nbsp;</div>

			</div>

		</div>

	</div>

	<jsp:include page="WEB-INF/jspf/footer.jspf" />

</body>

</html>

