<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page errorPage="ErrorPage.jsp"%>
<%@ page import="model.*"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session" />

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/2002/REC-xhtml1-20020801/DTD/xhtml1-transitional.dtd">

<%
	if (model.getUsername().equals(""))
		throw new ServletException(
				"No model found in runnableProgramsRunAMPLE.jsp ");
%>

<%
	String programType = model.getRunnableProgramsType();
	String navBar = "<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsTable.jsp'>"
			+ programType
			+ "</a>&nbsp;>&nbsp;New "
			+ programType
			+ " Run";
%>

<c:set target="${model}" property="userDir" value="${runnableProgramsInputBaseDir}/${programType}/${model.username}" />
<c:set var="id" value="${model.uniqueId}" />
<c:set target="${model}" property="runnableProgramsExistingId" value="${id}" />

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="EN" lang="EN">
<head>
<title>CCP4 online</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"></meta>
<%@include file="initialisation.jsp"%>
</head>

<body>

	<div id="container">

		<%@ include file="./header.jsp"%>

		<div id="header">
			<div id="breadcrumb">
				<ul>
					<div id='leftNav'><%=navBar%></div>
					<div id='rightNav'>
						Username: <strong><%=model.getUsername()%></strong>
					</div>
				</ul>
				<div class="clear">&nbsp;</div>
			</div>
		</div>

		<div id="content-container">

			<div id="container2">

				<p>
				<img src="./images/University-of-Liverpool-logo.gif" height="60" alt=""></img>
				</p>

				<h2>
					New
					<%=programType%>
					Run
				</h2>
				
				<p>
				To generate QUARK models for use with AMPLE, please use the 
				<a href="http://zhanglab.ccmb.med.umich.edu/QUARK/" target="blank">QUARK server</a>.
				This will give you a file decoys.tar.gz which you can input below using 
				the "PDB models" option.
				</p>

				<p> The file formats accepted for input are <a
					href='http://www.weizmann.ac.il/Chemical_Research_Support//xraylab/manuals/CCP4v4.2.2/html/mtzlib.html#fileformat'
					target="blank">mtz</a> and <a
					href='http://www.ebi.ac.uk/msd/documentation/mmcif.html'
					target="blank">cif</a> (structure factors) and <a
					href="javascript:showHelp4()">FASTA</a> (sequence target). The PDB models
					file can be a zip file or a tar file compressed with gzip or bzip2 
					(file extensions .zip, .tgz, .tar.gz or .tar.bz2).
				</p>

				<!-- FILE ERRORS -->
				<%
					Vector errorVector = model.getProgramRunErrors();

					for (int i = 0; i < errorVector.size(); i++) {
						String error = (String) errorVector.elementAt(i);
				%>
				<span class='error'>&nbsp;<%=error%>&nbsp;
				</span><br />
				<%
					}
				%>

				<!-- FORM -->
				<div id="form">

					<form method="post" enctype="multipart/form-data"
						action="servlet/controller/RunnableProgramsRun">

						<input type="hidden" name="id" value="${id}" />

						<table>
                            <tr>
                                <th>&nbsp;Job title (optional):&nbsp;</th>
                                <td>&nbsp;<input name="jobtitle" maxlength="30" />&nbsp;</td>
                            </tr>

							<tr>
								<th>&nbsp;Structure Factors:&nbsp;</th>
								<td>&nbsp;<input type="file" name="structureFactorsFile"
									size="75" />&nbsp;
								</td>
							</tr>

							<tr>
								<th>&nbsp;Sequence Target:&nbsp;</th>
								<td>&nbsp;<input type="file" name="sequenceTargetFile"
									size="75" />&nbsp;
								</td>
							</tr>

							<tr>
								<th>&nbsp;</th>
								<td><strong>&nbsp;Instead of entering a Sequence
										Target file you can paste your <a
										href="javascript:showHelp4()">FASTA</a> sequence below:
								</strong> <br /> <strong>&nbsp;(Note that a comment line
										beginning with a '>' character must precede the sequence)</strong></td>
							</tr>

							<tr>
								<th>&nbsp;</th>
								<td><textarea class="textarea2"
										name="sequenceTargetTextarea" rows="10" cols="60"></textarea></td>
							</tr>

							<tr>
								<th>&nbsp;PDB Models:&nbsp;</th>
								<td>&nbsp;<input type="file" name="zipfile"
									size="75" />&nbsp;
								</td>
							</tr>


						</table>

						<p>
							<input type="submit" class="submit" value="Submit" /> (after
							clicking submit, <strong>PLEASE WAIT</strong> for your files to
							upload - this may take some time)
						</p>

					</form>

				</div>
				
				<p>
				<a target="blank_" href="http://ccp4wiki.org/~ccp4wiki/wiki/index.php?title=Ab_initio_modelling_and_automated_molecular_replacement_with_AMPLE">AMPLE</a> 
				is a joint initiative between 
				<a target="blank_" href="http://www.liv.ac.uk/integrative-biology/">University of Liverpool</a> and 
				<a target="blank_" href="http://www.ccp4.ac.uk/">CCP4</a> 
				researchers.  Its development is led by 
				<a target="blank_" href="https://www.liv.ac.uk/integrative-biology/staff/daniel-rigden/">Dan Rigden</a>.  
				This server was put together by 
				<a target="blank_" href="http://www.ccp4.ac.uk/">Ronan Keegan</a> 
				and 
				<a target="blank_" href="https://scholar.google.co.uk/citations?user=hbEI428AAAAJ&hl=en">Jens Thomas</a> 
				with input from core CCP4 staff.
				</p>

				<br /> <br /> <br /> <br /> <br /> <br />

				<div class="clear">&nbsp;</div>

			</div>

		</div>

		<jsp:include page="WEB-INF/jspf/footer.jspf" />
</body>

</html>

