(function(module) {
  var ShelxCtrl = function($scope, $log, submitForm) {
    // controller for the SHELX/CRANK2 input form in runnableProgramsRunSHELX.jsp
    var _this = this;
    _this.submitForm = submitForm;
    _this.$log = $log;
    _this.inputType = null;
    $scope.init = function() {
      _this.init();
    };
    $scope.changeExperimentType = function(experimentType) {
      _this.init();
      _this.changeExperimentType(experimentType);
    };
    $scope.checkFile = function(label) {
      return _this.checkFile(label);
    };
    $scope.checkSubstructureAtom = function(atom) {
      _this.checkSubstructureAtom(atom);
    };
    $scope.validate = function(atom) {
      _this.validate();
    };
    $scope.validateOnServer = function() {
      var valid = _this.validate();
      // _this.validateOnServer();
      if (!valid) {
        $scope.$parent.$broadcast('submit', {
          errors : _this.shelx.errors
        });
      } else {
        _this.shelx.validated = true;
        _this.shelx.notvalidated = false;
      }
      ;
    };
    $scope.validateOnClient = function() {
      var valid = _this.validate();
      if (!valid) {
        $scope.$parent.$broadcast('submit', {
          errors : _this.shelx.errors
        });
      } else {
        _this.shelx.validated = true;
        _this.shelx.notvalidated = false;
      }
      ;
    };
    $scope.submit = function() {
      var valid = _this.validate();
      if (valid) {
        _this.shelx.submitted = true;
        _this.submit();
      } else {
        $scope.$parent.$broadcast('submit', {
          errors : _this.shelx.errors
        });
      }
    };
    $scope.init();
  }

  // initialize the data model
  ShelxCtrl.prototype.init = function() {
    var _this = this;
    _this.shelx = {};
    _this.shelx.error = null;
    _this.shelx.files = {};
    _this.shelx.experimentType = null;
    _this.shelx.substructureAtom = "Se";
    _this.shelx.isSulphur = false;
    _this.shelx.isSAD = false;
    _this.shelx.isSIRAS = false;
    _this.shelx.isMAD = false;
    _this.shelx.nwl = 0; // number of wavelengths
    _this.shelx.askNative = false; // whether to ask for the native dataset
    _this.shelx.optional = false; // whether the native dataset is
    _this.shelx.files.structureFactorsFile1 = {};
    _this.shelx.files.structureFactorsFile2 = {};
    _this.shelx.files.structureFactorsFile3 = {};
    _this.shelx.files.structureFactorsFile4 = {};
    _this.shelx.files.structureFactorsFileNative = {};
    _this.shelx.validated = false;
    _this.shelx.notvalidated = true;
    _this.shelx.cellrequired = false;
    _this.shelx.cell = null;
    _this.shelx.spacegroup = null;
    _this.shelx.submitted = false;
    _this.shelx.nosubstructureatomstext = "No. of substruct. atoms in asymmetr. unit";
    _this.shelx.num_resid = null;
    _this.shelx.sequence = null;
    _this.shelx.files.sequenceFile = {};
  };

  ShelxCtrl.prototype.changeExperimentType = function(experimentType) {
    this.shelx.experimentType = experimentType;
    switch (experimentType) {
      case "SAD":
        this.shelx.isSAD = true;
      this.shelx.isSIRAS = false;
      this.shelx.isMAD = false;
      this.shelx.nwl = 1;
      this.shelx.askNative = true;
      this.shelx.Optional = true;
      break;
      case "SIRAS":
        this.shelx.isSAD = false;
      this.shelx.isSIRAS = true;
      this.shelx.isMAD = false;
      this.shelx.nwl = 1;
      this.shelx.askNative = true;
      this.shelx.Optional = false;
      break;
      case "MAD2":
        this.shelx.isSAD = false;
      this.shelx.isSIRAS = false;
      this.shelx.isMAD = true;
      this.shelx.nwl = 2;
      this.shelx.askNative = true;
      this.shelx.Optional = true;
      break;
      case "MAD3":
        this.shelx.isSAD = false;
      this.shelx.isSIRAS = false;
      this.shelx.isMAD = true;
      this.shelx.nwl = 3;
      this.shelx.askNative = true;
      this.shelx.Optional = true;
      break;
      case "MAD4":
        this.shelx.isSAD = false;
      this.shelx.isSIRAS = false;
      this.shelx.isMAD = true;
      this.shelx.nwl = 4;
      this.shelx.askNative = true;
      this.shelx.Optional = true;
      break;
    }
  };

  ShelxCtrl.prototype.checkFile = function(label) {
    var _this = this;
    var filename = "";
    var str = "";
    if(label.match(/structureFactorsFile/)) {
      try {
        filename = _this.shelx.files[label].file.name;
        str = filename.split('.').pop();
      } catch (err) {
        _this.shelx.files[label] = {};
      }
      var ext = str.toLowerCase();
      if (ext == 'mtz') {
        _this.shelx.files[label].isMTZ = true;
        _this.shelx.files[label].isSCA = false;
        _this.shelx.files[label].ishkl = false;
      } else if (ext == 'sca') {
        _this.shelx.files[label].isMTZ = false;
        _this.shelx.files[label].isSCA = true;
        _this.shelx.files[label].ishkl = false;
      } else if (ext == 'hkl') {
        _this.shelx.files[label].isMTZ = false;
        _this.shelx.files[label].isSCA = false;
        _this.shelx.files[label].ishkl = true;
      } else {
        _this.shelx.files[label].isMTZ = false;
        _this.shelx.files[label].isSCA = false;
        _this.shelx.files[label].ishkl = false;
      }
      // Decide whether the cell parameters and the spacegroup are required.
      // logic: The native cell is preferred, if available. If not available, and
      // none of the datasets are in MTZ format, then ask for the cell and
      // spacegroup. If native set is selected, it's type determines whether the
      // cell is required. If the native set is not selected, if any of the
      // selected files is MTZ format, then the cell is not required.
      _this.shelx.cellrequired = true;
      _.forEach(_this.shelx.files, function(f, label) {
        if (label.match(/structureFactorsFile/) && f.isMTZ) {
          _this.shelx.cellrequired = false;
        }
      });
      _.forEach(_this.shelx.files, function(f, label) {
        if (label.match(/Native/) && f.file) {
          _this.shelx.cellrequired = !f.isMTZ;
        }
      });
    };
    return ext;
  };

  ShelxCtrl.prototype.checkSubstructureAtom = function(atom) {
    var _this = this;
    if (atom == "S") {
      _this.shelx.isSulphur = true;
    } else {
      _this.shelx.isSulphur = false;
    }
  };

  // this is not used
  ShelxCtrl.prototype.submit = function() {
    var postUrl = './servlet/controller/RunnableProgramsRun';
    this.submitForm.submitFormToUrl(postUrl, true);
  };

  ShelxCtrl.prototype.validateOnServer = function() {
    var postUrl = './servlet/controller/RunnableProgramsRun';
    this.submitForm.submitFormToUrl(postUrl, false);
  }

  ShelxCtrl.prototype.validate = function() {
    var _this = this;
    var valid = true;
    _this.shelx.errors = [];
    //if (job.programType == 'SHELX' && !_this.shelx.licence) {
    //  _this.shelx.error = "You have to accept the SHELX licence!";
    //  _this.shelx.errors.push("You have to accept the SHELX licence!");
    //  valid = false;
    //};
    if(!_this.shelx.num_resid && !_this.shelx.sequence && !_this.shelx.files.sequenceFile.file) {
      _this.shelx.error = "You have to give either the sequence target or the number of residues!";
      _this.shelx.errors.push("You have to give either the sequence target or the number of residues!");
      valid = false;
    }
    if(_this.shelx.num_resid && (_this.shelx.sequence || _this.shelx.files.sequenceFile.file)) {
      _this.shelx.error = "Please give either the sequence target or the number residues but not both!";
      _this.shelx.errors.push("Please give either the sequence target or the number residues but not both!");
      valid = false;
    }
    if (_this.shelx.cellrequired) {
      if (_.isEmpty(_this.shelx.cell)) {
        _this.shelx.error = "The cell parameters are missing!!";
        _this.shelx.errors.push("The cell parameters are missing!");
        valid = false;
      } else {
        if (!_this.shelx.cell.a) {
          _this.shelx.error = "The cell parameter a is missing!!";
          _this.shelx.errors.push("The cell parameter a is missing!");
          valid = false;
        }
        ;
        if (!_this.shelx.cell.b) {
          _this.shelx.error = "The cell parameter b is missing!!";
          _this.shelx.errors.push("The cell parameter b is missing!");
          valid = false;
        }
        ;
        if (!_this.shelx.cell.c) {
          _this.shelx.error = "The cell parameter c is missing!!";
          _this.shelx.errors.push("The cell parameter c is missing!");
          valid = false;
        }
        ;
        if (!_this.shelx.cell.alpha) {
          _this.shelx.error = "The cell parameter alpha is missing!!";
          _this.shelx.errors
          .push("The cell parameter alpha is missing!");
          valid = false;
        }
        ;
        if (!_this.shelx.cell.beta) {
          _this.shelx.error = "The cell parameter beta is missing!!";
          _this.shelx.errors
          .push("The cell parameter beta is missing!");
          valid = false;
        }
        ;
        if (!_this.shelx.cell.gamma) {
          _this.shelx.error = "The cell parameter gamma is missing!!";
          _this.shelx.errors
          .push("The cell parameter gamma is missing!");
          valid = false;
        }
        ;
      }
      ;
      if (!_this.shelx.spacegroup) {
        _this.shelx.error = "The spacegroup is missing!!";
        _this.shelx.errors.push("The spacegroup is missing!");
        valid = false;
      }
      ;
    }
    switch (_this.shelx.experimentType) {
      case 'SAD':
        if (!_this.shelx.files.structureFactorsFile1.file) {
        _this.shelx.error = "Anomalous dataset is missing!";
        _this.shelx.errors.push("Anomalous dataset is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile1.isMTZ && !_this.shelx.files.structureFactorsFile1.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile1.isSCA || _this.shelx.files.structureFactorsFile1.ishkl) && (!_this.shelx.fp1 || !_this.shelx.fpp1)) {
        _this.shelx.error = "f' and f'' are missing for the first dataset (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the first dataset (required for SCA or hkl input)!");
        valid = false;
      };
      break;
      case 'SIRAS':
        if (!_this.shelx.files.structureFactorsFile1.file) {
        _this.shelx.error = "Anomalous dataset is missing!";
        _this.shelx.errors.push("Anomalous dataset is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile1.isMTZ && !_this.shelx.files.structureFactorsFile1.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile1.isSCA || _this.shelx.files.structureFactorsFile1.ishkl) && (!_this.shelx.fp1 || !_this.shelx.fpp1)) {
        _this.shelx.error = "f' and f'' are missing for the first dataset (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the first dataset (required for SCA or hkl input)!");
        valid = false;
      }
      ;
      break;
      case 'MAD2':
        if (!_this.shelx.files.structureFactorsFile1.file) {
        _this.shelx.error = "Anomalous dataset #1 is missing!";
        _this.shelx.errors.push("Anomalous dataset #1 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile1.isMTZ && !_this.shelx.files.structureFactorsFile1.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #1 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #1 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType1) {
        _this.shelx.error = "The data type for the anomalous dataset #1 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #1 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile1.isSCA || _this.shelx.files.structureFactorsFile1.ishkl) && (!_this.shelx.fp1 || !_this.shelx.fpp1)) {
        _this.shelx.error = "f' and f'' are missing for the first dataset (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #1 (required for SCA or hkl input)!");
        valid = false;
      }
      ;
      if (!_this.shelx.files.structureFactorsFile2.file) {
        _this.shelx.error = "Anomalous dataset #2 is missing!";
        _this.shelx.errors.push("Anomalous dataset #2 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile2.isMTZ && !_this.shelx.files.structureFactorsFile2.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #2 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #2 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType2) {
        _this.shelx.error = "The data type for the anomalous dataset #2 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #2 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile2.isSCA || _this.shelx.files.structureFactorsFile2.ishkl) && (!_this.shelx.fp2 || !_this.shelx.fpp2)) {
        _this.shelx.error = "f' and f'' are missing for the dataset 2 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #2 (required for SCA or hkl input)!");
        valid = false;
      }
      ;
      break;
      case 'MAD3':
        if (!_this.shelx.files.structureFactorsFile1.file) {
        _this.shelx.error = "Anomalous dataset #1 is missing!";
        _this.shelx.errors.push("Anomalous dataset #1 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile1.isMTZ && !_this.shelx.files.structureFactorsFile1.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #1 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #1 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType1) {
        _this.shelx.error = "The data type for the anomalous dataset #1 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #1 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile1.isSCA || _this.shelx.files.structureFactorsFile1.ishkl) && (!_this.shelx.fp1 || !_this.shelx.fpp1)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #1 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #1 (required for SCA or hkl input)!");
        valid = false;
      };
      if (!_this.shelx.files.structureFactorsFile2.file) {
        _this.shelx.error = "Anomalous dataset #2 is missing!";
        _this.shelx.errors.push("Anomalous dataset #2 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile2.isMTZ && !_this.shelx.files.structureFactorsFile2.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #2 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #2 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType2) {
        _this.shelx.error = "The data type for the anomalous dataset #2 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #2 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile2.isSCA || _this.shelx.files.structureFactorsFile2.ishkl) && (!_this.shelx.fp2 || !_this.shelx.fpp2)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #2 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #2 (required for SCA or hkl input)!");
        valid = false;
      };
      if (!_this.shelx.files.structureFactorsFile3.file) {
        _this.shelx.error = "Anomalous dataset #3 is missing!";
        _this.shelx.errors.push("Anomalous dataset #3 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile3.isMTZ && !_this.shelx.files.structureFactorsFile3.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #3 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #3 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType3) {
        _this.shelx.error = "The data type for the anomalous dataset #3 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #3 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile3.isSCA || _this.shelx.files.structureFactorsFile3.ishkl) && (!_this.shelx.fp3 || !_this.shelx.fpp3)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #3 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #3 (required for SCA or hkl input)!");
        valid = false;
      };
      break;
      case 'MAD4':
        if (!_this.shelx.files.structureFactorsFile1.file) {
        _this.shelx.error = "Anomalous dataset #1 is missing!";
        _this.shelx.errors.push("Anomalous dataset #1 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile1.isMTZ && !_this.shelx.files.structureFactorsFile1.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #1 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #1 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType1) {
        _this.shelx.error = "The data type for the anomalous dataset #1 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #1 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile1.isSCA || _this.shelx.files.structureFactorsFile1.ishkl) && (!_this.shelx.fp1 || !_this.shelx.fpp1)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #1 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #1 (required for SCA or hkl input)!");
        valid = false;
      };
      if (!_this.shelx.files.structureFactorsFile2.file) {
        _this.shelx.error = "Anomalous dataset #2 is missing!";
        _this.shelx.errors.push("Anomalous dataset #2 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile2.isMTZ && !_this.shelx.files.structureFactorsFile2.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #2 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #2 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType2) {
        _this.shelx.error = "The data type for the anomalous dataset #2 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #2 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile2.isSCA || _this.shelx.files.structureFactorsFile2.ishkl) && (!_this.shelx.fp2 || !_this.shelx.fpp2)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #2 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #2 (required for SCA or hkl input)!");
        valid = false;
      };
      if (!_this.shelx.files.structureFactorsFile3.file) {
        _this.shelx.error = "Anomalous dataset #3 is missing!";
        _this.shelx.errors.push("");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile3.isMTZ && !_this.shelx.files.structureFactorsFile3.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #3 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #3 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType3) {
        _this.shelx.error = "The data type for the anomalous dataset #3 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #3 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile3.isSCA || _this.shelx.files.structureFactorsFile3.ishkl) && (!_this.shelx.fp3 || !_this.shelx.fpp3)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #3 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #3 (required for SCA or hkl input)!");
        valid = false;
      }
      ;
      if (!_this.shelx.files.structureFactorsFile4.file) {
        _this.shelx.error = "Anomalous dataset #4 is missing!";
        _this.shelx.errors.push("Anomalous dataset #4 is missing!");
        valid = false;
      } else if (_this.shelx.files.structureFactorsFile4.isMTZ && !_this.shelx.files.structureFactorsFile4.inputType) {
        _this.shelx.error = "The input type for the anomalous dataset #4 is missing!";
        _this.shelx.errors
        .push("The input type for the anomalous dataset #4 is missing!");
        valid = false;
      } else if (!_this.shelx.dataType4) {
        _this.shelx.error = "The data type for the anomalous dataset #4 is missing!";
        _this.shelx.errors
        .push("The data type for the anomalous dataset #4 is missing!");
        valid = false;
      } else if (job.programType == 'CRANK2' && (_this.shelx.files.structureFactorsFile4.isSCA || _this.shelx.files.structureFactorsFile4.ishkl) && (!_this.shelx.fp4 || !_this.shelx.fpp4)) {
        _this.shelx.error = "f' and f'' are missing for the dataset #4 (required for SCA or hkl input)!";
        _this.shelx.errors
        .push("f' and f'' are missing for the dataset #4 (required for SCA or hkl input)!");
        valid = false;
      }
      ;
      break;
    }
    if (_this.shelx.askNative && !_this.shelx.Optional && !_this.shelx.files.structureFactorsFileNative.file) {
      _this.shelx.error = "Native dataset is missing!";
      _this.shelx.errors.push("Native dataset is missing!");
      valid = false;
    } else if (_this.shelx.files.structureFactorsFileNative.file && _this.shelx.files.structureFactorsFileNative.isMTZ && !_this.shelx.files.structureFactorsFileNative.inputType) {
      _this.shelx.error = "The input type for the native dataset is missing!";
      _this.shelx.errors
      .push("The input type for the native dataset is missing!");
      valid = false;
    }
    ;
    return valid;
  }

  ShelxCtrl.$inject = [ '$scope', '$log', 'submitForm' ];

  module.controller('ShelxCtrl', ShelxCtrl);
}(angular.module('ShelxApp')));
