(function(module) {
  module
  .directive(
    // this directive allows inspection of the structure factors file, selected
    // by the user
    'fileModel',
    [
      '$parse',
      'shelxReader',
      function($parse, shelxReader) {
        return {
          restrict : 'A',
          link : function(scope, element, attrs) {
            var model = $parse(attrs.fileModel);
            var modelSetter = model.assign;
            element
            .bind(
              'change',
              function() {
                scope
                .$apply(function() {
                  modelSetter(scope,element[0].files[0]);
                  var file = model(scope);
                  // For this to work, the input element name must be the
                  // same as the model property name. Like this: <input
                  // type="file" name="fileLabel"
                  // ng-file-model="main.shelx.fileLabel.file"/>
                  var fileLabel = element[0].name;
                  var ext = scope.checkFile(fileLabel);
                  var type = "";
                  var updatecell = false;
                  if (fileLabel.match(/structureFactorsFile/)) {
                    type = 'dataset';
                    // update the cell parameters and spacegroup, if 1.
                    // they haven't been set yet or 2. it's a native
                    // dataset or this is replacing the previously
                    // selected file which gave the parameters
                    if (!scope.$parent.main.shelx.cell || fileLabel.match(/Native/)
                      || !scope.$parent.main.shelx.cellfilelabel
                        || scope.$parent.main.shelx.cellfilelabel == fileLabel) {
                          updatecell = true;
                        };
                  } else if (fileLabel.match(/sequenceTargetFile/)) {
                    type = 'sequence';
                  };
                  shelxReader.readFile(file,scope,type)
                  .then(
                    function(result) {
                    if (result.type == 'mtz') {
                      scope.$parent.main.shelx.files[fileLabel].columns = result.columns;
                      scope.$parent.main.shelx.files[fileLabel].columnTypes = result.columnTypes;
                    } else if (result.type == 'sca' || result.type == 'XDS') {
                      scope.$parent.main.shelx.files[fileLabel].cell = result.cell;
                      if (result.type == 'sca') {
                        scope.$parent.main.shelx.files[fileLabel].spacegroup = result.spacegroup;
                      }
                      if (updatecell) {
                        scope.$parent.main.shelx.cell = result.cell;
                        if (result.type == 'sca') {
                          scope.$parent.main.shelx.spacegroup = result.spacegroup;
                        }
                        scope.$parent.main.shelx.cellfilelabel = fileLabel;
                      };
                    };
                    return result;
                  })
                  .then(
                    function(result) {
                    // console.log(result);
                    var eventname = 'upload_' + element[0].name;
                    var filename = element[0].files[0].name;
                    // publish the event
                    scope.$parent.$broadcast(eventname,result);
                  });
                });
              });
          }
        };
      } ]);

      module
      .directive(
        'mtzLabels',
        // this directive is used for selecting the mtz file column labels
        [
          '$parse',
          'shelxReader',
          function($parse, shelxReader) {
            return {
              restrict : 'A',
              scope : true,
              link : function(scope, element, attrs) {
                var parent = scope.$parent;
                var mtzFileGetter = $parse(attrs.mtzLabels);
                var fileLabel = attrs.mtzLabels.split('.').slice(-2, -1)[0]; 
                // should be 'structureFactorsFile1' or similar
                var sortColumnLabels = shelxReader.sortColumnLabels;
                var eventname = 'upload_' + fileLabel;
                scope.tag = attrs.myTag;
                scope.friedel = (scope.tag == 'Native') ? false : true;
                scope.columnLabels = {
                  found : false
                };
                var columnTypes = null;
                scope.changeInputType = function(inputType) {
                  parent.main.shelx.files[fileLabel].inputType = inputType;
                  if (inputType == "intensities") {
                    if (scope.friedel) {
                      columnTypes = [ 'K', 'M' ];
                    } else {
                      columnTypes = [ 'J', 'Q' ];
                    }
                  } else if (inputType == "amplitudes") {
                    if (scope.friedel) {
                      columnTypes = [ 'G', 'L' ];
                    } else {
                      columnTypes = [ 'F', 'Q' ];
                    }
                  } else {
                    parent.main.shelx.files[fileLabel].inputType = undefined;
                  };
                  if (columnTypes) {
                    scope.updateColumnLabels(columnTypes);
                  }
                };
                scope.updateColumnLabels = function(requiredColumnTypes) {
                  var itype = requiredColumnTypes[0];
                  var sigtype = requiredColumnTypes[1];
                  if (parent.main.shelx.files[fileLabel].columns) {
                    var columns = parent.main.shelx.files[fileLabel].columns;
                    var columnTypes = parent.main.shelx.files[fileLabel].columnTypes;
                    scope.message = "reading the headers...";
                    var columns1 = _.chain(columns).zip(columnTypes).filter(function(pair) {
                      return pair[1] == itype}).unzip().value()[0] || [];
                      var columns2 = _.chain(columns).zip(columnTypes).filter(function(pair) {
                        return pair[1] == sigtype}).unzip().value()[0] || [];
                        if (columns1.length > 0 && columns2.length > 0) {
                          scope.columnLabels = {found : true};
                          if (itype == 'K' || itype == 'G') {
                            scope.columnLabels.plus = sortColumnLabels(columns1, '+');
                            scope.plus = scope.columnLabels.plus[0];
                            scope.columnLabels.sigplus = sortColumnLabels(columns2, '+');
                            scope.sigplus = scope.columnLabels.sigplus[0];
                            scope.columnLabels.minus = sortColumnLabels(columns1, '-');
                            scope.minus = scope.columnLabels.minus[0];
                            scope.columnLabels.sigminus = sortColumnLabels(columns2, '-');
                            scope.sigminus = scope.columnLabels.sigminus[0];
                          } else {
                            scope.columnLabels.avg = columns1;
                            scope.avg = scope.columnLabels.avg[0];
                            scope.columnLabels.sigavg = columns2;
                            scope.sigavg = scope.columnLabels.sigavg[0];
                          };
                          scope.message = "";
                        } else {
                          scope.columnLabels = {found : false};
                          scope.message = "No suitable data found!";
                        };
                  }
                };
                // TODO
                var mtzListener = scope.$on(eventname,function(event, data) {});
              },
              templateUrl : './resources/shelx/mtzlabels.html'
            };
          }]);

          module
          .directive(
            'errors',
            [
              '$timeout',
              function($timeout) {
                return {
                  restrict : 'E',
                  replace : true,
                  template : '<p ng-repeat="error in errors" class="error">{{error}}</p>',
                  link : function(scope, element, attrs) {
                    scope.$on('submit', function(event, data) {
                      scope.errors = data.errors;
                      $timeout(function() {
                        scope.errors = null;
                      }, 5000);
                    });
                  }
                }
              }
            ]); 

            module.directive('submit', function() {
              return {
                restrict : 'E',
                replace : true,
                scope : false,
                templateUrl : './resources/shelx/submit.html',
                link : function(scope, element, attrs) {
                }
              };
            });

            module.directive('validate', function() {
              return {
                restrict : 'E',
                replace : true,
                scope : false,
                templateUrl : './resources/shelx/validate.html',
                link : function(scope, element, attrs) {
                }
              };
            });

}(angular.module('ShelxApp')));
