package util;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.google.gson.Gson;

import model.Model;
import model.Admin;

/**
 * Servlet implementation class JobServlet
 */
@WebServlet(description = "a servlet for retrieving data from the jobs and submitting data to them", urlPatterns = { "/api/*" })
public class RestServlet extends HttpServlet {
	// not ready!
	private static final long serialVersionUID = 1L;

	private class RestRequest {
		// Accommodate two requests, one for all jobs for one user, another for
		// a specific job
		private Pattern regExAllPattern = Pattern
				.compile("/(?<program>[^\\s/]+)/(?<user>[^\\s/]+)/?+");
		private Pattern regExIdPattern = Pattern
				.compile("/(?<program>[^\\s/]+)/(?<user>[^\\s/]+)/(?<id>[0-9]+)");

		private String program;
		private String user;
		private int id = 0;

		public RestRequest(String pathInfo) throws ServletException {
			// regex parse pathInfo
			Matcher matcher;

			// Check for ID case first, since the All pattern would also match
			matcher = regExIdPattern.matcher(pathInfo);
			if (matcher.find()) {
				program = matcher.group("program");
				user = matcher.group("user");
				id = Integer.parseInt(matcher.group("id"));
				return;
			}

			matcher = regExAllPattern.matcher(pathInfo);
			if (matcher.find()) {
				program = matcher.group("program");
				user = matcher.group("user");
				return;
			}

			throw new ServletException("Invalid URI");
		}

		public String getProgram() {
			return program;
		}

		public void setProgram(String program) {
			this.program = program;
		}

		public String getUser() {
			return user;
		}

		public void setUser(String user) {
			this.user = user;
		}

		public Integer getId() {
			return id;
		}

		public void setId(Integer id) {
			this.id = id;
		}
	}

	/**
	 * @see HttpServlet#HttpServlet()
	 */
	public RestServlet() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		HttpSession session = request.getSession();
		String pathinfo = request.getPathInfo();
		PrintWriter out = response.getWriter();

		String program;
		String user;
		int id;
		Model model = null;

		try {
			RestRequest resourceValues = new RestRequest(pathinfo);
			program = resourceValues.getProgram();
			user = resourceValues.getUser();
			id = resourceValues.getId();
			boolean loggedIn = false;
			try {
				model = (Model) session.getAttribute("model");
				String username = model.getUsername();
				if (!username.equals("") && username.equals(user)) {
					loggedIn = true;
				}
			} catch (Exception e) {
				loggedIn = false;
			}
			if (!loggedIn) {
				response.setStatus(403);
			} else {
				if(id > 0) {
					// get the job status 
					model.setRunnableProgramsExistingId(Integer.toString(id));
					model.setRunnableProgramsType(program);
					String status = model.getRunnableProgramsExistingStatus();
					Admin admin = new Admin();
					admin.setStatus(status);
					response.setContentType("application/json");
			        response.setCharacterEncoding("UTF-8");
			        out.print(new Gson().toJson(admin));
				} else {
					// get the list of job ids
					List<Admin> list = model.getProgramRunList();
					response.setContentType("application/json");
			        response.setCharacterEncoding("UTF-8");
			        out.print(new Gson().toJson(list));
				}
			}
		} catch (ServletException e) {
			response.setStatus(400);
			response.resetBuffer();
			e.printStackTrace();
			out.println(e.toString());
		} catch (ParseException e) {
			response.setStatus(400);
			response.resetBuffer();
			e.printStackTrace();
			out.println(e.toString());
		} catch (Exception e) {
			response.setStatus(400);
			response.resetBuffer();
			e.printStackTrace();
			out.println(e.toString());
		}
		out.close();
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse
	 *      response)
	 */
	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

	/**
	 * @see HttpServlet#doPut(HttpServletRequest, HttpServletResponse)
	 */
	protected void doPut(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

	/**
	 * @see HttpServlet#doDelete(HttpServletRequest, HttpServletResponse)
	 */
	protected void doDelete(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
