package util;


import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import model.Model;

/**
 * Servlet implementation class ErrorServlet
 */
@WebServlet("/ErrorHandler")
public class ErrorServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private Logger logger = LoggerFactory.getLogger("util.ErrorServlet");
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public ErrorServlet() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		Throwable throwable = (Throwable) request.getAttribute("javax.servlet.error.exception");
		Integer statusCode = (Integer) request.getAttribute("javax.servlet.error.status_code");
		String servletName = (String) request.getAttribute("javax.servlet.error.servlet_name");
		if(servletName == null) {
			servletName = "Unknown";
		}
		String requestUri = (String) request.getAttribute("javax.servlet.error.request_uri");
		if(requestUri == null) {
			requestUri = "Unknown";
		}
		HttpSession session = request.getSession();
		logger.debug("ErrorServlet#doGet: " + requestUri);
		String next = "/ErrorPage2.jsp";
		String runpage = "servlet/controller/RunnableProgramsRun";
		String viewpage = "servlet/controller/RunnableProgramsViewResults";
		if(requestUri.endsWith(runpage)) {
			Model model = (Model) session.getAttribute("model");
			String programType = model.getRunnableProgramsType();
			logger.debug("Error occurred when trying to run " + programType);
			next = runpage.replace("RunnableProgramsRun", "RunnableProgramsList?runnableProgramsType="+programType);
			session.setAttribute("submitError", "true");
		} else {
			try {
				session.invalidate();
			} catch(Exception e) {
			}
		}
		RequestDispatcher rd = request.getRequestDispatcher(next);
        rd.forward(request, response);
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doGet(request,response);
	}

}
