package rest.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetPropertyValues {
	
	public String getProperty(String propertyName) {
		// read the property values from the config.properties file, which should be in the class path
		Properties prop = new Properties();
		String propFileName = "config.properties";
		
		try (InputStream input = getClass().getClassLoader().getResourceAsStream(propFileName)) {
			prop.load(input);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		String propVal = resolveEnvVars(prop.getProperty(propertyName));
		return propVal;
	}
	
	private String resolveEnvVars(String input) {
		if(input == null) {
			return null;
		}
		Pattern p = Pattern.compile("\\$\\{(\\w+)\\}|\\$(\\w+)");
		Matcher m = p.matcher(input);
		StringBuffer sb = new StringBuffer();
		while(m.find()) {
			String envVarName = m.group(1) == null ? m.group(2) : m.group(1);
			String envVarValue = System.getenv(envVarName);
			m.appendReplacement(sb, envVarValue == null ? "" : envVarValue);
		}
		m.appendTail(sb);
		return sb.toString();
	}

}