package rest.data;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

public class JobnameFilter implements FilenameFilter {
	
	private String mustexist;
	
	public JobnameFilter(String fname) {
		mustexist = fname;
	}

	@Override
	public boolean accept(File dir, String name) {
		return (new File(dir.toString() + File.separator + name, mustexist).exists() 
				&& Pattern.matches("^\\d+$", name));
	}

}
