package model;

import java.util.*;
import java.util.regex.Pattern;
import java.security.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;

import org.apache.commons.io.input.ReversedLinesFileReader;

public class Utility {

	/* encrypt password */
	private static char[] map1 = new char[64];

	static {
		int i = 0;
		for (char c = 'A'; c <= 'Z'; c++)
			map1[i++] = c;
		for (char c = 'a'; c <= 'z'; c++)
			map1[i++] = c;
		for (char c = '0'; c <= '9'; c++)
			map1[i++] = c;
		map1[i++] = '+';
		map1[i++] = '/';
	}

	public static String encryptPassword(String password) throws Exception {
		byte[] raw = null;

		try {
			MessageDigest md = MessageDigest.getInstance("MD5");
			md.update(password.getBytes("UTF-8"));
			raw = md.digest();
		} catch (Exception e) {
			throw e;
		}

		password = String.valueOf(encode(raw));
		return password;
	}

	/* utility encryption method */
	public static char[] encode(byte[] in) {
		int iLen = in.length;
		int oDataLen = (iLen * 4 + 2) / 3; // output length without padding
		int oLen = ((iLen + 2) / 3) * 4; // output length including padding
		char[] out = new char[oLen];
		int ip = 0;
		int op = 0;
		while (ip < iLen) {
			int i0 = in[ip++] & 0xff;
			int i1 = ip < iLen ? in[ip++] & 0xff : 0;
			int i2 = ip < iLen ? in[ip++] & 0xff : 0;
			int o0 = i0 >>> 2;
			int o1 = ((i0 & 3) << 4) | (i1 >>> 4);
			int o2 = ((i1 & 0xf) << 2) | (i2 >>> 6);
			int o3 = i2 & 0x3F;
			out[op++] = map1[o0];
			out[op++] = map1[o1];
			out[op] = op < oDataLen ? map1[o2] : '=';
			op++;
			out[op] = op < oDataLen ? map1[o3] : '=';
			op++;
		}
		return out;
	}

	public static String getRandomString(int length) {
		Random rnd = new Random();
		char c1 = 'A';
		int nc = 26;
		StringBuilder sb = new StringBuilder();
		for (int j = 0; j < length; ++j) {
			sb.append((char) (c1 + rnd.nextInt(nc)));
		}
		return sb.toString();
	}

	public static String tail(File file) {
		// tries to read the last non-empty line of the file
		String lastline = "";
		try (BufferedReader br = new BufferedReader(new FileReader(file))) {
			List<String> buffer = new ArrayList<>();
			String line = "";
			while ((line = br.readLine()) != null) {
				buffer.add(line);
			}
			for (int i = buffer.size() - 1; i >= 0; i--) {
				line = buffer.get(i);
				if (!Pattern.matches("^\\s*$", line)) {
					lastline = line;
					break;
				}
			}
		} catch (Exception ex) {
		}
		return lastline;
	}

	public static String tail2(File file) {
		String lastline = "";
		// tries to read the last line of the file. This version uses the Apache
		// Commons IO library
		// NB. This may not work.
		try (ReversedLinesFileReader reader = new ReversedLinesFileReader(file)) {
			lastline = reader.readLine();
		} catch (Exception ex) {
		}
		return lastline;
	}
}
