package model;

import java.io.*;
import java.util.*;
import java.sql.*;
import model.*;

public class Register implements Serializable {
    
    /* private properties */
    private String username = "";
    private String password = "";
    private String reEnterPassword = "";
    private String institution = "";
    private String email = "";
    private String usernameError = "";
    private String passwordError = "";
    private String reEnterPasswordError = "";
    private String institutionError = "";
    private String emailError = "";
    
    public String getUsername() {
        return username;
    }
    
    public String getPassword() {
        return password;
    }
    
    public String getReEnterPassword() {
        return reEnterPassword;
    }
    
    public String getInstitution() {
        return institution;
    }
    
    public String getEmail() {
        return email;
    }
    
    public String getUsernameError() {
        return usernameError;
    }
    
    public String getPasswordError() {
        return passwordError;
    }
    
    public String getReEnterPasswordError() {
        return reEnterPasswordError;
    }
    
    public String getInstitutionError() {
        return institutionError;
    }
    
    public String getEmailError() {
        return emailError;
    }
    
    public void setUsername(String username) {
        this.username = username;
    }
    
    public void setPassword(String password) {
        this.password = password;
    }
    
    public void setReEnterPassword(String reEnterPassword) {
        this.reEnterPassword = reEnterPassword;
    }
    
    public void setInstitution(String institution) {
        this.institution = institution;
    }
    
    public void setEmail(String email) {
        this.email = email;
    }
    
    public boolean isValid(String process, String runnableProgramsPasswdFile) throws IOException, Exception {
        
        if (runnableProgramsPasswdFile.equals("")) throw new Exception("No passwd file found in calling Register.class");
        
        boolean noErrors = true;
        
        if (process.equals("true")) {
            
            if (username.length() == 0) {
                usernameError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (username.length() < 6 || username.length() > 30) {
                usernameError = Model.addAsterisk(Model.ERROR_USERNAME_OUT_OF_BOUNDS);
                noErrors = false;
            } else if (!username.matches("[a-zA-Z0-9]*")) {
                usernameError = Model.addAsterisk(Model.ERROR_USERNAME_INVALID);
                noErrors = false;
            }    
            
            if (password.length() == 0) {
                passwordError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (password.length() < 6 || password.length() > 30) {
                passwordError = Model.addAsterisk(Model.ERROR_PASSWORD_OUT_OF_BOUNDS);
                noErrors = false;
            }
            
            if (!reEnterPassword.equals(password)) {
                reEnterPasswordError = Model.addAsterisk(Model.ERROR_PASSWORDS_DO_NOT_MATCH);
                noErrors = false;
            }
            
            if (institution.length() == 0) {
                institutionError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (institution.length() > 50) {
                institutionError = Model.addAsterisk(Model.ERROR_FIELD_TOO_LARGE);
                noErrors = false;
            }
            
            if (email.length() == 0) {
                emailError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (email.length() > 50) {
                emailError = Model.addAsterisk(Model.ERROR_FIELD_TOO_LARGE);
                noErrors = false;
            }
            
            if (usernameError.equals("") && passwordError.equals("")) {
                
                String fileUsername = "";
                String filePassword = "";
                
                try {
                    BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
                    String line;
                    while ((line = in.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, ":");
                        while (st.hasMoreTokens()) {
                            fileUsername = st.nextToken();
                            filePassword = st.nextToken();
                            st.nextToken();
                            st.nextToken();
                            
                            if (fileUsername.equals(username)) {
                                usernameError = Model.addAsterisk(Model.ERROR_USERNAME_ALREADY_EXISTS);
                                noErrors = false;
                            }
                            
                            /*String tempPassword = "";
                            
                            try {
                                tempPassword = Utility.encryptPassword(password);
                            } catch (Exception e) {
                                throw e;
                            }
                            
                            if (filePassword.equals(tempPassword)) {
                                passwordError = Model.addAsterisk(Model.ERROR_PASSWORD_ALREADY_EXISTS);
                                noErrors = false;
                            }*/
                        }
                    }
                } catch (IOException e) {
                    throw e;
                }
            }
        }
        
        return noErrors;
    }
}
