package model;

import java.io.*;
import java.util.*;
import java.sql.*;
import model.*;

public class Login implements Serializable {
    
    /* private properties */
    private String username = "";
    private String password = "";
    private String usernameError = "";
    private String passwordError = "";

    public static boolean hasAgreed(String username, String agreedFile) throws IOException {
    	// check if the user has agreed 
        try(BufferedReader in = new BufferedReader(new FileReader(agreedFile))) {
        	String line;
        	String fileUsername;
        	while ((line = in.readLine()) != null) {
        		String [] words = line.split(":") ;
        		if (words.length < 2 ) return false;
        		fileUsername = words[0];
        		if (fileUsername.equals(username)) { 
        			String agreed = words[1];
        			if(agreed.equals("yes")) {
        				return true;
        			}
        			break;
        		}
        	}
        } catch (FileNotFoundException e) {
        	return false;
		}
    	return false;
    }

    
    public String getUsername() {
        return username;
    }
    
    public String getPassword() {
        return password;
    }
    
    public String getUsernameError() {
        return usernameError;
    }
    
    public String getPasswordError() {
        return passwordError;
    }
    
    public void setUsername(String username) {
        this.username = username;
    }
    
    public void setPassword(String password) {
        this.password = password;
    }
    
    public boolean isValid(String process, String runnableProgramsPasswdFile) throws IOException, Exception {
        
        if (runnableProgramsPasswdFile.equals("")) throw new Exception("No passwd file found in calling Login.class");
        
        boolean noErrors = true;
        
        if (process.equals("true")) {
            
            if (username.length() == 0) {
                usernameError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (username.length() > 30) {
                usernameError = Model.addAsterisk(Model.ERROR_FIELD_TOO_LARGE);
                noErrors = false;
            }
            
            if (password.length() == 0) {
                passwordError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (password.length() > 30) {
                passwordError = Model.addAsterisk(Model.ERROR_FIELD_TOO_LARGE);
                noErrors = false;
            }
            
            if (usernameError.equals("") && passwordError.equals("")) {
                
                String fileUsername = "";
                String filenameUsernameStatus = "";
                String filePassword = "";
                String filePasswordStatus = "";
                
                try {
                    BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
                    String line;
                    while ((line = in.readLine()) != null) {
                        String [] words = line.split(":") ;
                        if (words.length < 3 ) throw new IOException();
                        fileUsername = words[0];
                        filePassword = words[1];
                        // StringTokenizer st = new StringTokenizer(line, ":");
                        // while (st.hasMoreTokens()) {
                        //    fileUsername = st.nextToken();
                        //    filePassword = st.nextToken();
                        //    st.nextToken();
                        //    st.nextToken();
                            
                            if (fileUsername.equals(username)) {
                                filenameUsernameStatus = "OK";
                                
                                String tempPassword = "";
                                
                                try {
                                    tempPassword = Utility.encryptPassword(password);
                                } catch (Exception e) {
                                    throw e;
                                }
                                
                                if (filePassword.equals(tempPassword)) {
                                    filePasswordStatus = "OK";
                                }
                            }
                        // }
                    }
                } catch (IOException e) {
                    throw e;
                }
                
                if (filenameUsernameStatus.equals("")) {
                    usernameError = Model.addAsterisk(Model.ERROR_USERNAME_DOES_NOT_EXIST);
                    noErrors = false;
                }
                
                if (filePasswordStatus.equals("")) {
                    passwordError = Model.addAsterisk(Model.ERROR_PASSWORD_DOES_NOT_MATCH_USERNAME);
                    noErrors = false;
                }
            }
        }
        
        return noErrors;
    }
}
