package model;

import java.io.*;
import java.util.*;
import model.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

public class ForgottenPassword implements Serializable {
    
    /* private properties */
    private String username = "";
    private String email = "";
    private String usernameError = "";
    private String emailError = "";
    
    public String getUsername() {
        return username;
    }
    
    public String getEmail() {
        return email;
    }
    
    public String getUsernameError() {
        return usernameError;
    }
    
    public String getEmailError() {
        return emailError;
    }
    
    public void setUsername(String username) {
        this.username = username;
    }
    
    public void setEmail(String email) {
        this.email = email;
    }
    
    public boolean isValid(String process, String runnableProgramsPasswdFile) throws IOException, MessagingException, Exception {
        
        if (runnableProgramsPasswdFile.equals("")) throw new Exception("No passwd file found in session");
        
        boolean noErrors = true;
        
        if (process.equals("true")) {
            
            
            String fileUsername = "";
            String fileEmail = "";
            
            boolean usernameExists = false;
            
            try {
                BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
                String line;
                while ((line = in.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, ":");
                    while (st.hasMoreTokens()) {
                        fileUsername = st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        fileEmail = st.nextToken();
                        
                        if (fileUsername.equals(username)) {
                            usernameExists = true;
                            
                            if (!fileEmail.equals(email)) {
                                emailError = Model.addAsterisk(Model.ERROR_EMAIL_DOES_NOT_EXIST);
                                noErrors = false;
                            } else {
                                try {
                                    String host = "exchsmtp.stfc.ac.uk";
                                    String fromAddress = "noreply@rcoisin.rc-harwell.ac.uk";
                                    String toAddress = fileEmail;
                                    String subject = "CCP4 Webadmin";
                                    
                                    String bodyText = "";
                                    
                                    String nPassword = newPassword(runnableProgramsPasswdFile);
                                    
                                    try {
                                        bodyText = "Your new password for the Balbes webserver is: " + nPassword;
                                    } catch (Exception e) {
                                        throw e;
                                    }
                                        
                                    sendMail(host, fromAddress, toAddress, subject, bodyText);
                                } catch(MessagingException e) {
                                    throw e;
                                }
                            }
                        }
                    }
                }
            } catch (IOException e) {
                throw e;
            }
            
            if (usernameExists == false) {
                usernameError = Model.addAsterisk(Model.ERROR_USERNAME_DOES_NOT_EXIST);
                noErrors = false;
            }
        }
        
        return noErrors;
    }
    
    public void sendMail(String host, String fromAddress, String toAddress, String subject, String bodyText) throws MessagingException {
        
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        Session session = Session.getInstance(props, null);
        
        try {
            Message msg = new MimeMessage(session);
            msg.setFrom(new InternetAddress(fromAddress));
            InternetAddress[] address = {new InternetAddress(toAddress)};
            msg.setRecipients(Message.RecipientType.TO, address);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setText(bodyText);
            Transport.send(msg);
        } catch (MessagingException e) {
            throw e;
        }
    }
    
    public String newPassword(String runnableProgramsPasswdFile) throws IOException, Exception {
        
        String newPassword = "";
        
        for (int i = 0; i < 6; i++) {
            int r = (int)(Math.random() * 74 + 48);
            char d = (char)r;
            newPassword += d;
        }
        
        
        
        String text = "";
        String line;
        String fileUsername = "";
        String filePassword = "";
        String fileInstitution = "";
        String fileEmail = "";
        
        try {
            
            BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
            
            while ((line = in.readLine()) != null) {
                
                StringTokenizer st = new StringTokenizer(line, ":");
                
                while (st.hasMoreTokens()) {
                    fileUsername = st.nextToken();
                    filePassword = st.nextToken();
                    fileInstitution = st.nextToken();
                    fileEmail = st.nextToken();
                    
                    if (fileUsername.equals(username)) {
                        try {
                            filePassword = Utility.encryptPassword(newPassword);
                        } catch (Exception e) {
                            throw e;
                        }
                    }
                    
                    text += fileUsername + ":" + filePassword + ":" + fileInstitution + ":" + fileEmail + "\n";
                }
            }
            
        } catch (IOException e) {
            throw e;
        }
        
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(runnableProgramsPasswdFile));
            bw.write(text);
            //bw.newLine();
            bw.close();
        } catch (IOException e) {
            throw e;
        }
        
        return newPassword;
    }
}

