package model;

import java.io.*;
import java.util.*;
import model.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;

public class ChangePassword implements Serializable {
    
    /* private properties */
    private String username = "";
    private String password = "";
    private String newPassword = "";
    private String reEnterNewPassword = "";
    private String usernameError = "";
    private String passwordError = "";
    private String newPasswordError = "";
    private String reEnterNewPasswordError = "";
    
    public String getUsername() {
        return username;
    }
    
    public String getPassword() {
        return password;
    }
    
    public String getNewPassword() {
        return newPassword;
    }
    
    public String getReEnterNewPassword() {
        return reEnterNewPassword;
    }
    
    public String getUsernameError() {
        return usernameError;
    }
    
    public String getPasswordError() {
        return passwordError;
    }
    
    public String getNewPasswordError() {
        return newPasswordError;
    }
    
    public String getReEnterNewPasswordError() {
        return reEnterNewPasswordError;
    }
    
    public void setUsername(String username) {
        this.username = username;
    }
    
    public void setPassword(String password) {
        this.password = password;
    }
    
    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }
    
    public void setReEnterNewPassword(String reEnterNewPassword) {
        this.reEnterNewPassword = reEnterNewPassword;
    }
    
    public boolean isValid(String process, String runnableProgramsPasswdFile) throws IOException, Exception {
        
        if (runnableProgramsPasswdFile.equals("")) throw new Exception("No passwd file is found in ChangePassword.java");
        
        // copy file to file.copy
        String l = "";
        
        try {
            BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
            String line;
            while ((line = in.readLine()) != null) {
                l += line + "\n";
            }
        } catch (IOException e) {
            throw e;
        }
        
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(runnableProgramsPasswdFile + ".copy"));
            bw.write(l);
            bw.close();
        } catch (IOException e) {
            throw e;
        }
        
        // validate username and passwords
        boolean noErrors = true;
        
        if (process.equals("true")) {
            
            if (username.length() == 0) {
                usernameError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            }
            
            if (password.length() == 0) {
                passwordError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            }
            
            if (newPassword.length() == 0) {
                newPasswordError = Model.addAsterisk(Model.ERROR_FIELD_COMPULSORY);
                noErrors = false;
            } else if (newPassword.length() < 6 || newPassword.length() > 10) {
                newPasswordError = Model.addAsterisk(Model.ERROR_PASSWORD_OUT_OF_BOUNDS);
                noErrors = false;
            }
            
            if (!reEnterNewPassword.equals(newPassword)) {
                reEnterNewPasswordError = Model.addAsterisk(Model.ERROR_PASSWORDS_DO_NOT_MATCH);
                noErrors = false;
            }
            
            String fileUsername = "";
            String filenameUsernameStatus = "";
            String filePassword = "";
            String filePasswordStatus = "";
            
            try {
                BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
                String line;
                while ((line = in.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, ":");
                    while (st.hasMoreTokens()) {
                        fileUsername = st.nextToken();
                        filePassword = st.nextToken();
                        st.nextToken();
                        st.nextToken();
                        
                        if (fileUsername.equals(username)) {
                            filenameUsernameStatus = "OK";
                            
                            String tempPassword = "";
                            
                            try {
                                tempPassword = Utility.encryptPassword(password);
                            } catch (Exception e) {
                                throw e;
                            }
                            
                            if (filePassword.equals(tempPassword)) {
                                filePasswordStatus = "OK";
                            }
                        }
                        
                        String tempNewPassword = "";
                        
                        try {
                            tempNewPassword = Utility.encryptPassword(newPassword);
                        } catch (Exception e) {
                            throw e;
                        }
                        
                        if (filePassword.equals(tempNewPassword)) {
                            newPasswordError = Model.addAsterisk(Model.ERROR_PASSWORD_ALREADY_EXISTS);
                            noErrors = false;
                        }
                    }
                }
            } catch (IOException e) {
                throw e;
            }
            
            if (filenameUsernameStatus.equals("")) {
                usernameError = Model.addAsterisk(Model.ERROR_USERNAME_DOES_NOT_EXIST);
                noErrors = false;
            }
            
            if (filePasswordStatus.equals("")) {
                passwordError = Model.addAsterisk(Model.ERROR_PASSWORD_DOES_NOT_MATCH_USERNAME);
                noErrors = false;
            }
        }
        
        // read in file, change password, then write back again
        String f = "", p = "", i = "", ee = "";
        String ll = "";
        
        if (noErrors == true) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
                String line;
                while ((line = in.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(line, ":");
                    while (st.hasMoreTokens()) {
                        f = st.nextToken();
                        p = st.nextToken();
                        i = st.nextToken();
                        ee = st.nextToken();
                        
                        if (f.equals(username) && p.equals(Utility.encryptPassword(password))) {
                            ll += f + ":" + Utility.encryptPassword(newPassword) + ":" + i + ":" + ee + "\n";
                        } else {
                            ll += line + "\n";
                        }
                    }
                }
            } catch (IOException e) {
                throw e;
            }
            
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(runnableProgramsPasswdFile));
                bw.write(ll);
                bw.close();
            } catch (IOException e) {
                throw e;
            }
        }
        
        return noErrors;
    }
    
    /*public void sendMail(String host, String fromAddress, String toAddress, String subject, String bodyText) throws MessagingException {
     
        Properties props = new Properties();
        props.put("mail.smtp.host", host);
        Session session = Session.getInstance(props, null);
     
        try {
            Message msg = new MimeMessage(session);
            msg.setFrom(new InternetAddress(fromAddress));
            InternetAddress[] address = {new InternetAddress(toAddress)};
            msg.setRecipients(Message.RecipientType.TO, address);
            msg.setSubject(subject);
            msg.setSentDate(new Date());
            msg.setText(bodyText);
            Transport.send(msg);
        } catch (MessagingException e) {
            throw e;
        }
    }*/
    
    /*public String newPassword(String runnableProgramsPasswdFile) throws IOException, Exception {
     
        String newPassword = "";
     
        for (int i = 0; i < 6; i++) {
            int r = (int)(Math.random() * 74 + 48);
            char d = (char)r;
            newPassword += d;
        }
     
     
     
        String text = "";
        String line;
        String fileUsername = "";
        String filePassword = "";
        String fileInstitution = "";
        String fileEmail = "";
     
        try {
     
            BufferedReader in = new BufferedReader(new FileReader(runnableProgramsPasswdFile));
     
            while ((line = in.readLine()) != null) {
     
                StringTokenizer st = new StringTokenizer(line, ":");
     
                while (st.hasMoreTokens()) {
                    fileUsername = st.nextToken();
                    filePassword = st.nextToken();
                    fileInstitution = st.nextToken();
                    fileEmail = st.nextToken();
     
                    if (fileUsername.equals(username)) {
                        try {
                            filePassword = Utility.encryptPassword(newPassword);
                        } catch (Exception e) {
                            throw e;
                        }
                    }
     
                    text += fileUsername + ":" + filePassword + ":" + fileInstitution + ":" + fileEmail + "\n";
                }
            }
     
        } catch (IOException e) {
            throw e;
        }
     
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(runnableProgramsPasswdFile));
            bw.write(text);
            //bw.newLine();
            bw.close();
        } catch (IOException e) {
            throw e;
        }
     
        return newPassword;
    }*/
}

