package model;

import java.io.*;
import java.util.*;

public class Buccaneer {
    
    private String fs = File.separator;
    
    // labels
    public Vector fP_sigFP_LabelVector = new Vector();
    public Vector phiFom_hL_LabelVector = new Vector();
    public Vector freeRFlag_LabelVector = new Vector();
    
    // types
    public Vector fP_sigFP_TypeVector = new Vector();
    public Vector phiFom_hLTypeVector = new Vector();
    public Vector freeRFlag_TypeVector = new Vector();
    
    // selected options
    public String fP_sigFP_Selected = "";
    public String phiFom_hL_Selected = "";
    public String freeRFlag_Selected = "";
    
    public String setParameters(String dmpFilename) throws IOException  {
        
        String line = "";
        
        Vector columnLabelsVector = new Vector();
        Vector columnTypesVector = new Vector();
        
        // read column labels and column types into vectors from dmp file
        try {
            
            BufferedReader b = new BufferedReader(new FileReader(dmpFilename));
            
            while ((line = b.readLine()) != null) {
                
                if (line.matches(".*Column Labels.*")  && columnLabelsVector.isEmpty()) {
                    
                    while ((line = b.readLine()) != null) {
                        if (!line.equals("")) break;
                    }
                    
                    StringTokenizer st1 = new StringTokenizer(line, " ");
                    
                    while (st1.hasMoreTokens()) {
                        columnLabelsVector.add(st1.nextToken());
                    }
                }
                
                if (line.matches(".*Column Types.*") && columnTypesVector.isEmpty()) {
                    
                    while ((line = b.readLine()) != null) {
                        if (!line.equals("")) break;
                    }
                    
                    StringTokenizer st2 = new StringTokenizer(line, " ");
                    
                    while (st2.hasMoreTokens()) {
                        columnTypesVector.add(st2.nextToken());
                    }
                }
                
                if (!columnLabelsVector.isEmpty() && !columnTypesVector.isEmpty()) break;
            }
            
        } catch (IOException e) {
            throw e;
        }
        
        String columnLabel = "";
        String columnType = "";
        
        int columnLabelsSize = columnLabelsVector.size();
        
        // find parameters from columnLabelsVector and columnTypesVector
        for (int i = 0; i < columnLabelsSize; i++) {
            
            columnLabel = (String)columnLabelsVector.elementAt(i);
            columnType = (String)columnTypesVector.elementAt(i);
            
            if (columnLabelsSize > (i+1)) {
                if (columnType.equals("F") && ((String)columnTypesVector.elementAt(i+1)).equals("Q")) {
                    fP_sigFP_LabelVector.add(columnLabel + "/" + (String)columnLabelsVector.elementAt(i+1));
                }
            }
            
            if (columnLabelsSize > (i+1)) {
                if (columnType.equals("P") && ((String)columnTypesVector.elementAt(i+1)).equals("W")) {
                    phiFom_hL_LabelVector.add(columnLabel + ", " + (String)columnLabelsVector.elementAt(i+1));
                }
            }
            
            if (columnLabelsSize > (i+3)) {
                if (columnType.equals("A") && ((String)columnTypesVector.elementAt(i+1)).equals("A") &&
                   ((String)columnTypesVector.elementAt(i+2)).equals("A") &&
                   ((String)columnTypesVector.elementAt(i+3)).equals("A")) {
                    
                    String label = columnLabel + ", " + 
                        (String)columnLabelsVector.elementAt(i+1) + ", " +
                        (String)columnLabelsVector.elementAt(i+2) + ", " +
                        (String)columnLabelsVector.elementAt(i+3);
                    
                    phiFom_hL_LabelVector.add(label);
                }
            }
            
            if (columnType.equals("I")) {
                freeRFlag_LabelVector.add(columnLabel);
            }
        }
        
        // return string with any parameter errors
        String parameterErrors = "";
        
        if (fP_sigFP_LabelVector.isEmpty()) {
            parameterErrors += "FP / sigFP ";
        }
        
        if (phiFom_hL_LabelVector.isEmpty()) {
            parameterErrors += "PHI_FOM / HL ";
        }
        
        if (freeRFlag_LabelVector.isEmpty()) {
            parameterErrors += "FREE R FLAG ";
        }
        
        return parameterErrors;
    }
}

