package controller;

import java.io.*;
import java.nio.file.Path;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.ByteBuffer;
import java.lang.StringBuilder;

import javax.servlet.*;

import java.text.*;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.*;

import model.Cell;
import model.GetPropertyValues;

import org.apache.commons.fileupload.*;
import org.apache.commons.fileupload.servlet.*;
import org.apache.commons.fileupload.disk.*;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnableProgramsRunAction extends Action {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8810307967860487635L;
	private String fs = File.separator;
	private String idDir = "";
	private String error = "";
	private List<String> uploadedFiles = new ArrayList<>();
	private Logger logger = LoggerFactory.getLogger("controller.RunnableProgramsRunAction");

	//public void run() throws ServletException, IOException, Exception {
	public void run() throws ServletException, IOException {
		

		String id = "";
		idDir = "";
		error = "";

		String jobtitle = "";
		String checkFullSpacegroup = "";
		String checkAlternativeSpacegroups = "";
		boolean useShelx = false;
		boolean nativeOptional = false;
		boolean newStructure = false;
		String arpWarp = "";
		String sequenceTargetTextarea = "";
		String disseminationLevel = "";
		String substructureAtom = null;
		Double fprime = null;
		Double fprimeprime = null;
		Double cutoff = null;
		String experimentType = "";
		int exp_num_atoms = 0;
		int num_trials = 0;
		int num_resid = 0;
		int dsul = 0;
		FileItem structureFactorsItem = null;
		FileItem structureFactorsNativeItem = null;
		ArrayList<FileItem> structureFactorsItems = new ArrayList<>();
		ArrayList<String> dataTypes = new ArrayList<>();
		ArrayList<String> inputTypes = new ArrayList<>();
		ArrayList<String> spacegroups = new ArrayList<>();
		ArrayList<Cell> cells = new ArrayList<>();
		ArrayList<Double> fprimes = new ArrayList<>();
		ArrayList<Double> fprimeprimes = new ArrayList<>();
		// cell variables for a single dataset
		Cell cell0 = new Cell();
		String spacegroup0 = "";
		Cell cellNative = new Cell();
		String spacegroupNative = "";
		// data type for a single dataset in experimental phasing (not used at
		// the moment)
		String dataType0 = "";
		String inputType0 = "";
		String inputTypeNative = "";
		Double fprime0 = null;
		Double fprimeprime0 = null;
		FileItem coordinatesItem = null;
		FileItem sequenceTargetItem = null;
		FileItem zipfileItem = null;

		model.resetModel();

		String baseDir = model.getRunnableProgramsInputBaseDir();
		String programType = model.getRunnableProgramsType();
		String userDir = baseDir + fs + programType + fs + model.getUsername();
		HashMap<String, String> inputFiles = model.getInputFiles();
		HashMap<String, String> parameters = model.getParameters();
		HashMap<String, String> columns = new HashMap<String, String>();

		boolean upload_page = false;
		boolean last_page = true;
		boolean repeat_page = false;
		
        //throw new ServletException("test");

		// create userDir and index.jsp
		try {
			createUserDir(userDir);
		} catch (IOException e) {
			throw new ServletException(e.getMessage());
		}

		// this becomes true if the form page includes files to be uploaded. It
		// should be the first page.
		boolean isMultipart = ServletFileUpload
				.isMultipartContent(new ServletRequestContext(request));

		// parse file
		if (isMultipart == true) {

			upload_page = true;
			// if ("CRANK2".equals(programType) || "SHELX".equals(programType)) {
			// if ("CRANK2".equals(programType)) {
			// last_page = false;
			// }

			File repository = (File) application
					.getAttribute("javax.servlet.context.tempdir");
			DiskFileItemFactory factory = newDiskFileItemFactory(application,
					repository);
			factory.setRepository(repository);
			ServletFileUpload upload = new ServletFileUpload(factory);

			List<FileItem> items = null;

			try {
				items = upload.parseRequest(request);
			} catch (FileUploadException e) {
				throw new ServletException(e.getMessage());
			}

			Iterator<FileItem> iter = items.iterator();

			// iterate over items ...
			while (iter.hasNext()) {

				FileItem item = iter.next();
				String fieldName = item.getFieldName();
				Pattern structureFactorsPattern = Pattern
						.compile("structureFactorsFile(?<end>.+)");
				Matcher structureFactorsMatcher = structureFactorsPattern
						.matcher(fieldName);
				Pattern dataTypePattern = Pattern
						.compile("dataType(?<end>\\d*)$");
				Matcher dataTypeMatcher = dataTypePattern.matcher(fieldName);
				Pattern inputTypePattern = Pattern
						.compile("inputType(?<end>\\d|Native)$");
				Matcher inputTypeMatcher = inputTypePattern.matcher(fieldName);
				Pattern iPattern = Pattern.compile("^(I|SIGI).*");
				Matcher iMatcher = iPattern.matcher(fieldName);
				Pattern cellaPattern = Pattern.compile("a(?<end>\\d|Native)$");
				Matcher cellaMatcher = cellaPattern.matcher(fieldName);
				Pattern cellbPattern = Pattern.compile("b(?<end>\\d|Native)$");
				Matcher cellbMatcher = cellbPattern.matcher(fieldName);
				Pattern cellcPattern = Pattern.compile("c(?<end>\\d|Native)$");
				Matcher cellcMatcher = cellcPattern.matcher(fieldName);
				Pattern cellalphaPattern = Pattern
						.compile("alpha(?<end>\\d|Native)$");
				Matcher cellalphaMatcher = cellalphaPattern.matcher(fieldName);
				Pattern cellbetaPattern = Pattern
						.compile("beta(?<end>\\d|Native)$");
				Matcher cellbetaMatcher = cellbetaPattern.matcher(fieldName);
				Pattern cellgammaPattern = Pattern
						.compile("gamma(?<end>\\d|Native)$");
				Matcher cellgammaMatcher = cellgammaPattern.matcher(fieldName);
				Pattern spacegroupPattern = Pattern
						.compile("spacegroup(?<end>\\d|Native)$");
				Matcher spacegroupMatcher = spacegroupPattern
						.matcher(fieldName);
				Pattern fprimePattern = Pattern.compile("fprime(?<end>\\d)$");
				Matcher fprimeMatcher = fprimePattern.matcher(fieldName);
				Pattern fprimeprimePattern = Pattern
						.compile("fprimeprime(?<end>\\d)$");
				Matcher fprimeprimeMatcher = fprimeprimePattern
						.matcher(fieldName);

				// create id and input directories

				if ("id".equals(fieldName)) {
					id = item.getString();
					if(!StringUtils.isNumeric(id)) {
						logger.error("job id is non numeric: "+id);
						throw new ServletException("Invalid job id: "+id);
					}
				} else if ("jobtitle".equals(fieldName)) {
					jobtitle = item.getString();
				} else if ("repeat".equals(fieldName)) {
					repeat_page = true;
				} else if ("zipfile".equals(fieldName)) {
					zipfileItem = item;
				} else if ("structureFactorsFile".equals(fieldName)) {
					structureFactorsItem = item;
				} else if (iMatcher.matches()) {
					parameters.put(fieldName, item.getString());
				} else if (structureFactorsMatcher.matches()) {
					String end = structureFactorsMatcher.group("end");

					if ("Native".equals(end)) {
						structureFactorsNativeItem = item;
					} else if ("NativeOptional".equals(end)) {
						structureFactorsNativeItem = item;
						nativeOptional = true;
					} else {
						try {
							int i = Integer.parseInt(end);
							while (structureFactorsItems.size() < i) {
								structureFactorsItems.add(null);
							}
							structureFactorsItems.set(i - 1, item);
						} catch (Exception e) {
						}
					}
				} else if (cellaMatcher.matches()) {
					String end = cellaMatcher.group("end");
					try {
						double a = Double.parseDouble(item.getString());
						if ("Native".equals(end)) {
							cellNative.setParam("a", a);
						} else {
							try {
								int i = Integer.parseInt(end);
								Cell cell = ithCell(cells, i);
								cell.setParam("a", a);
							} catch (Exception e) {
								cell0.setParam("a", a);
							}
						}
					} catch (NumberFormatException ex) {
					}
				} else if (cellbMatcher.matches()) {
					String end = cellbMatcher.group("end");
					try {
						double b = Double.parseDouble(item.getString());
						if ("Native".equals(end)) {
							cellNative.setParam("b", b);
						} else {
							try {
								int i = Integer.parseInt(end);
								Cell cell = ithCell(cells, i);
								cell.setParam("b", b);
							} catch (Exception e) {
								cell0.setParam("b", b);
							}
						}
					} catch (NumberFormatException ex) {
					}
				} else if (cellcMatcher.matches()) {
					String end = cellcMatcher.group("end");
					try {
						double c = Double.parseDouble(item.getString());
						if ("Native".equals(end)) {
							cellNative.setParam("c", c);
						} else {
							try {
								int i = Integer.parseInt(end);
								Cell cell = ithCell(cells, i);
								cell.setParam("c", c);
							} catch (Exception e) {
								cell0.setParam("c", c);
							}
						}
					} catch (NumberFormatException ex) {
					}
				} else if (cellalphaMatcher.matches()) {
					String end = cellalphaMatcher.group("end");
					try {
						double alpha = Double.parseDouble(item.getString());
						if ("Native".equals(end)) {
							cellNative.setParam("alpha", alpha);
						} else {
							try {
								int i = Integer.parseInt(end);
								Cell cell = ithCell(cells, i);
								cell.setParam("alpha", alpha);
							} catch (Exception e) {
								cell0.setParam("alpha", alpha);
							}
						}
					} catch (NumberFormatException ex) {
					}
				} else if (cellbetaMatcher.matches()) {
					String end = cellbetaMatcher.group("end");
					try {
						double beta = Double.parseDouble(item.getString());
						if ("Native".equals(end)) {
							cellNative.setParam("beta", beta);
						} else {
							try {
								int i = Integer.parseInt(end);
								Cell cell = ithCell(cells, i);
								cell.setParam("beta", beta);
							} catch (Exception e) {
								cell0.setParam("beta", beta);
							}
						}
					} catch (NumberFormatException ex) {
					}
				} else if (cellgammaMatcher.matches()) {
					String end = cellgammaMatcher.group("end");
					try {
						double gamma = Double.parseDouble(item.getString());
						if ("Native".equals(end)) {
							cellNative.setParam("gamma", gamma);
						} else {
							try {
								int i = Integer.parseInt(end);
								Cell cell = ithCell(cells, i);
								cell.setParam("gamma", gamma);
							} catch (Exception e) {
								cell0.setParam("gamma", gamma);
							}
						}
					} catch (NumberFormatException ex) {
					}
				} else if (spacegroupMatcher.matches()) {
					String end = spacegroupMatcher.group("end");
					String spgrp = item.getString().replaceAll("\\s", "");
					if (!"".equals(spgrp)) {
						if ("Native".equals(end)) {
							spacegroupNative = spgrp;
						} else {
							try {
								int i = Integer.parseInt(end);
								while (spacegroups.size() < i) {
									spacegroups.add(null);
								}
								spacegroups.set(i - 1, spgrp);
							} catch (Exception e) {
								spacegroup0 = spgrp;
							}
						}
					}
				} else if (dataTypeMatcher.matches()) {
					String end = dataTypeMatcher.group("end");
					String dtype = item.getString();
					// Should refactor this into an enum, for example.
					if ("low".equals(dtype) || "high".equals(dtype)
							|| "inflection".equals(dtype)
							|| "peak".equals(dtype)) {
						try {
							int i = Integer.parseInt(end);
							while (dataTypes.size() < i) {
								dataTypes.add(null);
							}
							dataTypes.set(i - 1, dtype);
						} catch (Exception e) {
							dataType0 = dtype;
						}
					}
				} else if (inputTypeMatcher.matches()) {
					String end = inputTypeMatcher.group("end");
					String itype = item.getString();
					if ("intensities".equals(itype)
							|| "amplitudes".equals(itype)) {
						if ("Native".equals(end)) {
							inputTypeNative = itype;
						} else {
							try {
								int i = Integer.parseInt(end);
								while (inputTypes.size() < i) {
									inputTypes.add(null);
								}
								inputTypes.set(i - 1, itype);
							} catch (Exception e) {
								inputType0 = itype;
							}
						}
					}
				} else if (fprimeMatcher.matches()) {
					String end = fprimeMatcher.group("end");
					try {
						double fp = Double.parseDouble(item.getString());
						try {
							int i = Integer.parseInt(end);
							while (fprimes.size() < i) {
								fprimes.add(null);
							}
							fprimes.set(i - 1, new Double(fp));
						} catch (Exception e) {
							fprime0 = new Double(fp);
						}
					} catch (NumberFormatException ex) {
					}
				} else if (fprimeprimeMatcher.matches()) {
					String end = fprimeprimeMatcher.group("end");
					try {
						double fpp = Double.parseDouble(item.getString());
						try {
							int i = Integer.parseInt(end);
							while (fprimeprimes.size() < i) {
								fprimeprimes.add(null);
							}
							fprimeprimes.set(i - 1, new Double(fpp));
						} catch (Exception e) {
							fprimeprime0 = new Double(fpp);
						}
					} catch (NumberFormatException ex) {
					}
				} else if ("coordinatesFile".equals(fieldName)) {
					coordinatesItem = item;
				} else if ("sequenceTargetFile".equals(fieldName)) {
					sequenceTargetItem = item;
				} else if ("substructureAtom".equals(fieldName)) {
					substructureAtom = item.getString();
				} else if ("cutoff".equals(fieldName)) {
					try {
						cutoff = Double.parseDouble(item.getString());
					} catch (NumberFormatException ex) {
					}
				} else if ("fprime".equals(fieldName)) {
					fprime = Double.parseDouble(item.getString());
				} else if ("fprimeprime".equals(fieldName)) {
					fprimeprime = Double.parseDouble(item.getString());
				} else if ("checkFullSpacegroup".equals(fieldName)) {
					checkFullSpacegroup = item.getString();
					if (checkFullSpacegroup == null)
						checkFullSpacegroup = "";
				} else if ("checkAlternativeSpacegroups".equals(fieldName)) {
					checkAlternativeSpacegroups = item.getString();
					if (checkAlternativeSpacegroups == null)
						checkAlternativeSpacegroups = "";
				} else if ("experimentType".equals(fieldName)) {
					experimentType = item.getString();
				} else if ("arpWarp".equals(fieldName)) {
					arpWarp = item.getString();
					if (arpWarp == null)
						arpWarp = "";
				} else if ("shelxLicence".equals(fieldName)) {
					String f = item.getString();
					if (f == null) {
						useShelx = false;
					} else {
						useShelx = true;
					}
				} else if ("newStructure".equals(fieldName)) {
					String f = item.getString();
					if (f == null) {
						newStructure = false;
					} else {
						newStructure = true;
					}
				} else if ("DSUL".equals(fieldName)) {
					try {
						dsul = Integer.parseInt(item.getString());
					} catch (Exception e) {
						dsul = 0;
					}
				} else if ("exp_num_atoms".equals(fieldName)) {
					try {
						exp_num_atoms = Integer.parseInt(item.getString());
					} catch (Exception e) {
						exp_num_atoms = 0;
					}
				} else if ("num_trials".equals(fieldName)) {
					try {
						num_trials = Integer.parseInt(item.getString());
					} catch (Exception e) {
						num_trials = 0;
					}
				} else if ("num_resid".equals(fieldName)) {
					try {
						num_resid = Integer.parseInt(item.getString());
					} catch (Exception e) {
						num_resid = 0;
					}
				} else if ("disseminationLevel".equals(fieldName)) {
					if (!"".equals(arpWarp)) {
						disseminationLevel = item.getString();
					}
				} else if ("sequenceTargetTextarea".equals(fieldName)) {
					sequenceTargetTextarea = item.getString();
					if (sequenceTargetTextarea == null)
						sequenceTargetTextarea = "";
				}
			}
		} else {
			upload_page = false;
			last_page = true;
			// this will work only if the page includes data for the column
			// label selection. Further validation should be added.
			id = request.getParameter("id");
			Enumeration<?> e = request.getParameterNames();
			while (e.hasMoreElements()) {
				String par = (String) e.nextElement();
				parameters.put(par, request.getParameter(par));
			}
		}

		// create id directory if it doesn't exist
		idDir = userDir + fs + id;

		File idDirectory = new File(idDir);
		File inputDirectory = new File(idDir + fs + "input");

		// check if directory exists - if so do not want to go any further
		// unless it's a multi-page form
		if (idDirectory.exists()) {
			if (upload_page && !repeat_page) {
				error = "ERROR_DUPLICATE_RUN\n";
			}
			model.setRunnableProgramsExistingId(id);
		} else {
			idDirectory.mkdir();
			try {
				String command = "chmod 777 " + idDirectory.getAbsolutePath();
				Runtime r = Runtime.getRuntime();
				Process p = r.exec(command);
			} catch (IOException ioe) {
				ioe.printStackTrace();
			}
			inputDirectory.mkdir();
			try {
				String command = "chmod 777 "
						+ inputDirectory.getAbsolutePath();
				Runtime r = Runtime.getRuntime();
				Process p = r.exec(command);
			} catch (IOException ioe) {
				ioe.printStackTrace();
			}
		}

		if (!"".equals(jobtitle)) {
			try (PrintWriter pw = new PrintWriter(new FileWriter(idDir + fs
					+ "jobtitle.txt"))) {
				pw.printf("%s", jobtitle);
			} catch (Exception ex) {
			}
		}

		String zipfileFilename = "";
		String structureFactorsFilename = "";
		String structureFactorsNativeFilename = "";
		String coordinatesFilename = "";
		String sequenceTargetFilename = "";

		// check program runs and user runs are not exceeded
		if ("".equals(error))
			checkNoRuns(baseDir + fs + programType);

		if ("".equals(error) && upload_page) {

			if (zipfileItem != null) {

				zipfileFilename = fixName(zipfileItem.getName());
				long zipfileFilesize = zipfileItem.getSize();
				int filesizeLimit = Integer.parseInt(application
						.getInitParameter("zipfileFileLimit"));

				if ("".equals(zipfileFilename))
					error += "ERROR_NO_ZIPFILE\n";
				else if (zipfileFilesize == 0)
					error += "ERROR_ZIPFILE_FILESIZE_ZERO\n";
				if (zipfileFilename.indexOf(" ") != -1)
					error += "ERROR_ZIPFILE_NAME_CONTAINS_SPACES\n";
				if (zipfileFilename.indexOf("(") != -1
						|| zipfileFilename.indexOf(")") != -1) {
					error += "ERROR_ZIPFILE_NAME_CONTAINS_BRACKETS\n";
				}
				if (zipfileFilesize > filesizeLimit)
					error += "ERROR_ZIPFILE_SIZE_EXCEEDS_LIMIT\n";
				inputFiles.put("zipin", "input" + fs + zipfileFilename);
				parameters.put("zipin", "input" + fs + zipfileFilename);
			}

			if (structureFactorsItem != null) {

				structureFactorsFilename = fixName(structureFactorsItem
						.getName());
				long structureFactorsFilesize = structureFactorsItem.getSize();
				int filesizeLimit = Integer.parseInt(application
						.getInitParameter("structureFactorsFileLimit"));

				if ("".equals(structureFactorsFilename))
					error += "ERROR_NO_STRUCTURE_FACTORS_FILE\n";
				else if (structureFactorsFilesize == 0)
					error += "ERROR_STRUCTURE_FACTORS_FILESIZE_ZERO\n";
				if (structureFactorsFilename.indexOf(" ") != -1)
					error += "ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_SPACES\n";
				if (structureFactorsFilename.indexOf("(") != -1
						|| structureFactorsFilename.indexOf(")") != -1) {
					error += "ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_BRACKETS\n";
				}
				if (structureFactorsFilesize > filesizeLimit)
					error += "ERROR_STRUCTURE_FACTORS_EXCEEDS_LIMIT\n";
				inputFiles
						.put("hklin", "input" + fs + structureFactorsFilename);
				parameters
						.put("hklin", "input" + fs + structureFactorsFilename);
			}

			if (structureFactorsNativeItem != null) {

				structureFactorsNativeFilename = fixName(structureFactorsNativeItem
						.getName());
				long structureFactorsFilesize = structureFactorsNativeItem
						.getSize();
				int filesizeLimit = Integer.parseInt(application
						.getInitParameter("structureFactorsFileLimit"));

				if ("".equals(structureFactorsNativeFilename)) {
					if (!nativeOptional) {
						error += "ERROR_NO_NATIVE_STRUCTURE_FACTORS_FILE\n";
					}
				} else if (structureFactorsFilesize == 0) {
					error += "ERROR_NATIVE_STRUCTURE_FACTORS_FILESIZE_ZERO\n";
				}
				if (structureFactorsNativeFilename.indexOf(" ") != -1)
					error += "ERROR_NATIVE_STRUCTURE_FACTORS_FILE_CONTAINS_SPACES\n";
				if (structureFactorsNativeFilename.indexOf("(") != -1
						|| structureFactorsNativeFilename.indexOf(")") != -1) {
					error += "ERROR_NATIVE_STRUCTURE_FACTORS_FILE_CONTAINS_BRACKETS\n";
				}
				if (structureFactorsFilesize > filesizeLimit)
					error += "ERROR_NATIVE_STRUCTURE_FACTORS_EXCEEDS_LIMIT\n";

				if (!"".equals(structureFactorsNativeFilename)) {
					inputFiles.put("native", "input" + fs
							+ structureFactorsNativeFilename);
					parameters.put("native", "input" + fs
							+ structureFactorsNativeFilename);
				}
			}

			// coordinates - note that coordinates file is not compulsory for
			// sfcheck
			if (coordinatesItem != null) {

				coordinatesFilename = fixName(coordinatesItem.getName());
				long coordinatesFilesize = coordinatesItem.getSize();
				int filesizeLimit = Integer.parseInt(application
						.getInitParameter("coordinatesFileLimit"));

				if (model.getRunnableProgramsType().equals("SfCheck")
						&& "".equals(coordinatesFilename)) {
					// do nothing (SfCheck coordinates file is not compulsory)
				} else {
					if ("".equals(coordinatesFilename))
						error += "ERROR_NO_COORDINATES_FILE\n";
					else if (coordinatesFilesize == 0)
						error += "ERROR_COORDINATES_FILESIZE_ZERO\n";
					if (coordinatesFilename.indexOf(" ") != -1)
						error += "ERROR_COORDINATES_FILE_CONTAINS_SPACES\n";
					if (coordinatesFilename.indexOf("(") != -1
							|| coordinatesFilename.indexOf(")") != -1) {
						error += "ERROR_COORDINATES_FILE_CONTAINS_BRACKETS\n";
					}
					if (coordinatesFilesize > filesizeLimit)
						error += "ERROR_COORDINATES_TEXTAREA_EXCEEDS_LIMIT\n";
				}
				inputFiles.put("xyzin", "input" + fs + coordinatesFilename);
				parameters.put("xyzin", "input" + fs + coordinatesFilename);
			}

			if (sequenceTargetItem != null) {

				sequenceTargetFilename = fixName(sequenceTargetItem.getName());
				int filesizeLimit = Integer.parseInt(application
						.getInitParameter("sequenceTargetFileLimit"));

				if ("".equals(sequenceTargetFilename)
						&& "".equals(sequenceTargetTextarea)) {
					// for SHELX and CRANK2, the sequence file is optional
					if (!"SHELX".equals(programType) && !"CRANK2".equals(programType)) {
						error += "ERROR_NO_SEQUENCE_TARGET_FILE_OR_TEXTAREA\n";
					}

				} else if (!"".equals(sequenceTargetFilename)
						&& !"".equals(sequenceTargetTextarea)) {
					error += "ERROR_SEQUENCE_TARGET_FILE_AND_TEXT_AREA_EXIST\n";

				} else if (!"".equals(sequenceTargetFilename)) {

					long sequenceTargetFilesize = sequenceTargetItem.getSize();

					if (sequenceTargetFilename.indexOf(" ") != -1)
						error += "ERROR_SEQUENCE_TARGET_FILE_CONTAINS_SPACES\n";
					if (sequenceTargetFilename.indexOf("(") != -1
							|| sequenceTargetFilename.indexOf(")") != -1) {
						error += "ERROR_SEQUENCE_TARGET_FILE_CONTAINS_BRACKETS\n";
					}
					if (sequenceTargetFilesize == 0)
						error += "ERROR_SEQUENCE_TARGET_FILESIZE_ZERO\n";
					if (sequenceTargetFilesize > filesizeLimit)
						error += "ERROR_SEQUENCE_TARGET_FILESIZE_EXCEEDS_LIMIT\n";

				} else if (!"".equals(sequenceTargetTextarea)) {
					writeSequenceFile(sequenceTargetTextarea);
					if (sequenceTargetTextarea.length() > filesizeLimit)
						error += "ERROR_SEQUENCE_TARGET_TEXTAREA_EXCEEDS_LIMIT\n";
					else
						sequenceTargetFilename = "file.seq";
				}
				if (!"".equals(sequenceTargetFilename)) {
					inputFiles.put("seqin", "input" + fs
							+ sequenceTargetFilename);
					parameters.put("seqin", "input" + fs
							+ sequenceTargetFilename);
				}
			}

			if (cell0.isValid()) {
				parameters.put("cell", String.valueOf(cell0));
			}
			if (!"".equals(spacegroup0)) {
				parameters.put("spacegroup", spacegroup0);
			}

			if (!"".equals(dataType0)) {
				parameters.put("dataType", dataType0);
			}

			if (!"".equals(inputType0)) {
				parameters.put("inputType", inputType0);
			}

			if (!"".equals(inputTypeNative)) {
				parameters.put("inputTypeNative", inputTypeNative);
			}

			if (cellNative.isValid()) {
				parameters.put("cellNative", String.valueOf(cellNative));
			}
			if (!"".equals(spacegroupNative)) {
				parameters.put("spacegroupNative", spacegroupNative);
			}
			if (fprime0 != null) {
				parameters.put("fprime", String.valueOf(fprime0));
			}
			if (fprimeprime0 != null) {
				parameters.put("fprimeprime", String.valueOf(fprimeprime0));
			}
			if (cutoff != null) {
				parameters.put("cutoff", String.valueOf(cutoff));
			}

			int ns = structureFactorsItems.size();
			if (ns > 0) {
				parameters.put("nStructureFactorFiles", String.valueOf(ns));
			}
			int fsizeLimit = Integer.parseInt(application
					.getInitParameter("structureFactorsFileLimit"));
			List<String> types = Arrays.asList("peak", "inflection", "high",
					"low");
			for (int i = 0; i < ns; ++i) {
				FileItem item = structureFactorsItems.get(i);
				String fname = fixName(item.getName());
				long fsize = item.getSize();
				if ("".equals(fname)) {
					error += "ERROR_NO_STRUCTURE_FACTORS_FILE\n";
				} else if (fsize == 0) {
					error += "ERROR_STRUCTURE_FACTORS_FILESIZE_ZERO\n";
				}
				if (fname.indexOf(" ") != -1) {
					error += "ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_SPACES\n";
				}
				if (fname.indexOf("(") != -1 || fname.indexOf(")") != -1) {
					error += "ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_BRACKETS\n";
				}
				if (fsize > fsizeLimit) {
					error += "ERROR_STRUCTURE_FACTORS_EXCEEDS_LIMIT\n";
				}
				int j = i + 1;
				inputFiles.put("hklin" + j, "input/" + fname);
				parameters.put("hklin" + j, "input/" + fname);
				if (dataTypes.size() > i && dataTypes.get(i) != null) {
					parameters.put("dataType" + j, dataTypes.get(i));
				}
				if (inputTypes.size() > i && inputTypes.get(i) != null) {
					parameters.put("inputType" + j, inputTypes.get(i));
				}
				if (cells.size() > i && cells.get(i) != null
						&& cells.get(i).isValid()) {
					parameters.put("cell" + j, String.valueOf(cells.get(i)));
				}
				if (spacegroups.size() > i && spacegroups.get(i) != null) {
					parameters.put("spacegroup" + j, spacegroups.get(i));
				}
				if (fprimes.size() > i && fprimes.get(i) != null) {
					parameters.put("fprime" + j, String.valueOf(fprimes.get(i)));
				}
				if (fprimeprimes.size() > i && fprimeprimes.get(i) != null) {
					parameters.put("fprimeprime" + j, String.valueOf(fprimeprimes.get(i)));
				}
			}

			if (substructureAtom != null && !"".equals(substructureAtom)) {
				parameters.put("substructureAtom", substructureAtom);
			} else if ("SHELX".equals(programType)) {
				error += "ERROR_MISSING_SUBSTRUCTURE_ATOM\n";
				parameters.put("substructureAtom", "");
			}

			// used in MrBUMP and CRANK2
			parameters.put("useShelx", String.valueOf(useShelx));

			if (fprime != null) {
				parameters.put("fprime", String.valueOf(fprime));
			}

			if (fprimeprime != null) {
				parameters.put("fprimeprime", String.valueOf(fprimeprime));
			}

			if ("SAD".equals(experimentType)) {
				parameters.put("experimentType", "SAD");
			} else if ("SIRAS".equals(experimentType)) {
				parameters.put("experimentType", "SIRAS");
			} else if (Pattern.matches("MAD.", experimentType)) {
				parameters.put("experimentType", "MAD");
			}
			parameters.put("exp_num_atoms", String.valueOf(exp_num_atoms));
			parameters.put("num_trials", String.valueOf(num_trials));
			parameters.put("num_resid", String.valueOf(num_resid));
			if (dsul > 0) {
				parameters.put("DSUL", String.valueOf(dsul));
			}

			if ("".equals(error)) {
				if (sequenceTargetItem != null
						&& !"".equals(sequenceTargetFilename)) {
					if ("".equals(sequenceTargetTextarea)) {
						uploadFile(sequenceTargetItem, sequenceTargetFilename);
					}
					sequenceTargetFilename = validateSequenceTarget(sequenceTargetFilename);
				}

				if (structureFactorsItem != null) {
					if (structureFactorsFilename.endsWith(".mtz")) {
						uploadStructureFactorsFile(structureFactorsItem,
								structureFactorsFilename, columns);
					} else {
						uploadFile(structureFactorsItem,
								structureFactorsFilename);
					}
					// validateCheckDB(structureFactorsFilename,
					// "structureFactors");
				}

				if (structureFactorsNativeItem != null
						&& !"".equals(structureFactorsNativeFilename)) {
					uploadFile(structureFactorsNativeItem,
							structureFactorsNativeFilename);
				}

				if (structureFactorsItems.size() > 0) {
					for (int i = 1; i <= structureFactorsItems.size(); i++) {
						FileItem item = structureFactorsItems.get(i - 1);
						if (item != null) {
							String fname = fixName(item.getName());
							uploadFile(item, fname);
						}
					}
				}

				if (coordinatesItem != null) {
					logger.debug("coordinatesFilename = "
							+ coordinatesFilename);
					if (!"".equals(coordinatesFilename)) {
						uploadFile(coordinatesItem, coordinatesFilename);
						// validateCheckDB(coordinatesFilename, "coordinates");
					}
				}

				if (zipfileItem != null) {
					logger.debug("zipfileFilename = " + zipfileFilename);
					if (!"".equals(zipfileFilename)) {
						uploadFile(zipfileItem, zipfileFilename);
						// validateCheckDB(zipfileFilename, "zipfile");
					}
				}

			}

			if ("MrBUMP".equals(programType) || "SHELX".equals(programType)) {
				if (useShelx) {
					writeEmptyFile("shelx.txt");
				}
			}

			if ("CRANK2".equals(programType)) {
				if (newStructure) {
					writeEmptyFile("newStructure.txt");
				}
			}

			if ("MrBUMP".equals(programType)) {
				inputFiles.put("keyin", "input" + fs + "keywords.txt");
				Path p1 = Paths.get(application
						.getInitParameter("mrbumpKeywordsFile"));
				if (useShelx) {
					p1 = Paths.get(application
							.getInitParameter("mrbumpKeywordsFileWithShelx"));
				}
				Path p2 = Paths.get(idDir, "input", "keywords.txt");
				try {
					Files.copy(p1, p2);
				} catch (IOException e) {
					throw e;
				}
			}

			writeInfoFile(structureFactorsFilename, sequenceTargetFilename,
					coordinatesFilename);

		}

		if (last_page) {
			if ("CRANK2".equals(programType) || "AMPLE".equals(programType)
					|| "SHELX".equals(programType) || "MoRDa".equals(programType)) {
				model.setPublicOutputDir();
				model.setPublicOutputURI();
				// try {
				// Files.createDirectory(Paths.get(idDir, "crank2"));
				// } catch (IOException ex) {
				// ex.printStackTrace();
				// }
			}
			if ("Balbes".equals(programType)) {
				if (!"".equals(checkFullSpacegroup))
					writeEmptyFile("checkFullSpacegroup.txt");
				if (!"".equals(arpWarp))
					writeEmptyFile("arpWarp.txt");
			}
			if ("MoRDa".equals(programType)) {
				if (!"".equals(checkAlternativeSpacegroups))
					parameters.put("checkAlternativeSpacegroups", checkAlternativeSpacegroups);
			}
			writeCmdFile(programType, inputFiles, parameters);
			writeInputFile(programType, parameters);
			writeMillisecondsFile();
			writeEmailFile(disseminationLevel);

			logger.debug("\nidDir: " + idDir + ":");

			try {

				if ("".equals(error)) {
					// start process by writing "StartingProcess.txt" into idDir
					model.runnableProgramsStartProcess(idDir);
					model.setRunStartedId(id);
				}

				// do this even if there are no errors
				writeErrorFile(error);

				if (!"".equals(error)) {
					logger.info(error);
				}

				// sendMail(programType + fs + model.getUsername() + fs + id,
				// error);

			} catch (IOException e) {
				throw new ServletException(e.getMessage());
			}
		}

		String next = "";

		if ("".equals(error)) {
			// if ("CRANK2".equals(programType) && upload_page) {
			// StringBuilder sb = new StringBuilder("/runnableProgramsRun"
			// + programType + ".jsp?page=2");
			// for (Iterator<String> keys = columns.keySet().iterator(); keys
			// .hasNext();) {
			// String key = keys.next();
			// sb.append("&");
			// sb.append(URLEncoder.encode(key, "UTF-8"));
			// sb.append("=");
			// sb.append(columns.get(key));
			// }
			// next = String.valueOf(sb);
			// } else {
			next = "/runnableProgramsTable.jsp";
			response.addHeader("X-StartedId", id);
			// }
		} else {
			if("CRANK2".equals(programType) || "SHELX".equals(programType)) {
				next = "/runnableProgramsRunSHELX.jsp?id=" + id
					+ "&repeat=true";
			} else {
				next = "/runnableProgramsRun" + programType + ".jsp?id=" + id
					+ "&repeat=true";
			}
		}

		RequestDispatcher rd = application.getRequestDispatcher(next);
		if (rd == null) {
			throw new ServletException("Could not find " + next);
		}
		rd.forward(request, response);
	}

	public void createUserDir(String userDir) throws IOException {
		File userDirFile = new File(userDir);
		userDirFile.mkdirs();
	}

	public void checkNoRuns(String programTypeDir) {

		int maxNoProgramRuns = Integer.parseInt(application
				.getInitParameter("maxNoProgramRuns"));

		int dirCount = 0;

		File programTypeDirFile = new File(programTypeDir);

		if (programTypeDirFile.exists()) {

			String[] userDirList = programTypeDirFile.list();

			for (int i = 0; i < userDirList.length; i++) {

				File userDirFile = new File(programTypeDirFile + fs
						+ userDirList[i]);

				if (userDirFile.isDirectory()) {

					String[] idDirList = userDirFile.list();

					for (int j = 0; j < idDirList.length; j++) {

						File idDirFile = new File(userDirFile + fs
								+ idDirList[j]);

						if (idDirFile.isDirectory()) {
							File pr = new File(idDirFile + fs
									+ "processRunning.txt");
							File st = new File(idDirFile + fs
									+ "processStopped.txt");
							File pe = new File(idDirFile + fs
									+ "processEnded.txt");
							if (pr.exists() && !st.exists() && !pe.exists()) {
								dirCount++;
							}
						}
					}
				}
			}

			if (dirCount >= maxNoProgramRuns) {
				error += "ERROR_MAXIMUM_RUNS_EXCEEDED\n";
			}
		}
	}

	// IE fix
	public String fixName(String name) {

		if (name.lastIndexOf("\\") != 0) {
			name = name.substring(name.lastIndexOf("\\") + 1);
		}

		return name;
	}

	public void uploadFile(FileItem item, String name) throws ServletException {

		logger.debug("uploaded File: " + name);
		if (!uploadedFiles.contains(name)) {
			logger.debug("The file "+name+" has not been uploaded yet.");
		} else {
			logger.debug("The file "+name+" was already uploaded.");
		}
		File uploadedFile = new File(idDir + fs + "input" + fs + name);

		try {
			item.write(uploadedFile);
		} catch (Exception e) {
			logger.error("upload of file "+String.valueOf(uploadedFile)+" failed");
			throw new ServletException(e.getMessage());
		}

		uploadedFiles.add(name);
	}

	public void uploadStructureFactorsFile(FileItem item, String name,
			HashMap<String, String> columns) throws ServletException {

		uploadFile(item, name);
		long fsize = item.getSize(); // file size in bytes
		Path path = Paths.get(idDir + fs + "input" + fs + name);
		try {
			byte[] data = Files.readAllBytes(path);
			ByteBuffer bf = ByteBuffer.wrap(data);
			int ipos = bf.getInt(4); // this assumes big endian format
			if (ipos < 1 || ipos > fsize / 4) {
				ipos = Integer.reverseBytes(ipos); // change to little endian
			}
			ipos = ipos * 4 - 1; // header position in bytes
			StringBuilder sb = new StringBuilder();
			for (int i = ipos; i < fsize; i++) {
				sb.append((char) bf.get(i));
			}
			String[] headers = String.valueOf(sb).split("\\s+");
			int n = headers.length;
			for (int i = 0; i < n; i++) {
				if (Pattern.matches(".*COLUMN.*", headers[i])) {
					columns.put(headers[i + 1], headers[i + 2]);
				}
			}
		} catch (Exception e) {
			logger.error("failed to upload the structure factors file "+String.valueOf(path));
			throw new ServletException(e.getMessage());
		}
	}

	public void writeInfoFile(String structureFactorsFilename,
			String sequenceTargetFilename, String coordinatesFilename)
			throws IOException {

		DateFormat df = new SimpleDateFormat("HH-mm-dd-MMM-yyyy");
		String date = df.format(new Date());

		File infoFile = new File(idDir + fs + "info.txt");

		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter(infoFile));
			bw.write(date + ":" + structureFactorsFilename + ":"
					+ sequenceTargetFilename + ":" + coordinatesFilename);
			bw.newLine();
			bw.close();
		} catch (IOException e) {
			logger.error("failed to write the info file "+String.valueOf(infoFile));
			throw e;
		}
	}

	public void writeMillisecondsFile() throws IOException {
		// write the number of milliseconds since the epoch (Jan 1, 1970,
		// 00:00:00 GMT) into a file
		Date now = new Date();
		String time = String.valueOf(now.getTime());
		File mfile = new File(idDir + fs + "milliseconds.txt");
		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter(mfile));
			bw.write(time);
			bw.newLine();
			bw.close();
		} catch (IOException e) {
			logger.error("failed to write into the milliseconds file "+String.valueOf(mfile));
			throw e;
		}
	}

	public void writeEmailFile(String disseminationLevel) throws IOException {

		String runnableProgramsPasswdFile = application
				.getInitParameter("runnableProgramsPasswdFile");

		String username = "";
		String email = "";
		String emailAddress = "";

		try(BufferedReader in = new BufferedReader(new FileReader(
					runnableProgramsPasswdFile))) {

			String line;

			while ((line = in.readLine()) != null) {

				StringTokenizer st = new StringTokenizer(line, ":");

				while (st.hasMoreTokens()) {

					username = st.nextToken();
					st.nextToken();
					st.nextToken();
					emailAddress = st.nextToken();

					if (username.equals(model.getUsername())) {
						email = emailAddress;
						break;
					}
				}
			}

		} catch (IOException e) {
			logger.error("failed to read the email from the password file");
			throw e;
		}

		File emailFile = new File(idDir + fs + "email.txt");

		try {
			BufferedWriter bw = new BufferedWriter(new FileWriter(emailFile));
			bw.write(email);
			bw.newLine();
			if (!"".equals(disseminationLevel)) {
				bw.write(disseminationLevel);
				bw.newLine();
			}
			bw.close();
		} catch (IOException e) {
			logger.error("failed to write the email file "+String.valueOf(emailFile));
			throw e;
		}
	}

	public void writeEmptyFile(String name) throws IOException {

		File f = new File(idDir + fs + name);
		try{
			PrintWriter out = new PrintWriter(new FileWriter(f));
			out.close();
		} catch (IOException e) {
			logger.error("failed to write the empty file "+String.valueOf(f));
			throw e;
		}
	}

	public void writeSequenceFile(String sequenceTargetTextarea)
			throws IOException {

		File seqFile = new File(idDir + fs + "input" + fs + "file.seq");

		if (!seqFile.exists()) {
			try {
				BufferedWriter bw = new BufferedWriter(new FileWriter(seqFile));
				bw.write(sequenceTargetTextarea);
				bw.newLine();
				bw.close();
			} catch (IOException e) {
				logger.error("failed to write the sequence file "+String.valueOf(seqFile));
				throw e;
			}
		}
	}

	public void writeCmdFile(String programType,
			HashMap<String, String> inputFiles, HashMap<String, String> parameters) throws IOException {

		try {
			GetPropertyValues gpv = new GetPropertyValues();
			String CCP4 = gpv.getProperty("ccp4");
			File f = new File(idDir + fs + "cmd.txt");
			PrintWriter out = new PrintWriter(new FileWriter(f));
			switch (programType) {
			case "MrBUMP":
				out.write("mrbump");
				break;
			case "AMPLE":
				out.write("ample");
				break;
			case "Zanuda":
				out.write("zanuda");
				break;
			case "CRANK2":
				out.write("ccp4-python "
						+ CCP4
						+ "/share/ccp4i2/pipelines/crank2/crank2/crank2.py --rvapi-viewer 0  --rvapi-uri-prefix "
						//+ model.getPublicOutputURL());
						+ "./");
				break;
			case "SHELX":
				out.write("ccp4-python "
						+ CCP4
						+ "/share/ccp4i2/pipelines/crank2/crank2/crank2.py --rvapi-viewer 0  --rvapi-uri-prefix "
						//+ model.getPublicOutputURL());
						+ "./");
				break;
			case "Balbes":
				// For Balbes, the server side script will substitute the name
				// of the command here.
				break;
			case "MoRDa":
				String morda = gpv.getProperty("morda");
				out.write(morda);
				break;
			}
			switch (programType) {
			case "MrBUMP":
				Iterator<String> lnames = inputFiles.keySet().iterator();
				String lname;
				while (lnames.hasNext()) {
					lname = lnames.next();
					out.write(" " + lname);
					out.write(" " + inputFiles.get(lname));
				}
				break;
			case "AMPLE":
				out.write(" -fasta " + inputFiles.get("seqin"));
				out.write(" -mtz " + inputFiles.get("hklin"));
				out.write(" -models " + inputFiles.get("zipin"));
				//out.write(" -webserver_uri " + model.getPublicOutputURL() + "/");
				out.write(" -webserver_uri " + "../../");
				break;
			case "Zanuda":
				lnames = inputFiles.keySet().iterator();
				while (lnames.hasNext()) {
					lname = lnames.next();
					out.write(" " + lname);
					out.write(" " + inputFiles.get(lname));
				}
				break;
			case "Balbes":
				out.write(inputFiles.get("hklin"));
				out.write(" " + inputFiles.get("seqin"));
				break;
			case "MoRDa":
				out.write(" -s "+inputFiles.get("seqin"));
				out.write(" -f "+inputFiles.get("hklin"));
				out.write(" -r jsrview");
				out.write(" -o output/summary.log");
				if (parameters.containsKey("checkAlternativeSpacegroups")) {
					out.write(" -a");
				}
				break;
			}
			if ("Zanuda".equals(programType)) {
				model.setPublicOutputDir();
				model.setPublicOutputURI();
				out.write(" " + "mp output ");
				out.write("output");
				out.write(" " + "outdir ");
				out.write(model.getPublicOutputURL() + "/../");
			}
			out.write("\n");
			out.close();
		} catch (IOException e) {
			throw e;
		}
	}

	public void writeInputFile(String programType,
			HashMap<String, String> parameters) throws IOException {
		File f = new File(idDir + fs + "input.txt");
		try (PrintWriter out = new PrintWriter(new FileWriter(f))) {
			out.flush();
			switch (programType) {
			case "MrBUMP":
				// String keywordsFileParam;
				// if (Files.exists(Paths.get(idDir, "shelx.txt"))) {
				// keywordsFileParam = "mrbumpKeywordsFileWithShelx";
				// } else {
				// keywordsFileParam = "mrbumpKeywordsFile";
				// }
				// try (BufferedReader br = new BufferedReader(new FileReader(
				// application.getInitParameter(keywordsFileParam)))) {
				// for (String line; (line = br.readLine()) != null;) {
				// out.write(line);
				// out.write("\n");
				// }
				// }
				// out.write("PDBLOCAL /data2/pdb/data/structures/divided/pdb/\n");
				// out.write("CHECK False\n");
				// out.write("jobid MrBUMP_cluster_run\n");
				// out.write("DOHHPRED True\n");
				// out.write("HHINDEX /data2/hh-suite/databases/hhsuite_dbs/uniprot20/uniprot20_hhm_db.index\n");
				// out.write("HHDBPDB /data2/hh-suite/databases/hhsuite_dbs/pdb70/pdb70_08Feb14_hhm_db\n");
				// out.write("HHLIB /home/rmk65/opt/hhpred/hhsuite-2.0.16-linux-x86_64/lib/hh\n");
				// out.write("SHEL True\n");
				// out.write("MRPROGRAM PHASER\n");
				// out.write("HHSCORE True\n");
				// out.write("UPDATE False\n");
				// out.write("MDLS True\n");
				// out.write("MDLC True\n");
				// out.write("SCOP False\n");
				// out.write("SSMS False\n");
				// out.write("PQSS False\n");
				// out.write("BUCC True\n");
				// out.write("NCYC 40\n");
				out.write("END\n");
				break;
			case "Zanuda":
				out.write("END\n");
				break;
			case "AMPLE":
				out.write("END\n");
				break;
			case "Balbes":
				out.write("END\n");
				break;
			case "CRANK2":
				String extype = parameters.get("experimentType");
				if (parameters.containsKey("hklin")) {
					String inputType = "intensities";
					if (parameters.containsKey("inputType")) {
						inputType = parameters.get("inputType");
					}
					out.write("fsigf plus");
					out.write(" file=");
					out.write(parameters.get("hklin"));
					if ("amplitudes".equals(inputType)) {
						out.write(" f=");
					} else {
						out.write(" i=");
					}
					if (parameters.containsKey("Iplus")) {
						out.write(parameters.get("Iplus"));
					} else {
						out.write("I+");
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" sigf=");
					} else {
						out.write(" sigi=");
					}
					if (parameters.containsKey("SIGIplus")) {
						out.write(parameters.get("SIGIplus"));
					} else {
						out.write("SIGI+");
					}
					if (parameters.containsKey("cell")) {
						out.write(" cell=" + parameters.get("cell"));
					}
					if (parameters.containsKey("spacegroup")) {
						out.write(" spgr=" + parameters.get("spacegroup"));
					}
					out.write("\n");
					out.write("fsigf minus");
					if ("amplitudes".equals(inputType)) {
						out.write(" f=");
					} else {
						out.write(" i=");
					}
					if (parameters.containsKey("Iminus")) {
						out.write(parameters.get("Iminus"));
					} else {
						out.write("I-");
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" sigf=");
					} else {
						out.write(" sigi=");
					}
					if (parameters.containsKey("SIGIminus")) {
						out.write(parameters.get("SIGIminus"));
					} else {
						out.write("SIGI-");
					}
					out.write("\n");
					if (parameters.containsKey("fprime")) {
						out.write("fp=");
						out.write(parameters.get("fprime"));
						out.write("\n");
					}
					if (parameters.containsKey("fprimeprime")) {
						out.write("fpp=");
						out.write(parameters.get("fprimeprime"));
						out.write("\n");
					}
				}
				if (parameters.containsKey("nStructureFactorFiles")) {
					int ns;
					try{
						ns = Integer.parseInt(parameters.get("nStructureFactorFiles"));
					} catch(NumberFormatException e) {
						ns = 0;
						logger.error("number of structure factor files is not a number in CRANK2 input");
					}
					for (int i = 1; i <= ns; ++i) {
						String inputType = "intensities";
						if (parameters.containsKey("inputType" + i)) {
							inputType = parameters.get("inputType" + i);
						}
						if (parameters.containsKey("hklin" + i)) {
							out.write("fsigf plus");
							if (parameters.containsKey("dataType" + i)) {
								out.write(" dname="
										+ parameters.get("dataType" + i));
							}
							out.write(" file=");
							out.write(parameters.get("hklin" + i));
							if ("amplitudes".equals(inputType)) {
								out.write(" f=");
							} else {
								out.write(" i=");
							}
							if (parameters.containsKey("Iplus" + i)) {
								out.write(parameters.get("Iplus" + i));
							} else {
								out.write("I" + i + "+");
							}
							if ("amplitudes".equals(inputType)) {
								out.write(" sigf=");
							} else {
								out.write(" sigi=");
							}
							if (parameters.containsKey("SIGIplus" + i)) {
								out.write(parameters.get("SIGIplus" + i));
							} else {
								out.write("SIGI" + i + "+");
							}
							if (parameters.containsKey("cell" + i)) {
								out.write(" cell=" + parameters.get("cell" + i));
							}
							if (parameters.containsKey("spacegroup" + i)) {
								out.write(" spgr="
										+ parameters.get("spacegroup" + i));
							}
							out.write("\n");
							out.write("fsigf minus");
							if (parameters.containsKey("dataType" + i)) {
								out.write(" dname="
										+ parameters.get("dataType" + i));
							}
							if ("amplitudes".equals(inputType)) {
								out.write(" f=");
							} else {
								out.write(" i=");
							}
							if (parameters.containsKey("Iminus" + i)) {
								out.write(parameters.get("Iminus" + i));
							} else {
								out.write("I" + i + "-");
							}
							if ("amplitudes".equals(inputType)) {
								out.write(" sigf=");
							} else {
								out.write(" sigi=");
							}
							if (parameters.containsKey("SIGIminus" + i)) {
								out.write(parameters.get("SIGIminus" + i));
							} else {
								out.write("SIGI" + i + "-");
							}
							out.write("\n");
						}
					}
				}
				if (parameters.containsKey("native")) {
					String inputType = "intensities";
					if (parameters.containsKey("inputTypeNative")) {
						inputType = parameters.get("inputTypeNative");
					}
					out.write("fsigf average dname=native xname=native file=");
					out.write(parameters.get("native"));
					if (parameters.containsKey("cellNative")) {
						out.write(" cell=" + parameters.get("cellNative"));
					}
					if (parameters.containsKey("spacegroupNative")) {
						out.write(" spgr=" + parameters.get("spacegroupNative"));
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" f=");
					} else {
						out.write(" i=");
					}
					if (parameters.containsKey("INative")) {
						out.write(parameters.get("INative"));
					} else {
						out.write("I");
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" sigf=");
					} else {
						out.write(" sigi=");
					}
					if (parameters.containsKey("SIGINative")) {
						out.write(parameters.get("SIGINative"));
					} else {
						out.write("SIGI");
					}
					out.write("\n");
				}
				out.write("target::" + extype + "\n");
				String atom = parameters.get("substructureAtom");
				out.write("model substr atomtype=" + atom);
				if (parameters.containsKey("exp_num_atoms")) {
					int n;
					try {
						n = Integer.parseInt(parameters.get("exp_num_atoms"));
					} catch (NumberFormatException ex) {
						n = 0;
						logger.error("exp_num_atoms is not a number in CRANK2 input");
					}
					if (n > 0) {
						out.write(" exp_num_atoms="
								+ parameters.get("exp_num_atoms"));
					}
				}
				if (parameters.containsKey("num_resid")) {
					int n;
					try {
						n = Integer.parseInt(parameters.get("num_resid"));
					} catch (NumberFormatException ex) {
						n = 0;
						logger.error("num_resid is not a number in CRANK2 input");
					}
					if (n > 0) {
						out.write(" residues_mon="
								+ parameters.get("num_resid"));
					}
				}
				if (parameters.containsKey("nStructureFactorFiles")) {
					int ns;
					try{
						ns = Integer.parseInt(parameters.get("nStructureFactorFiles"));
					} catch(NumberFormatException e) {
						ns = 0;
						logger.error("number of structure factor files is not a number in CRANK2 input");
					}
					for (int i = 1; i <= ns; ++i) {
						if (parameters.containsKey("fprime" + i)
								&& parameters.containsKey("fprimeprime" + i)) {
							if (parameters.containsKey("dataType" + i)) {
								String dtype = parameters.get("dataType" + i);
								out.write(" d_name=" + dtype);
							}
							Double fp = new Double(parameters.get("fprime" + i));
							Double fpp = new Double(
									parameters.get("fprimeprime" + i));
							out.write(" fp=" + String.valueOf(fp));
							out.write(" fpp=" + String.valueOf(fpp));
						}
					}
				}
				out.write("\n");
				if (parameters.containsKey("seqin")) {
					out.write("sequence file=" + parameters.get("seqin") + "\n");
				}
				out.write("createfree no_output_to_next_step::True\n");
				out.write("faest\n");
				out.write("substrdet");
				if ("S".equals(atom) && parameters.containsKey("DSUL")) {
					out.write(" num_dsul::" + parameters.get("DSUL"));
				}
				if (parameters.containsKey("cutoff")) {
					out.write(" high_res_cutoff::" + parameters.get("cutoff"));
				}
				out.write("\n");
				if ("SAD".equals(extype)) {
					out.write("refatompick\n");
				} else {
					out.write("phas\n");
				}
				out.write("handdet\n");
				out.write("dmfull\n");
				if ("SAD".equals(extype)) {
					out.write("comb_phdmmb");
				} else {
					out.write("mbref");
				}
				out.write(" exclude obj_from=0,typ=freeR\n");
				out.write("ref target::MLHL exclude obj_from=0,typ=freeR\n");
				break;
			case "SHELX":
				if (parameters.containsKey("hklin")) {
					String inputType = "intensities";
					if (parameters.containsKey("inputType")) {
						inputType = parameters.get("inputType");
					}
					out.write("fsigf plus");
					out.write(" file=");
					out.write(parameters.get("hklin"));
					if ("amplitudes".equals(inputType)) {
						out.write(" f=");
					} else {
						out.write(" i=");
					}
					if (parameters.containsKey("Iplus")) {
						out.write(parameters.get("Iplus"));
					} else {
						out.write("I+");
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" sigf=");
					} else {
						out.write(" sigi=");
					}
					if (parameters.containsKey("SIGIplus")) {
						out.write(parameters.get("SIGIplus"));
					} else {
						out.write("SIGI+");
					}
					if (parameters.containsKey("cell")) {
						out.write(" cell=" + parameters.get("cell"));
					}
					if (parameters.containsKey("spacegroup")) {
						out.write(" spgr=" + parameters.get("spacegroup"));
					}
					out.write("\n");
					out.write("fsigf minus");
					if ("amplitudes".equals(inputType)) {
						out.write(" f=");
					} else {
						out.write(" i=");
					}
					if (parameters.containsKey("Iminus")) {
						out.write(parameters.get("Iminus"));
					} else {
						out.write("I-");
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" sigf=");
					} else {
						out.write(" sigi=");
					}
					if (parameters.containsKey("SIGIminus")) {
						out.write(parameters.get("SIGIminus"));
					} else {
						out.write("SIGI-");
					}
					out.write("\n");
				}
				if (parameters.containsKey("nStructureFactorFiles")) {
					int ns = Integer.parseInt(parameters
							.get("nStructureFactorFiles"));
					for (int i = 1; i <= ns; ++i) {
						String inputType = "intensities";
						if (parameters.containsKey("inputType" + i)) {
							inputType = parameters.get("inputType" + i);
						}
						if (parameters.containsKey("hklin" + i)) {
							out.write("fsigf plus");
							if (parameters.containsKey("dataType" + i)) {
								out.write(" dname="
										+ parameters.get("dataType" + i));
							}
							out.write(" file=");
							out.write(parameters.get("hklin" + i));
							if ("amplitudes".equals(inputType)) {
								out.write(" f=");
							} else {
								out.write(" i=");
							}
							if (parameters.containsKey("Iplus" + i)) {
								out.write(parameters.get("Iplus" + i));
							} else {
								out.write("I" + i + "+");
							}
							if ("amplitudes".equals(inputType)) {
								out.write(" sigf=");
							} else {
								out.write(" sigi=");
							}
							if (parameters.containsKey("SIGIplus" + i)) {
								out.write(parameters.get("SIGIplus" + i));
							} else {
								out.write("SIGI" + i + "+");
							}
							if (parameters.containsKey("cell" + i)) {
								out.write(" cell=" + parameters.get("cell" + i));
							}
							if (parameters.containsKey("spacegroup" + i)) {
								out.write(" spgr="
										+ parameters.get("spacegroup" + i));
							}
							out.write("\n");
							out.write("fsigf minus");
							if (parameters.containsKey("dataType" + i)) {
								out.write(" dname="
										+ parameters.get("dataType" + i));
							}
							if ("amplitudes".equals(inputType)) {
								out.write(" f=");
							} else {
								out.write(" i=");
							}
							if (parameters.containsKey("Iminus" + i)) {
								out.write(parameters.get("Iminus" + i));
							} else {
								out.write("I" + i + "-");
							}
							if ("amplitudes".equals(inputType)) {
								out.write(" sigf=");
							} else {
								out.write(" sigi=");
							}
							if (parameters.containsKey("SIGIminus" + i)) {
								out.write(parameters.get("SIGIminus" + i));
							} else {
								out.write("SIGI" + i + "-");
							}
							out.write("\n");
						}
					}
				}
				if (parameters.containsKey("native")) {
					String inputType = "intensities";
					if (parameters.containsKey("inputTypeNative")) {
						inputType = parameters.get("inputTypeNative");
					}
					out.write("fsigf average dname=native xname=native file=");
					out.write(parameters.get("native"));
					if (parameters.containsKey("cellNative")) {
						out.write(" cell=" + parameters.get("cellNative"));
					}
					if (parameters.containsKey("spacegroupNative")) {
						out.write(" spgr=" + parameters.get("spacegroupNative"));
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" f=");
					} else {
						out.write(" i=");
					}
					if (parameters.containsKey("INative")) {
						out.write(parameters.get("INative"));
					} else {
						out.write("I");
					}
					if ("amplitudes".equals(inputType)) {
						out.write(" sigf=");
					} else {
						out.write(" sigi=");
					}
					if (parameters.containsKey("SIGINative")) {
						out.write(parameters.get("SIGINative"));
					} else {
						out.write("SIGI");
					}
					out.write("\n");
				}
				out.write("target::" + parameters.get("experimentType") + "\n");
				atom = parameters.get("substructureAtom");
				out.write("model substr atomtype=" + atom);
				if (parameters.containsKey("exp_num_atoms")) {
					int n = 0;
					try {
						n = Integer.parseInt(parameters.get("exp_num_atoms"));
					} catch (NumberFormatException ex) {
					}
					if (n > 0) {
						out.write(" exp_num_atoms="
								+ parameters.get("exp_num_atoms"));
					}
				}
				if (parameters.containsKey("num_resid")) {
					int n = 0;
					try {
						n = Integer.parseInt(parameters.get("num_resid"));
					} catch (NumberFormatException ex) {
					}
					if (n > 0) {
						out.write(" residues_mon="
								+ parameters.get("num_resid"));
					}
				}
				out.write("\n");
				if (parameters.containsKey("seqin")) {
					out.write("sequence file=" + parameters.get("seqin") + "\n");
				}
				out.write("faest shelxc\n");
				out.write("substrdet");
				if ("S".equals(atom) && parameters.containsKey("DSUL")) {
					out.write(" num_dsul::" + parameters.get("DSUL"));
				}
				if (parameters.containsKey("cutoff")) {
					out.write(" high_res_cutoff::" + parameters.get("cutoff"));
				}
				if (parameters.containsKey("num_trials")) {
					int n;
					try {
						n = Integer.parseInt(parameters.get("num_trials"));
					} catch (NumberFormatException ex) {
						n = 0;
						logger.error("num_trials is not a number in SHELX input");
					}
					if (n > 0) {
						out.write(" num_trials::"
								+ parameters.get("num_trials"));
					}
				}
				out.write(" shelxd");
				out.write("\n");
				out.write("phdmmb shelxe\n");
				out.write("mbref target::MLHL\n");
				break;
			}
		}
	}

	public void writeErrorFile(String error) throws IOException {

		try {

			BufferedWriter bw = new BufferedWriter(new FileWriter(idDir + fs
					+ "error.txt"));
			bw.write(error);
			bw.newLine();
			bw.close();

		} catch (IOException e) {
			throw e;
		}
	}

	public static void runProcess(String cmd) throws IOException {

		String str = "";

		try {

			String[] cmd1 = { "/bin/sh", "-c", cmd };
			Process p = Runtime.getRuntime().exec(cmd1);

			BufferedReader stdError = new BufferedReader(new InputStreamReader(
					p.getErrorStream()));

			while ((str = stdError.readLine()) != null) {
				LoggerFactory.getLogger("controller.RunnableProgramsRunAction").error("runProcess stdError: " + str);
			}

		} catch (IOException e) {
			throw e;
		}
	}

	public String validateSequenceTarget(String name) throws IOException {

		String filename = idDir + fs + "input" + fs + name;

		String line = "";
		String str = "";
		String oldStr = "";
		int sequenceLines = 0;

		try {
			BufferedReader in = new BufferedReader(new FileReader(filename));
			while ((line = in.readLine()) != null) {
				oldStr += line + "\n";
				// line = line.replaceAll("^M", "");
				if (line.matches("^$")) {
					//
				} else if (line.charAt(0) == '>') {
					str += line + "\n";
				} else {
					String text = "";

					for (int i = 0; i < line.length(); i++) {

						char ch = line.charAt(i);

						if (ch >= 'A' && ch <= 'Z') {
							if (ch != 'B' && ch != 'J' && ch != 'O'
									&& ch != 'U' && ch != 'X' && ch != 'Z') {
								text += ch;
							}
						}

						if (ch >= 'a' && ch <= 'z') {
							if (ch != 'b' && ch != 'j' && ch != 'o'
									&& ch != 'u' && ch != 'x' && ch != 'z') {
								text += ch;
							}
						}
					}

					if (!"".equals(text)) {
						str += text + "\n";
						sequenceLines++;
					}
				}
			}
			in.close();
		} catch (IOException e) {
			throw e;
		}

		// check first character str matches with '>'
		if (str.charAt(0) == '>' && sequenceLines > 0) {
			// logger.info(idDir +
			// ": first character of line matches with '>', sequenceLines = " +
			// sequenceLines);
		} else {
			error = "ERROR_SEQUENCE_TARGET_INVALID";
			// if (str.charAt(0) != '>') logger.info(idDir +
			// ": ERROR - first line does not match with '>'");
			// if (sequenceLines == 0) logger.info(idDir +
			// ": ERROR - sequenceLines = " + sequenceLines);
		}

		String oldFilename = filename + "_old";

		try {
			PrintWriter out = new PrintWriter(new FileWriter(oldFilename));
			out.write(oldStr);
			out.close();
		} catch (IOException e) {
			throw e;
		}

		// ensure extension is .seq
		int dot = name.lastIndexOf('.');

		if (dot == -1) {
			// logger.info(idDir + ": changing " + name + " to " + name +
			// ".seq");
			name += ".seq";
		} else {
			String base = name.substring(0, dot);
			String extension = name.substring((dot + 1), name.length());

			if (!"seq".equals(extension)) {
				// logger.info(idDir + ": changing " + name + " to " +
				// base + ".seq");
				name = base + ".seq";
			}
		}

		String newFilename = idDir + fs + "input" + fs + name;

		// write text to sequence target file
		// logger.info(idDir + ": writing text to sequence target file "
		// + newFilename);

		try {
			PrintWriter out = new PrintWriter(new FileWriter(newFilename));
			out.write(str);
			out.close();
		} catch (IOException e) {
			throw e;
		}

		return name;
	}

	public void sendMail(String subject, String error) {

		if (!"".equals(error))
			subject += " [" + error + "]";

		try {
			model.sendMail(subject);
		} catch (MessagingException e) {
			logger.error(e.getMessage() + ": " + subject);
		}
	}

	public static DiskFileItemFactory newDiskFileItemFactory(
			ServletContext context, File repository) {
		FileCleaningTracker fileCleaningTracker = FileCleanerCleanup
				.getFileCleaningTracker(context);
		DiskFileItemFactory factory = new DiskFileItemFactory(
				DiskFileItemFactory.DEFAULT_SIZE_THRESHOLD, repository);
		factory.setFileCleaningTracker(fileCleaningTracker);
		return factory;
	}

	private Cell ithCell(ArrayList<Cell> cells, int i) {
		// returns the i'th cell in a list of cells. If the list has fewer
		// elements, then add nulls until it has
		while (cells.size() < i) {
			cells.add(null);
		}
		if (cells.get(i - 1) == null) {
			cells.set(i - 1, new Cell());
		}
		return cells.get(i - 1);
	}
}
