package controller;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import model.*;

public class RunnableProgramsRegisterValidAction extends Action {
    
    public void run() throws ServletException, IOException {
        
        String username = request.getParameter("username");
        String password = request.getParameter("password");
        String institution = request.getParameter("institution");
        String email = request.getParameter("email");
        
        String runnableProgramsPasswdFile = model.getRunnableProgramsPasswdFile();
        
        String tempPassword = "";
        
        try {
            tempPassword = Utility.encryptPassword(password);
        } catch (Exception e) {
            throw new ServletException(e.getMessage());
        }
        
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(runnableProgramsPasswdFile, true));
            bw.write(username + ":" + tempPassword + ":" + institution + ":" + email);
            bw.newLine();
            bw.close();
        } catch (IOException e) {
            throw e;
        }
        
        model.setUsername(username);
		String wwwroot = new GetPropertyValues().getProperty("publicroot");
		// create a public user directory for the session
		new File(wwwroot+'/'+username).mkdirs();
        
        final String next = "/registerValid.jsp?process=false";
        RequestDispatcher rd = application.getRequestDispatcher(next);
        if (rd == null) throw new ServletException("Could not find " + next);
        rd.forward(request, response);
    }
}
