package controller;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import model.Model;

public abstract class Action implements Serializable {

   protected transient HttpServletRequest request;
   protected transient HttpServletResponse response;
   protected transient ServletContext application;
   protected Model model;

   //public abstract void run() throws ServletException, IOException, Exception;
   public abstract void run() throws ServletException, IOException;

   public void setRequest(HttpServletRequest request) {
      this.request = request;
   }

   public void setResponse(HttpServletResponse response) {
      this.response = response;
   }

   public void setApplication(ServletContext application) {
      this.application = application;
   }

   public void setModel(Model model) {
      this.model = model;
   }
}
