<%@page import="java.util.ArrayList"%>
<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page errorPage="ErrorPage.jsp"%>
<%@ page import="model.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session" />

<!DOCTYPE HTML>

<%
	if (model.getUsername().equals("")) {
		throw new ServletException("No model found in runnableProgramsViewResults.jsp");
	}
%>

<%
	String navBar = "<a href='./logout'>Home (Logout)</a>";
	navBar += "&nbsp;>&nbsp;";
	navBar += "<a href='servlet/controller/Link?page=login.jsp'>Login</a>";
	navBar += "&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>";
	navBar += "&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsTable.jsp'>"
			+ model.getRunnableProgramsType() + "</a>";
	navBar += "&nbsp;>&nbsp;View Results";
	String runnableProgramsType = model.getRunnableProgramsType();
%>

<c:set target="${model}" property="runnableProgramsExistingJobDir"
	value="${model.runnableProgramsOutputBaseDir}/${model.runnableProgramsType}/${model.username}/${model.runnableProgramsExistingId}" />

<html lang="EN">
<head>
<meta charset="UTF-8">
<title>CCP4 online</title>
<%@include file="initialisation.jsp"%>
<script src="./resources/jquery.js" type="text/javascript"></script>
<script src="./resources/jquery.easing.js" type="text/javascript"></script>
<script src="./resources/myJqueryFileTree/jqueryFileTree.js"
	type="text/javascript"></script>
<link href="./resources/myJqueryFileTree/jqueryFileTree.css"
	rel="stylesheet" type="text/css" media="screen" />
<script type="text/javascript">
    var fs = "<%=File.separator%>";
	var datadir = "${model.runnableProgramsOutputBaseDir}";
	var program = "${model.runnableProgramsType}";
	var jobdir = "${model.runnableProgramsExistingJobDir}";
	var jobid = "${model.runnableProgramsExistingId}";
	var isAWRun = "${model.isArpWarpRun()}";
	var spacegroup = "${model.currentSpacegroup}";
	var user = "${model.username}";
	var currentFile = "${model.runnableProgramsFilename}";
	var currentDir = "${model.runnableProgramsFilenameDir}";
	var fullname = program + fs + user + fs + jobid + fs + currentDir + fs
			+ currentFile;
	String.prototype.endsWith = function(suffix) {
		return this.indexOf(suffix, this.length - suffix.length) !== -1;
	};
	var changeCurrent = function(file) {
		var index = file.lastIndexOf("/");
		currentFile = file.substring(index + 1);
		currentDir = file.substring(jobdir.length + 1, index);
		update();
	};
	var update = function() {
		$('#downloadlink').html(
				'CURRENT FILE: <strong><a href="downloads?file=' + program + fs
						+ user + fs + jobid + fs + currentDir + fs
						+ currentFile + '">' + currentFile
						+ '</a></strong>&nbsp;(click to download)');
		if (currentFile.endsWith(".log") || currentFile.endsWith(".txt")
				|| currentFile.endsWith(".fasta")
				|| currentFile.endsWith(".pir") || currentFile.endsWith(".sol")
				|| currentFile.endsWith(".sum")) {
			$.get("./servlet/controller/GetFileContents", {
				dir : currentDir,
				file : currentFile
			}, function(data) {
				$('#fileContents').text(data);
			});
		} else if (currentFile.endsWith(".pdf")) {
			$('#fileContents').html("");
			$('#viewPDFLink')
					.html(
							'[<a href="'
									+ 'downloads?file='
									+ program
									+ fs
									+ user
									+ fs
									+ jobid
									+ fs
									+ currentDir
									+ fs
									+ currentFile
									+ '" target="blank">click here to view this pdf file</a>]');
			$('#downloadlink').html(
					'CURRENT FILE: <strong>' + currentFile + '</strong>');
		} else {
			$('#fileContents').html("");
		}
		;
	};
	$(document)
			.ready(
					function() {
						$('#MrBUMPOutputDir')
								.fileTree(
										{
											root : jobdir + '/output',
											script : './resources/jqueryFileTree/connectors/jqueryFileTree.jsp',
											multiFolder : false
										}, function(file) {
											changeCurrent(file);
										});
						$('#ZanudaOutputDir')
								.fileTree(
										{
											root : jobdir + '/output',
											script : './resources/jqueryFileTree/connectors/jqueryFileTree.jsp',
											multiFolder : false
										}, function(file) {
											changeCurrent(file);
										});
						$('#MrBUMPResultsDir')
								.fileTree(
										{
											root : jobdir
													+ '/search_MrBUMP_cluster_run',
											//$('#MrBUMPResultsDir').fileTree({ root: jobdir + '/search_test_mrbump', 
											script : './resources/jqueryFileTree/connectors/jqueryFileTree.jsp',
											multiFolder : false
										}, function(file) {
											changeCurrent(file);
										});
						$('#CRANK2ResultsDir')
								.fileTree(
										{
											root : jobdir + '/crank2',
											script : './resources/jqueryFileTree/connectors/jqueryFileTree.jsp',
											multiFolder : false
										}, function(file) {
											changeCurrent(file);
										});
						$('#BalbesSGRunResults')
								.fileTree(
										{
											root : jobdir + '/' + spacegroup,
											script : './resources/myJqueryFileTree/connectors/jqueryFileTree.jsp',
											multiFolder : false,
											files : [ 'process_details',
													'template_models',
													'results' ]
										}, function(file) {
											changeCurrent(file);
										});
						$('#BalbesRunResults')
								.fileTree(
										{
											root : jobdir,
											script : './resources/myJqueryFileTree/connectors/jqueryFileTree.jsp',
											multiFolder : false,
											files : [ 'results',
													'template_models',
													'process_details' ]
										}, function(file) {
											changeCurrent(file);
										});
						update();
					});
</script>
</head>

<body>

	<a name="top"></a>

	<div id="results_container_${model.runnableProgramsType}">

		<%@ include file="./header.jsp"%>

		<div id="header">
			<div id="breadcrumb">
				<ul>
					<div id='leftNav'><%=navBar%></div>
					<div id='rightNav'>
						Username: <strong>${model.username}</strong>
					</div>
				</ul>
				<div class="clear">&nbsp;</div>
			</div>
		</div>

		<c:set var="status" value="${model.runnableProgramsExistingStatus}" />

		<div id="content-container">
			<div id="container2">
				<c:if test="${programType=='Zanuda'}">
					<img src="./images/zanudamistic.jpg" height="80" alt=""
						style="float: left; padding-right: 1em;"></img>
					<p>
						Please cite the following paper if you found Zanuda results
						useful:<br /> Lebedev, A. A. &amp; Isupov M. N. (2014). <em>Acta
							Cryst.</em> D<b>70</b>, 2430-2443.
					</p>
				</c:if>
				<c:if test="${status=='starting process'}">
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> IS STARTING
                        <br />
					<br />
                        Your results should appear below within a few minutes:
                        <br />
					<br />
					<input type="button" value="Reload Page"
						onClick="window.location.reload()">
					<br />
					<br />
				</c:if>

				<c:if test="${status=='process ended'}">
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> HAS ENDED
                    </c:if>

				<c:if test="${status=='stopping process'}">
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> IS STOPPING
                        <br />
					<br />
					<input type="button" value="Reload Page" onClick="update()">
				</c:if>

				<c:if test="${status=='process stopped'}">
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> HAS STOPPED
                    </c:if>

				<c:if test="${status=='process running'}">
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> IS RUNNING
                        <br />
					<br />
					<input type="button" value="Reload Page"
						onClick="window.location.reload()">
					<br />
					<br />
                        [<a
						onclick='return confirmSubmit("Are you sure you want to stop this process? Please note that it may take a few minutes to stop.")'
						href="servlet/controller/RunnableProgramsStopProcess?id=${model.runnableProgramsExistingId}">stop
						process</a>]
                    </c:if>

				<c:if test="${status!='starting process'}">

					<h2>View Results</h2>

					<c:if test="${model.runnableProgramsType=='MrBUMP'}">
						<div id="MrBUMPOutputDir" /></div>

						<div id="MrBUMPResultsDir" /></div>
					</c:if>

					<c:if test="${model.runnableProgramsType=='Zanuda'}">
						<div id="ZanudaOutputDir" /></div>
					</c:if>

					<c:if test="${model.runnableProgramsType=='CRANK2'}">
						<div id="CRANK2ResultsDir" /></div>
					</c:if>

					<c:if test="${model.runnableProgramsType=='Balbes'}">

						<c:if test="${model.balbesSpacegroupRun}">
							<%
								pageContext.setAttribute("spacegroups", model.getSpacegroups2(), pageContext.SESSION_SCOPE);
							%>
							<a
								href='servlet/controller/RunnableProgramsDropDownList?sg=&dir=&filename=SGjobsummary.txt'><strong>SGjobsummary.txt</strong></a>
							<c:forEach var="sg" items="${spacegroups}"> 
                                    &nbsp;&nbsp;&nbsp;<span
									id="spacegroups"><a
									href='ChangeSpacegroup.jsp?spacegroup=${sg}'>${sg}</a></span>
							</c:forEach>
							<c:if test="${model.currentSpacegroup != ''}">
								<c:if test="${model.isArpWarpRun()}">
									<c:if test="${model.arpWarpJobFinishFile()==''}">
										<br />
										<strong> NOTE: This is an ARP/wARP run - if a Balbes
											solution is found, a link will appear here a few minutes
											after Balbes finishes, so that you can track your ARP/wARP
											results. ARP/wARP will be run for the best solution found by
											Balbes. </strong>
										<br />
									</c:if>
									<c:if test="${model.arpWarpJobFinishFile()=='false'}">
										<br />
										<strong>Balbes did not find a solution, therefore
											there are no ARP/wARP results.</strong>
										<br />
									</c:if>
									<c:if test="${model.arpWarpJobFinishFile()=='true'}">
										<c:forEach var="sg" items="${spacegroups}">
											<c:if test="${model.getArpWarpLink(sg) != ''}">
												<c:set var="sgarp" value="${sg}" />
											</c:if>
										</c:forEach>
										<br />
										<br />
										<c:if test="${model.currentSpacegroup==sgarp}">
											<strong><a
												href='${model.getArpWarpLink(model.currentSpacegroup)}'
												target='_blank'>An ARP/wARP solution exists - click here
													to access your ARP/wARP results from the website in
													Hamburg.</a></strong>
										</c:if>
										<c:if test="${model.currentSpacegroup!=sgarp}">
											<strong>An ARP/wARP solution exists only for the
												space group ${sgarp}.</strong>
										</c:if>
										<br />
									</c:if>
								</c:if>
								<c:if test="${not empty spacegroups}">
									<br />
									<strong>FILES (space group =
										${model.currentSpacegroup})</strong>
									<br />
									<br />
									<div id="BalbesSGRunResults"></div>
								</c:if>
							</c:if>
						</c:if>

						<c:if test="${!model.balbesSpacegroupRun}">
							<c:if test="${model.isArpWarpRun()}">
								<c:if test="${model.arpWarpJobFinishFile()==''}">
									<br />
									<strong>NOTE: This is an ARP/wARP run - if a Balbes
										solution is found, a link will appear here a few minutes after
										Balbes finishes, so that you can track your ARP/wARP results.</strong>
									<br />
								</c:if>
								<c:if test="${model.arpWarpJobFinishFile()=='false'}">
									<br />
									<strong>Balbes did not find a solution, therefore
										there are no ARP/wARP results.</strong>
									<br />
								</c:if>
								<c:if test="${model.arpWarpJobFinishFile()=='true'}">
									<br />
									<strong><a href='${model.getArpWarpLink()}'
										target='_blank'>An ARP/wARP solution exists - click here
											to access your ARP/wARP results from the website in Hamburg</a></strong>
									<br />
								</c:if>
							</c:if>
							<br />
							<strong>FILES</strong>
							<br />
							<br />
							<div id="BalbesRunResults"></div>
						</c:if>
					</c:if>

					<br />
					<br />

					<div id="downloadlink"></div>

					<br />

					<div id="viewPDFLink"></div>
					<pre id="fileContents"></pre>

				</c:if>

				<!--<jsp:include page="WEB-INF/jspf/viewpdb.jspf"/>-->
			</div>
			<c:if test="${status=='process ended'}">
				<p id="biomexImage">
					<a href="http://www.biomexsolutions.com" target="_blank"><img
						src="${pageContext.request.contextPath}/images/biomex1.png" alt="" /></a>
				</p>
			</c:if>
		</div>

		<a name="bottom"></a>
</body>

</html>
