<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true" %>
<%@ page errorPage="ErrorPage.jsp" %>
<%@ page import="model.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session"/>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/2002/REC-xhtml1-20020801/DTD/xhtml1-transitional.dtd">

<%  if (model.getUsername().equals("")) throw new ServletException("No model found in runnableProgramsRunZanuda.jsp "); %>    
    
<%
    String programType = model.getRunnableProgramsType();
    String navBar = "<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsTable.jsp'>" + programType + "</a>&nbsp;>&nbsp;New " + programType + " Run";
%>

<c:set target="${model}" property="userDir" value="${runnableProgramsInputBaseDir}/${programType}/${model.username}" />
<c:set var="id" value="${model.uniqueId}" />
<c:set target="${model}" property="runnableProgramsExistingId" value="${id}" />
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="EN" lang="EN">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <title>CCP4 online</title>
        <jsp:include page="initialisation.jsp" flush="false"/>
    </head>
    
    <body>

        <div id="container">
            
            <%@ include file="./header.jsp"%>
            
            <div id="header">
                <div id="breadcrumb">
                    <ul>
                        <div id='leftNav'><%=navBar%></div>
                        <div id='rightNav'>Username: <strong><%=model.getUsername()%></strong></div>
                    </ul>
                    <div class="clear">&nbsp;</div>
                </div>
            </div>
            
            <div id="content-container">
                
                <div id="container2">
                   
                    <h2>New <%=programType%> Run</h2>
                    
                    <br /><br />
                    
                    The file formats accepted for input are 
                    <a href='http://www.ccp4.ac.uk/html/mtzformat.html' target="blank">mtz</a>
                    (structure factors) and <a href="http://www.rcsb.org/pdb/static.do?p=file_formats/pdb/index.html" target="blank">pdb</a> (coordinates).
                    
                    <br/><br/>
                    
                    <!-- FILE ERRORS -->
                    <%
                    Vector errorVector = model.getProgramRunErrors();
                    
                    for (int i = 0; i < errorVector.size(); i++) {
                        String error = (String)errorVector.elementAt(i);
                    %>
                        <span class='error'>&nbsp;<%=error%>&nbsp;</span><br/>
                    <%
                    }
                    %>
                    
                    <!-- FORM -->
                    <div id="form">
                    
                        <form method="post" enctype="multipart/form-data" action="servlet/controller/RunnableProgramsRun">
                        
                        <input type="hidden" name="id" value="${id}" />
                            
                            <table>
                            <tr>
                                <th>&nbsp;Job title (optional):&nbsp;</th>
                                <td>&nbsp;<input name="jobtitle" maxlength="30" />&nbsp;</td>
                            </tr>
                                <tr>
                                    <th>&nbsp;Structure Factors:&nbsp;</th>
                                    <td>&nbsp;<input type="file" name="structureFactorsFile" size="75" />&nbsp;</td>
                                </tr>
                                
                                <tr>
                                    <th>&nbsp;Coordinates:&nbsp;</th>
                                    <td>&nbsp;<input type="file" name="coordinatesFile" size="75" />&nbsp;</td>
                                </tr>
                                 
                            </table>
                            
                            <input type="submit" class="submit" value="Submit" />
                            (after clicking submit, <strong>PLEASE WAIT</strong> for your files to upload - this may take some time)
                        
                        </form>
                    
                    </div>
                
                    <br/><br/><br/><br/><br/><br/>
                    
                <div class="clear">&nbsp;</div>
                
            </div>
            
        </div>

        <jsp:include page="WEB-INF/jspf/footer.jspf"/>
        
        </body>

</html>
