<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true" %>
<%@ page errorPage="ErrorPage.jsp" %>
<%@ page import="model.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session"/>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/2002/REC-xhtml1-20020801/DTD/xhtml1-transitional.dtd">

<%  if (model.getUsername().equals("")) throw new ServletException("No model found in runnableProgramsRunBalbes.jsp "); %>    
    
<%
    String programType = model.getRunnableProgramsType();
    String navBar = "<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsTable.jsp'>" + programType + "</a>&nbsp;>&nbsp;New " + programType + " Run";
%>

<c:set target="${model}" property="userDir" value="${runnableProgramsInputBaseDir}/${programType}/${model.username}" />
<c:if test="${not empty param.id}">
	<c:set var="id" value="${param.id}" />
</c:if>
<c:if test="${empty param.id}">
	<c:set var="id" value="${model.uniqueId}" />
</c:if>
<c:set target="${model}" property="runnableProgramsExistingId" value="${id}" />

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="EN" lang="EN">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <title>CCP4 online</title>
        <jsp:include page="initialisation.jsp" flush="false"/>
    </head>
    
    <body>

        <div id="container">
            
            <%@ include file="./header.jsp"%>
            
            <div id="header">
                <div id="breadcrumb">
                    <ul>
                        <div id='leftNav'><%=navBar%></div>
                        <div id='rightNav'>Username: <strong><%=model.getUsername()%></strong></div>
                    </ul>
                    <div class="clear">&nbsp;</div>
                </div>
            </div>
            
            <div id="content-container">
                
                <div id="container2">
                   
                    <h2>New <%=programType%> Run</h2>
                    
                    <br /><br />
                    
                    The file formats accepted for input are 
                    <a href='http://www.weizmann.ac.il/Chemical_Research_Support//xraylab/manuals/CCP4v4.2.2/html/mtzlib.html#fileformat' target="blank">mtz</a> and
                    <a href='http://www.ebi.ac.uk/msd/documentation/mmcif.html' target="blank">cif</a>
                    (structure factors) and <a href="javascript:showHelp4()">FASTA</a> (sequence target).
                    
                    <strong>Note</strong>: checking the ARP/wARP checkbox will send Balbes's results to the <strong>ARP/wARP</strong> server
                    (<a href="http://webapps.embl-hamburg.de/ARPwARP/licence.htm" target="blank">it is assumed that you agree to the ARP/wARP academic license conditions</a>)
                    
                    <br/><br/>
                    
                    <!-- FILE ERRORS -->
                    <%
                    Vector errorVector = model.getProgramRunErrors();
                    
                    for (int i = 0; i < errorVector.size(); i++) {
                        String error = (String)errorVector.elementAt(i);
                    %>
                        <span class='error'>&nbsp;<%=error%>&nbsp;</span><br/>
                    <%
                    }
                    %>
                    
                    <!-- FORM -->
                    <div id="form">
                    
                        <form method="post" enctype="multipart/form-data" action="servlet/controller/RunnableProgramsRun">
                        
                        <input type="hidden" name="id" value="${id}" />
                            
                            <table>
                                <tr>
                                    <th>&nbsp;Job title (optional):&nbsp;</th>
                                    <td>&nbsp;<input name="jobtitle" maxlength="30" />&nbsp;</td>
                                </tr>

                                <tr>
                                    <th>&nbsp;Structure Factors:&nbsp;</th>
                                    <td>&nbsp;<input type="file" name="structureFactorsFile" size="75" />&nbsp;</td>
                                </tr>
                                
                                <tr>
                                    <th>&nbsp;Sequence Target:&nbsp;</th>
                                    <td>&nbsp;<input type="file" name="sequenceTargetFile" size="75" />&nbsp;</td>
                                </tr>
                                
                                <tr>
                                    <th>&nbsp;</th>
                                    <td>
                                        <strong>&nbsp;Instead of entering a Sequence Target file you can paste your <a href="javascript:showHelp4()">FASTA</a> sequence below:</strong>
                                        <br />
                                        <strong>&nbsp;(Note that a comment line beginning with a '>' character must precede the sequence)</strong>
                                    </td>
                                </tr>
                                
                                <tr>
                                    <th>&nbsp;</th>
                                    <td><textarea class="textarea2" name="sequenceTargetTextarea" rows="10" cols="60"></textarea></td>
                                </tr>
                                
                                <tr>
                                    <th>&nbsp;Check Full Spacegroup:&nbsp;</th>
                                    <td><input type="checkbox" name="checkFullSpacegroup" />&nbsp;</td>
                                </tr>
                                
                                <tr>
                                    <th>&nbsp;Run ARP/wARP <br />(on the Balbes solution):&nbsp;</th>
                                    <td>
                                        <input type="checkbox" name="arpWarp" />
                                        &nbsp;&nbsp;&nbsp;
                                        <a href="javascript:showHelpDisseminationLevel()">Dissemination Level</a>:
                                        <select name="disseminationLevel">
                                            <option>World</option>
                                            <option>Confidential</option>
                                            <option>ARP/wARP/REFMAC/AutoRickshaw developers</option>
                                        </select>
                                    </td>
                                </tr>
                                 
                            </table>
                            
                            <input type="submit" class="submit" value="Submit" />
                            (after clicking submit, <strong>PLEASE WAIT</strong> for your files to upload - this may take some time)
                        
                        </form>
                    
                    </div>
                
                    <br/><br/><br/><br/><br/><br/>
                    
                <div class="clear">&nbsp;</div>
                
            </div>
            
        </div>

        <jsp:include page="WEB-INF/jspf/footer.jspf"/>
        
        </body>

</html>
