<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page errorPage="ErrorPage.jsp"%>
<%@ page import="model.*"%>
<%@ page import="java.util.*"%>
<%@ page import="java.io.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib uri="mytags" prefix="my"%>

<jsp:useBean id="model" class="model.Model" scope="session" />
<jsp:useBean id="properties" class="model.GetPropertyValues"
	scope="request" />

<!DOCTYPE html>

<%
	if (model.getUsername().equals(""))
		throw new ServletException("No such a username found in session");
%>

<%
	String navBar = "<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;Programs";
%>

<html lang="EN">
<head>
<title>CCP4 online</title>
<meta charset="UTF-8"></meta>
<!-- href="http://yui.yahooapis.com/pure/0.6.0/pure-min.css"> -->
<c:set var="url">${pageContext.request.requestURL}</c:set>
<%@include file="initialisation.jsp"%>
</head>

<body>

	<div id="container">

		<%@ include file="./header.jsp"%>

<!--
	<div class="pure-menu pure-menu-horizontal" style="background-color: #ffecbf;">
    <ul class="pure-menu-list">
        <li class="pure-menu-item"><a href="./logout" class="pure-menu-link">Home (logout)</a></li>
    </ul>
	</div>
  -->

		<div id="header">
			<div id="breadcrumb">
				<ul>
					<div id='leftNav'><%=navBar%></div>
					<div id='rightNav'>
						Username: <strong><%=model.getUsername()%></strong>
					</div>
				</ul>
				<div class="clear">&nbsp;</div>
			</div>
		</div>

		<div id="content-container">

			<div id="container2">

				<h2>Programs</h2>

				<br /> Note: <i>You must have a CCP4 licence to run these
					programs</i>. <br /> <br />

				<table id="programListTable">
					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=Balbes'>Balbes</a>&nbsp;
						</th>
						<td>&nbsp;An automated Molecular Replacement (MR) pipeline -
							Balbes integrates into one system all the components necessary
							for solving a crystal structure by Molecular Replacement&nbsp;</td>
					</tr>
					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=MrBUMP'>MrBUMP</a>&nbsp;
						</th>
						<td>&nbsp;An automated Molecular Replacement (MR) pipeline -
							Given a target sequence and experimental structure factors, it
							will search for homologous structures, create a set of suitable
							search models from the template structures, do molecular
							replacement, and test the solutions with some rounds of
							restrained refinement. &nbsp;</td>
					</tr>
					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=Zanuda'>Zanuda</a>&nbsp;
						</th>
						<td>&nbsp;Space group and crystallographic origin
							validation&nbsp;</td>
					</tr>
					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=AMPLE'>AMPLE</a>&nbsp;
						</th>
						<td>&nbsp;Automated ab initio search model generation for
							molecular replacement. &nbsp;</td>
					</tr>
					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=SHELX'>SHELX</a>&nbsp;
						</th>
						<td>&nbsp;Automated SHELXC/D/E structure solution pipeline for fast 
					routine experimental phasing. Accepts data in XDS, Scalepack, SHELX hkl or 
					mtz formats and outputs phases and a poly-Ala trace. If a protein sequence 
					is provided, BUCCANEER and REFMAC complete the structure. <font color="red">BETA</font>&nbsp;</td>
					</tr>
					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=CRANK2'>CRANK2</a>&nbsp;
						</th>
						<td>&nbsp;Automated structure solution pipeline for experimental phasing
						 using maximum likelihood methods. 
					<font color="red">BETA</font>&nbsp;</td>
					</tr>

					<tr>
						<th>&nbsp;<a
							href='servlet/controller/RunnableProgramsList?runnableProgramsType=MoRDa'>MoRDa</a>&nbsp;
						</th>
						<td>&nbsp;MoRDa is a pipeline for molecular replacement protein structure solution based on its
					own domain database. Models relevant to the target sequence are further adjusted before
					molecular replacement search.&nbsp;</td>
					</tr>

				</table>

				<%
					if (model.validAdminUser() == true) {
				%>
				<br /> <strong>Admin:</strong>&nbsp; <a
					href="./servlet/controller/Link?page=adminDiskUsage.jsp">Disk
					Usage</a> | <a href="./servlet/controller/Link?page=adminUsers.jsp">Users</a>
				| <a href="./servlet/controller/Link?page=adminMonthlyStats.jsp">Monthly
					Stats</a> | <a
					href="./servlet/controller/Link?page=adminCurrentRuns.jsp">Current
					Runs</a>
				<%
					}
				%>

			</div>

			<div class="clear">&nbsp;</div>

		</div>

	</div>

	<jsp:include page="WEB-INF/jspf/footer.jspf" />

</body>

</html>
