<%@page import="java.util.ArrayList"%>
<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true"%>
<%@ page errorPage="ErrorPage.jsp"%>
<%@ page import="model.*"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>

<jsp:useBean id="model" class="model.Model" scope="session" />

<!DOCTYPE HTML>

<%
	if (model.getUsername().equals("")) {
		throw new ServletException("No model found in runnableProgramsViewResults.jsp");
	}
%>

<%
	String navBar = "<a href='./logout'>Home (Logout)</a>";
	navBar += "&nbsp;>&nbsp;";
	navBar += "<a href='servlet/controller/Link?page=login.jsp'>Login</a>";
	navBar += "&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>";
	navBar += "&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsTable.jsp'>"
			+ model.getRunnableProgramsType() + "</a>";
	navBar += "&nbsp;>&nbsp;View Results";
	String runnableProgramsType = model.getRunnableProgramsType();
%>

<c:set var="status" value="${model.runnableProgramsExistingStatus}" />

<html lang="EN">
<head>
<meta charset="UTF-8">
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="expires" content="0">
<title>CCP4 online</title>
<!--
<link rel="stylesheet"
	href="http://yui.yahooapis.com/pure/0.6.0/pure-min.css">
-->
<%@include file="initialisation.jsp"%>
<script src="./resources/jquery.js" type="text/javascript"></script>
<script src="./resources/underscore-min.js" type="text/javascript"></script>
</head>

<body style="max-width: 1250px;">

	<div id="container">

		<%@ include file="./header.jsp"%>

		<div id="header">
			<div id="breadcrumb">
				<ul>
					<div id='leftNav'><%=navBar%></div>
					<div id='rightNav'>
						Username: <strong>${model.username}</strong>
					</div>
				</ul>
				<div class="clear">&nbsp;</div>
			</div>
		</div>

		<div id="content-container">

			<div id="container2">

				<c:if test="${programType=='MoRDa'}">
				<img src="./images/morda.png" height="80" alt="" style="float: left; padding-right: 5em; "></img>
				</c:if>

				<c:if test="${programType=='Zanuda'}">
				<img src="./images/zanudamistic.jpg" height="80" alt="" style="float: left; padding-right: 1em; "></img>
				</c:if>
			
				<h2>${model.runnableProgramsType}</h2>

				<c:if test="${programType=='MoRDa'}">
				<p>
				Please cite the following paper, if you used a solution from MoRDa:<br/>
				A. Vagin, A. Lebedev, <em>Acta Cryst.</em> (2015). A71, s19
				</p>
				
				<p>MoRDa <a href="http://www.biomexsolutions.co.uk/morda">homepage</a> contains more details and instructions for local installation.</p>
				</c:if>

				<c:if test="${programType=='Zanuda'}">
				<p>
				Please cite the following paper if you found Zanuda results useful:<br/>
				Lebedev, A. A. &amp; Isupov M. N. (2014). <em>Acta Cryst.</em> D<b>70</b>, 2430-2443.
				</p>
				</c:if>

				<c:if
					test="${model.runnableProgramsType=='SHELX' or model.runnableProgramsType=='CRANK2'}">
					<p>
						<button id="toggle" class="pure-button">Show the input
							parameters.</button>
					</p>
					<div id="inputParams"></div>
				</c:if>

				<c:if test="${status=='starting process'}">
						<p>
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> IS STARTING
                        </p>
                        <p>
                        Your results should appear below within a few minutes:
                        </p>
                        <p>
					<input type="button" value="Reload Page"
						onClick="window.location.reload()" class="pure-button">
						</p>
				</c:if>

				<c:if test="${status=='process ended'}">
					<p>
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> HAS ENDED
                        </p>
                    </c:if>

				<c:if
					test="${status=='process failed' and (model.runnableProgramsType=='SHELX' or model.runnableProgramsType=='CRANK2')}">
					<p>
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> HAS FAILED
                        </p>
                        
                        <c:if
						test="${model.runnableProgramsType=='SHELX'}">
						<p>
							If you have any questions on running SHELX, please send email to
							<a href="mailto:gsheldr@shelx.uni-ac.gwdg.de">George M.
								Sheldrick</a>
						</p>
					</c:if>

					<c:catch var="summaryException">
						<p>Here is the output from the job:</p>
						<c:import url="${model.publicOutputURL}/../output/summary.log"
							var="data" />
					</c:catch>
					<c:if test="${not empty summaryException}">
							No output!
						</c:if>
					<pre>
						<c:out value="${data}" />
						</pre>
				</c:if>

				<c:if test="${status=='stopping process'}">
				<p>
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> IS STOPPING
                        </p>
                        <p>
					<input type="button" value="Reload Page" onClick="update()">
					</p>
				</c:if>

				<c:if test="${status=='process stopped'}">
				<p>
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> HAS STOPPED
                        </p>
                    </c:if>

				<c:if test="${status=='process running'}">
				<p>
                        PROCESS <strong>${model.runnableProgramsExistingId}</strong> IS RUNNING
                        </p>
                        <p>
                        [<a
						onclick='return confirmSubmit("Are you sure you want to stop this process? Please note that it may take a few minutes to stop.")'
						href="servlet/controller/RunnableProgramsStopProcess?id=${model.runnableProgramsExistingId}">stop
						process</a>]
						</p>
                </c:if>

				<c:if test="${status!='starting process'}">
					<c:choose>
						<c:when test="${model.runnableProgramsType=='AMPLE'}">
							<c:catch var="jsrError">
								<c:import
									url="${model.publicOutputURL}/AMPLE_0/jsrview/jsrview.html"
									varReader="ignore" />
							</c:catch>
							<c:if test="${empty jsrError}">
								<iframe
									src="${model.publicOutputURL}/AMPLE_0/jsrview/jsrview.html"
									width="100%" height="1000"></iframe>
							</c:if>
						</c:when>
						<c:otherwise>
							<c:catch var="jsrError"> <c:import url="${model.publicOutputURL}/jsrview.html" varReader="ignore" /> </c:catch>
							<c:if test="${empty jsrError}">
								<iframe src="${model.publicOutputURL}/jsrview.html" width="100%" height="1200"></iframe>
							</c:if>
						</c:otherwise>
					</c:choose>
					<c:if test="${not empty jsrError}">
						<c:if
							test="${status!='process ended' and status!='process failed' and status!='stopping process'}">
							<p>
								<input type="button" value="Reload Page"
									onClick="window.location.reload()">
							</p>
						</c:if>
						<c:catch var="jsrError">
							<c:if test="${model.runnableProgramsType!='SHELX'}">
								<c:catch var="summaryException">
									<c:import url="${model.publicOutputURL}/../output/summary.log"
										var="data" />
								</c:catch>
							</c:if>
							<c:if test="${model.runnableProgramsType=='SHELX'}">
								<c:catch var="crankError">
									<c:import url="${model.publicOutputURL}/crank_verb.log"
										varReader="ignore" />
								</c:catch>
								<c:if test="${empty crankError}">
									<c:import url="${model.publicOutputURL}/crank_verb.log"
										var="data" />
								</c:if>
								<c:if test="${not empty crankError}">
									<c:catch var="summaryException">
										<c:import url="${model.publicOutputURL}/../output/summary.log"
											var="data" />
									</c:catch>
									<c:if test="${not empty summaryException}">
										<p>No summary.log file! This could be a temporary network
											failure between the cluster and the server. You could try
											logging out and in once. If that doesn't help, please
											ccp4@stfc.ac.uk of this problem.</p>
									    <p>Path to the log file: ${model.publicOutputURL}/../output/summary.log</p>
									</c:if>
								</c:if>
							</c:if>
							<pre>
							<c:out value="${data}" />
							</pre>
						</c:catch>
					</c:if>
				</c:if>
			</div>
		</div>
	</div>

	<c:if
		test="${model.runnableProgramsType=='SHELX' or model.runnableProgramsType=='CRANK2'}">
		<script>
			$(document)
					.ready(
							function() {
								var $inputDiv = $("#inputParams");
								var $toggle = $("#toggle");
								var flip = 1;
								$toggle
										.click(function(event) {
											event.preventDefault();
											if (flip % 2) {
												$inputDiv
														.html('<p><table class="pure-table pure-table-striped"><tbody id="input-table"></tbody></table></p>');
												$inputTable = $('#input-table');
												$
														.getJSON(
																"./rest/${model.runnableProgramsType}/${model.username}/${model.runnableProgramsExistingId}/input",
																function(data) {
																	if (data.jobTitle) {
																		$inputTable
																				.append('<tr><th>Job title</th><td>'
																						+ data.jobTitle
																						+ '</td></tr>');
																	}
																	$inputTable
																			.append('<tr><th>Experiment type</th><td>'
																					+ data.experimentType
																					+ '</td></tr>');
																	if (data.experimentType == 'SAD'
																			|| data.experimentType == 'SIRAS') {
																		var entry = data.datasets[0];
																		if (data.fp.length > 0) {
																			entry += " f'="
																					+ data.fp[0];
																		}
																		if (data.fpp.length > 0) {
																			entry += " f''="
																					+ data.fpp[0];
																		}
																		$inputTable
																				.append('<tr><th>Anomalous dataset</th><td>'
																						+ entry
																						+ '</td></tr>');
																	}
																	if (data.experimentType == 'MAD') {
																		for (var i = 0; i < data.datasets.length; i++) {
																			var entry = data.datasets[i];
																			if (data.dataTypes.length > 0
																					&& data.dataTypes[i]) {
																				entry += " type:"
																						+ data.dataTypes[i];
																			}
																			if (data.fp.length > i
																					&& data.fp[i]) {
																				entry += " f'="
																						+ data.fp[i];
																			}
																			if (data.fpp.length > 0
																					&& data.fpp[i]) {
																				entry += " f''="
																						+ data.fpp[i];
																			}
																			$inputTable
																					.append('<tr><th>Anomalous dataset #'
																							+ i
																							+ '</th><td>'
																							+ entry
																							+ '</td></tr>');
																		}
																	}
																	if (data.nativeDataset) {
																		$inputTable
																				.append('<tr><th>Native dataset</th><td>'
																						+ data.nativeDataset
																						+ '</td></tr>');
																	}
																	// break the sequence target into lines of max 80 chars
																	var n = data.sequenceTarget.length;
																	if (n > 0) {
																		var entry = data.sequenceTarget[0];
																		entry += "<br/>";
																		var lines = "";
																		for (var i = 1; i < n; i++) {
																			lines += data.sequenceTarget[i];
																		}
																		lines = lines
																				.replace(
																						/ /g,
																						'')
																				.match(
																						/.{1,80}/g);
																		for (var i = 0; i < lines.length - 1; i++) {
																			entry += lines[i];
																			entry += "<br/>";
																		}
																		entry += lines[lines.length - 1];
																		$inputTable
																				.append('<tr><th>Sequence target</th><td>'
																						+ entry
																						+ '</td></tr>');
																	}
																	if (_
																			.min(data.cell) > 0.0) {
																		var entry = "";
																		for (var i = 0; i < 6; i++) {
																			if (data.cell[i]) {
																				entry += data.cell[i]
																						+ " ";
																			}
																		}
																		$inputTable
																				.append('<tr><th>Cell parameters</th><td>'
																						+ entry
																						+ '</td></tr>');
																	}
																	if (data.spacegroup) {
																		$inputTable
																				.append('<tr><th>Space group</th><td>'
																						+ data.spacegroup
																						+ '</td></tr>');
																	}
																	$inputTable
																			.append('<tr><th>Substructure atom</th><td>'
																					+ data.atomType
																					+ '</td></tr>');
																	if (data.exp_num_atoms) {
																		$inputTable
																				.append('<tr><th>No. of substruct. atoms in asymmetr. unit</th><td>'
																						+ data.exp_num_atoms
																						+ '</td></tr>');
																	}
																	if (data.num_dsul) {
																		$inputTable
																				.append('<tr><th>No. of disulphides</th><td>'
																						+ data.num_dsul
																						+ '</td></tr>');
																	}
																	if (data.high_res_cutoff) {
																		$inputTable
																				.append('<tr><th>High resolution cutoff (in \Aring)</th><td>'
																						+ data.high_res_cutoff
																						+ '</td></tr>');
																	}
																	if (data.num_trials) {
																		$inputTable
																				.append('<tr><th>No. of substructure detection trials</th><td>'
																						+ data.num_trials
																						+ '</td></tr>');
																	}
																	if (data.solvent_content) {
																		$inputTable
																				.append('<tr><th>Solvent content</th><td>'
																						+ data.solvent_content
																						+ '</td></tr>');
																	}
																})
												.done(function() {
													$toggle.html("Hide the input parameters.");
													flip++;
												});
											} else {
												$inputDiv.html("");
												$toggle
														.html("Show the input parameters.");
												flip++;
											}
										});
							});
		</script>
	</c:if>
</body>

</html>
