<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ page session="true" %>
<%@ page errorPage="ErrorPage.jsp" %>
<%@ page import="model.*" %>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>

<!-- this page uses the old previousRuns.txt file, and doesn't work with the new poller.log file. So it's currently rather useless. -->

<jsp:useBean id="model" class="model.Model" scope="session"/>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/2002/REC-xhtml1-20020801/DTD/xhtml1-transitional.dtd">

<% if (model.getUsername().equals("")) throw new ServletException("No such a username is found in calling adminMonthlyStats.jsp"); %>    
    
<%
    String navBar = "<a href='./logout'>Home (Logout)</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=login.jsp'>Login</a>&nbsp;>&nbsp;<a href='servlet/controller/Link?page=runnableProgramsList.jsp'>Programs</a>&nbsp;>&nbsp;Monthly Stats";
%>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="EN" lang="EN">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
        <title>CCP4 online</title>
        <jsp:include page="initialisation.jsp" flush="false"/>
    </head>
    
    <body>

        <div id="container">
        
        <%@ include file="./header.jsp"%>
        
        <div id="header">
            <div id="breadcrumb">
                <ul>
                    <div id='leftNav'><%=navBar%></div>
                    <div id='rightNav'>Username: <strong><%=model.getUsername()%></strong></div>
                </ul>
                <div class="clear">&nbsp;</div>
            </div>
        </div>
        
        <div id="content-container">
        
        <div id="container2">
        
        <h2>Monthly Stats</h2>
        
        <br />
        
        <%
        model.setRunnableProgramsOutputBaseDir(application.getInitParameter("runnableProgramsOutputBaseDir"));
        
        if (model.validAdminUser() == false) {
            out.println("<h2>YOU DO NOT HAVE PERMISSION TO VIEW THIS PAGE</h2>");
        } else { %>
        
        <strong>Note</strong>: stats do not include 'Current Runs' (i.e. the last 10 days) and the following users runs are not included:
        <em>adminUser</em>
            
        <br /><br />
        
        <div id="adminStatsTable">
            
            <a name="stats"></a> 
            
            <%
            String[] programType = { "Balbes", "MrBUMP", "Zanuda" };
            for (int t = 0; t < programType.length; t++) {
                Stats stats =  model.getStats(programType[t]);
                int[][] statsArray = stats.getProgramTypeArray();
                out.println("<table width='30%' border='1' cellpadding='2' cellspacing='0'>");
                out.println("<tr><td colspan='2'>&nbsp;" + programType[t] + ": (unique users = " + stats.getUniqueUsersCount() + ")</td></tr>");
                for (int i = 0; i < 10; i++) {
                    for (int j = 1; j <= 12; j++) {
                        if (statsArray[i][j] != 0) {
                            out.println("<tr><td width='50%' align='center'>" + model.getMonthString(j) + " " + (2007 + i) + "</td><td align='center'>" + statsArray[i][j] + "</td></tr>");
                        }
                    }
                }
                out.println("<tr><td>Total:</td><td align='center'><strong>" + stats.getProgramTypeCount() + "</strong></td></tr>");
                out.println("</table>");
                out.println("<br />");
            }
            %>
            
        </div>
        
        <% } %>
        
        <br /><br />
        
        </div>
        
        <div class="clear">&nbsp;</div>
        
        </div>
        
        </div>

        <jsp:include page="WEB-INF/jspf/footer.jspf"/>
    
    </body>

</html>
