<%-- 
    Document   : wrapper
    Created on : 15-Sep-2014, 15:07:56
    Author     : ville
--%>

<%@tag description="simple wrapper with the banner, header and footer" pageEncoding="UTF-8"%>

<%-- The list of normal or fragment attributes can be specified here: --%>
<%@attribute name="navBar" required="true"%>
<%@attribute name="style" required="false"%>
<%@attribute name="username" required="false"%>
<%@attribute name="script" required="false" %>

<%-- any content can be specified here e.g.: --%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<c:set var="url">${pageContext.request.requestURL}</c:set>
<c:set var="base" value="${fn:replace(url, pageContext.request.requestURI, pageContext.request.contextPath)}"></c:set>
<html lang="EN">
    <head>
        <meta charset="UTF-8">
        <title>CCP4 online</title>
        <jsp:include page="/WEB-INF/jspf/initialisation.jspf"></jsp:include> 
        <c:if test="${not empty style}">
            ${style}
        </c:if>
    </head>
    <body>
        <div id="container">
            <jsp:include page="/WEB-INF/jspf/header.jspf"></jsp:include>
            <article>
                <header>
                    <nav>
                        <ul>
                            <li class="left">${navBar}</li>
                            <c:if test="${not empty username}">
                                <li class="right">Username: <strong>${username}</strong></li>
                            </c:if>
                        </ul>
                    </nav>
                </header> 
                <section>
                    <jsp:doBody/>
                </section>
                <footer>
                    <jsp:include page="/WEB-INF/jspf/footer.jspf" />
                </footer>
            </article>
        </div>
        <c:if test="${not empty script}">
            ${script}
        </c:if>
    </body>
</html>