package util;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import java.io.File;

import model.GetPropertyValues;
import model.Model;

public class SessionFoldersListener implements HttpSessionListener {

	@Override
	public void sessionCreated(HttpSessionEvent event) {
	}

	@Override
	public void sessionDestroyed(HttpSessionEvent event) {
		String wwwroot = new GetPropertyValues().getProperty("publicroot");
        HttpSession session = event.getSession();
        Model model = (Model) session.getAttribute("model");
        if(model != null) {
        	String username = model.getUsername();
        	// delete the public user directory and the symbolic links therein
        	File dir = new File(wwwroot+'/'+username);
        	if(dir.isDirectory()) {
        		for(String s: dir.list()) {
        			File link = new File(dir.getPath(),s);
        			link.delete();
        		}
        		dir.delete();
        	}
        }
	}
}
