package rest.resources;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.slf4j.LoggerFactory;

import com.google.gson.Gson;

import ch.qos.logback.classic.Logger;
import rest.data.CRANK2JobInput;
import rest.data.GenericJobInput;
import rest.data.Job;
import rest.data.JobInput;

@Path("{program}/{username}")
public class JobResource {
	final static Logger logger = (Logger) LoggerFactory.getLogger(JobResource.class);

	//@GET @Produces({MediaType.APPLICATION_JSON})
	public List<Job> getJobs(@PathParam("program") String programType, @PathParam("username") String username) {
		List<Job> jobs = Job.getJobs(programType, username);
		return jobs;
	}

	@GET @Produces(MediaType.APPLICATION_JSON)
	public String getJobsAsString(@PathParam("program") String programType, @PathParam("username") String username) {
		List<Job> joblist = Job.getJobs(programType, username);
		Job[] jobs = new Job[joblist.size()];
		jobs = joblist.toArray(jobs);
		return new Gson().toJson(jobs);
	}

	//@GET @Path("/{job_id: [0-9]+}") @Produces({MediaType.APPLICATION_JSON})
	public Job getJob(@PathParam("program") String programType, @PathParam("username") String username, @PathParam("job_id") String jobId) {
		Job job = null;
		try {
			job = new Job(programType, username, jobId);
		} catch(NumberFormatException ex) {
			logger.warn("NumberFormatException in JobsResources.getJob");
		}
		return job;
	}

	@GET @Path("/{job_id: [0-9]+}") @Produces(MediaType.APPLICATION_JSON)
	public String getJobAsString(@PathParam("program") String programType, @PathParam("username") String username, @PathParam("job_id") String jobId) {
		String s;
		try {
			Job job = new Job(programType, username, jobId);
			//s = job.toString();
			s = new Gson().toJson(job);
		} catch(NumberFormatException ex) {
			logger.warn("NumberFormatException in JobsResources.getJob");
			s = "";
		}
		return s;
	}

	@GET @Path("/{job_id: [0-9]+}/input") @Produces(MediaType.APPLICATION_JSON)
	public String getJobInput(@PathParam("program") String programType, @PathParam("username") String username, @PathParam("job_id") String jobId) {
		// return the job input parameters as a Json object
		String s = "{}";
		try {
			Job job = new Job(programType, username, jobId);
			if("SHELX".equals(programType) || "CRANK2".equals(programType)) {
				CRANK2JobInput ji = (CRANK2JobInput) job.getInput();
				s = new Gson().toJson(ji);
			} else {
				GenericJobInput ji = (GenericJobInput) job.getInput();
				s = new Gson().toJson(ji);
			}
		} catch(NumberFormatException ex) {
			logger.warn("NumberFormatException in JobsResources.getJob");
		}
		return s;
	}
	
}
