package rest.data;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

import rest.util.GetPropertyValues;

public abstract class JobInput {
	// transient keyword is used so that those properties are not included in the serialisation to JSON
	protected transient String inputFile;
	protected transient String cmdFile;
	protected transient String workdir;
	public String jobTitle;
	public boolean exists;

	public JobInput(Job job) {
		String id = job.getId();
		String programType = job.getProgramType();
		String username = job.getUsername();
		GetPropertyValues gpv = new GetPropertyValues();
		workdir = Paths.get(gpv.getProperty("runnableProgramsOutputBaseDir"), programType, username, id).toString();
		if(Files.exists(Paths.get(workdir))) {
			exists = true;
		} else {
			exists = false;
		}
		inputFile = Paths.get(workdir,"input.txt").toString();
		cmdFile = Paths.get(workdir,"cmd.txt").toString();
		try {
			jobTitle = new String(Files.readAllBytes(Paths.get(workdir,"jobtitle.txt")));
		} catch (IOException e) {
			jobTitle = "";
		}

	}
}