package rest.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import org.slf4j.LoggerFactory;

import ch.qos.logback.classic.Logger;
import model.Utility;
import rest.util.GetPropertyValues;

@XmlRootElement(name = "job") // only needed to generate XML
@XmlAccessorType(XmlAccessType.FIELD)
public class Job implements Comparable<Job> {
	@XmlAttribute
	public String id = "";
	@XmlAttribute
	public String programType;
	@XmlAttribute
	public String username;
	@XmlAttribute
	public String minute;
	@XmlAttribute
	public String hour;
	@XmlAttribute
	public String day;
	@XmlAttribute
	public String month;
	@XmlAttribute
	public String year;
	@XmlAttribute
	public String status;
	@XmlAttribute
	public String title;
	final static Logger logger = (Logger) LoggerFactory.getLogger(Job.class);


	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getProgramType() {
		return programType;
	}

	public void setProgramType(String programType) {
		this.programType = programType;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getMinute() {
		return minute;
	}

	public void setMinute(String minute) {
		this.minute = minute;
	}

	public String getHour() {
		return hour;
	}

	public void setHour(String hour) {
		this.hour = hour;
	}

	public String getDay() {
		return day;
	}

	public void setDay(String day) {
		this.day = day;
	}

	public String getMonth() {
		return month;
	}

	public void setMonth(String month) {
		this.month = month;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Job(String programType, String username, String id) {
		// currently this should be used to check existing jobs only, or to
		// check if the job exists
		this.id = id;
		this.programType = programType;
		this.username = username;
		GetPropertyValues gpv = new GetPropertyValues();
		String workdir = Paths.get(
				gpv.getProperty("runnableProgramsOutputBaseDir"), programType,
				username, id).toString();
		if (new File(workdir).exists()) {
			File f = new File(workdir, "info.txt");
			String hour = "";
			String minute = "";
			String day = "";
			String month = "";
			String year = "";
			try (BufferedReader in = new BufferedReader(new FileReader(f))) {
				// logger.info("Opened to open the info file "+f.toString());
				// normally there's only one line in the info file, but this
				// just reads the date
				// from the last line
				String line = "";
				while ((line = in.readLine()) != null) {
					StringTokenizer st = new StringTokenizer(line, ":");
					String date = st.nextToken();
					st = new StringTokenizer(date, "-");
					hour = st.nextToken();
					minute = st.nextToken();
					day = st.nextToken();
					month = st.nextToken();
					year = st.nextToken();
				}
			} catch (IOException e) {
				// Silently ignore the exception. The date will then be empty,
				// which could happen,
				// if this is a new job and the info file hasn't been written
				// yet.
				// logger.info("Failed to open the info file "+f.toString());
			}
			String status = "";

			File startingProcessFile = new File(workdir, "startingProcess.txt");
			if (startingProcessFile.exists())
				status = "starting process";

			File processQueuedFile = new File(workdir, "processQueued.txt");
			if (processQueuedFile.exists())
				status = "process queued";

			File processRunningFile = new File(workdir, "processRunning.txt");
			if (processRunningFile.exists())
				status = "process running";

			File stoppingProcessFile = new File(workdir, "stoppingProcess.txt");
			if (stoppingProcessFile.exists())
				status = "stopping process";

			File processStoppedFile = new File(workdir, "processStopped.txt");
			if (processStoppedFile.exists())
				status = "process stopped";

			File processEndedFile = new File(workdir, "processEnded.txt");
			if (processEndedFile.exists())
				status = "process ended";

			// try to check if the job has crashed
			File summaryFile = new File(workdir + File.separator + "output",
					"summary.log");
			String lastline = Utility.tail(summaryFile);
			boolean crashed = Pattern.matches(".*error.*", lastline)
					|| Pattern.matches(".*Error.*", lastline);
			if (crashed) {
				status = "process failed";
			}

			File deletingProcessFile = new File(workdir, "deletingProcess.txt");
			if (deletingProcessFile.exists())
				status = "deleting run";

			String jobtitle = "";

			File jobTitleFile = new File(workdir, "jobtitle.txt");
			if (jobTitleFile.exists()) {
				try (BufferedReader br = new BufferedReader(new FileReader(
						jobTitleFile))) {
					jobtitle = br.readLine();
				} catch (Exception ex) {
					// ignore this, as older jobs don't have job titles at all
				}
			}

			if (jobtitle.equals("")) {
				jobtitle = "N/A";
			}

			this.id = id;
			this.title = jobtitle;
			this.day = day;
			this.month = month;
			this.year = year;
			this.hour = hour;
			this.minute = minute;
			this.status = status;
		} else {
			this.status = "does not exist";
		}
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((day == null) ? 0 : day.hashCode());
		result = prime * result + ((hour == null) ? 0 : hour.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((minute == null) ? 0 : minute.hashCode());
		result = prime * result + ((month == null) ? 0 : month.hashCode());
		result = prime * result
				+ ((programType == null) ? 0 : programType.hashCode());
		result = prime * result + ((status == null) ? 0 : status.hashCode());
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		result = prime * result
				+ ((username == null) ? 0 : username.hashCode());
		result = prime * result + ((year == null) ? 0 : year.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Job other = (Job) obj;
		if (day == null) {
			if (other.day != null)
				return false;
		} else if (!day.equals(other.day))
			return false;
		if (hour == null) {
			if (other.hour != null)
				return false;
		} else if (!hour.equals(other.hour))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (minute == null) {
			if (other.minute != null)
				return false;
		} else if (!minute.equals(other.minute))
			return false;
		if (month == null) {
			if (other.month != null)
				return false;
		} else if (!month.equals(other.month))
			return false;
		if (programType == null) {
			if (other.programType != null)
				return false;
		} else if (!programType.equals(other.programType))
			return false;
		if (status == null) {
			if (other.status != null)
				return false;
		} else if (!status.equals(other.status))
			return false;
		if (title == null) {
			if (other.title != null)
				return false;
		} else if (!title.equals(other.title))
			return false;
		if (username == null) {
			if (other.username != null)
				return false;
		} else if (!username.equals(other.username))
			return false;
		if (year == null) {
			if (other.year != null)
				return false;
		} else if (!year.equals(other.year))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "{\"id\":\"" + id + "\", \"programType\":\"" + programType
				+ "\", \"username\":\"" + username + "\", \"minute\":\""
				+ minute + "\", \"hour\":\"" + hour + "\", \"day\":\"" + day
				+ "\", \"month\":\"" + month + "\", \"year\":\"" + year
				+ "\", \"status\":\"" + status + "\", \"title\":\"" + title
				+ "\"}";
	}

	public static List<Job> getJobs(String programType, String username) {
		List<Job> joblist = new ArrayList<>();
		GetPropertyValues gpv = new GetPropertyValues();
		String userdir = Paths.get(
				gpv.getProperty("runnableProgramsOutputBaseDir"), programType,
				username).toString();
		File d = new File(userdir);
		if (d.exists()) {
			FilenameFilter filter = new JobnameFilter("startingProcess.txt");
			for (String jobid : d.list(filter)) {
				joblist.add(new Job(programType, username, jobid));
			}
		}
		Collections.sort(joblist);
		return joblist;
	}

	@Override
	public int compareTo(Job that) {
		int year1 = Integer.parseInt(this.getYear());
		int year2 = Integer.parseInt(that.getYear());
		int month1 = convertMonth(this.getMonth());
		int month2 = convertMonth(that.getMonth());
		int day1 = Integer.parseInt(this.getDay());
		int day2 = Integer.parseInt(that.getDay());
		int hour1 = Integer.parseInt(this.getHour());
		int hour2 = Integer.parseInt(that.getHour());
		int minute1 = Integer.parseInt(this.getMinute());
		int minute2 = Integer.parseInt(that.getMinute());

		int greater = -1; // 'that' is greater

		if (year1 > year2) {
			greater = 1;
		} else if (year1 == year2) {
			if (month1 > month2) {
				greater = 1;
			} else if (month1 == month2) {
				if (day1 > day2) {
					greater = 1;
				} else if (day1 == day2) {
					if (hour1 > hour2) {
						greater = 1;
					} else if (hour1 == hour2) {
						if (minute1 > minute2) {
							greater = 1;
						} else if (minute1 == minute2) {
							greater = 1;
						}
					}
				}
			}
		}

		return -greater; // this makes the most recent ones to come first after sorting
	}

	private int convertMonth(String month) {

		if ("Jan".equals(month)) {
			return 1;
		} else if ("Feb".equals(month)) {
			return 2;
		} else if ("Mar".equals(month)) {
			return 3;
		} else if ("Apr".equals(month)) {
			return 4;
		} else if ("May".equals(month)) {
			return 5;
		} else if ("Jun".equals(month)) {
			return 6;
		} else if ("Jul".equals(month)) {
			return 7;
		} else if ("Aug".equals(month)) {
			return 8;
		} else if ("Sep".equals(month)) {
			return 9;
		} else if ("Oct".equals(month)) {
			return 10;
		} else if ("Nov".equals(month)) {
			return 11;
		} else if ("Dec".equals(month)) {
			return 12;
		} else {
			return 0;
		}
	}
	
	public JobInput getInput() {
		if("CRANK2".equals(programType) || "SHELX".equals(programType)) {
			return new CRANK2JobInput(this);
		}
		return new GenericJobInput(this);
	}

}
