package rest.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CRANK2JobInput extends JobInput {
	public String experimentType = "";
	public List<Double> fp = new LinkedList<>();
	public List<Double> fpp = new LinkedList<>();
	public List<String> dataTypes = new LinkedList<>();
	public List<String> datasets = new LinkedList<>();
	public String nativeDataset = "";
	public Double[] cell = new Double[] {-1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
	public String spacegroup = "";
	public String[] sequenceTarget = new String[0];
	public Integer residues_mon = new Integer(0);
	public String atomType = "";
	public Integer exp_num_atoms = new Integer(0);
	public Integer num_dsul = new Integer(0);
	public Integer num_trials = new Integer(0);
	public Double high_res_cutoff = new Double(0.0);
	public Double solvent_content = new Double(0.0);
	final static Logger logger = (Logger) LoggerFactory.getLogger(CRANK2JobInput.class);

	public CRANK2JobInput(Job job) {
		super(job);
		// read the input parameter file
		Pattern attrPattern = Pattern.compile("(?<attr>\\w+)=(?<value>\\S+)");
		Pattern paramPattern = Pattern.compile("(?<param>\\w+)::(?<value>\\S+)");
		Pattern wordPattern = Pattern.compile("[^=:]+");
		try (BufferedReader br = new BufferedReader(new FileReader(inputFile))) {
			// read the input file line by line
			for (String line; (line = br.readLine()) != null;) {
				// read all space-separated tokens on the line
				Scanner iscanner = new Scanner(line);
				// key is the first token on each line. It denotes a data
				// object, a process or other keyword in crank2 input.
				String key = "";
				if (iscanner.hasNext()) {
					key = iscanner.next();
				} else {
					continue; // if the line is empty
				}
				if (key.startsWith("target::")) {
					experimentType = key.substring(8);
					continue;
				}
				String dataType = "";
				String word = "";
				while (iscanner.hasNext()) {
					String token = iscanner.next();
					String attr = "";
					String param = "";
					String value = "";
					Matcher attrMatcher = attrPattern.matcher(token);
					Matcher paramMatcher = paramPattern.matcher(token);
					Matcher wordMatcher = wordPattern.matcher(token);
					if (attrMatcher.matches()) {
						attr = attrMatcher.group("attr");
						value = attrMatcher.group("value");
					} else if (paramMatcher.matches()) {
						param = paramMatcher.group("param");
						value = paramMatcher.group("value");
					} else if (wordMatcher.matches()) {
						word = token;
					}
					switch (key) {
					case "substrdet":
						if ("num_dsul".equals(param)) {
							num_dsul = Integer.valueOf(value);
						} else if ("high_res_cutoff".equals(param)) {
							high_res_cutoff = Double.valueOf(value);
						} else if ("num_trials".equals(param)) {
							num_trials = Integer.valueOf(value);
						}
						break;
					case "fsigf":
						if ("cell".equals(attr)) { // cell parameters
							int i = 0;
							for (String p : value.split(",")) {
								cell[i] = Double.valueOf(p);
								i++;
							}
							if (i < 6) {
								logger.error("Cell parameters not complete in this job: " + job.toString());
							}
						} else if ("spgr".equals(attr)) {
							spacegroup = value;
						} else if ("dname".equals(attr)) {
							dataType = value;
						} else if ("file".equals(attr)) {
							String fname = value.substring(6); // drop "input/"
							if ("native".equals(dataType)) {
								nativeDataset = fname;
							} else {
								datasets.add(fname);
								dataTypes.add(dataType);
							}
						}
						break;
					case "model":
						if ("substr".equals(word)) {
							if ("exp_num_atoms".equals(attr)) {
								exp_num_atoms = Integer.valueOf(value);
							} else if ("atomtype".equals(attr)) {
								atomType = value;
							} else if ("fp".equals(attr)) {
								fp.add(Double.valueOf(value));
							} else if ("fpp".equals(attr)) {
								fpp.add(Double.valueOf(value));
							} else if ("residues_mon".equals(attr)) {
								residues_mon = Integer.valueOf(value);
							}
						}
						break;
					case "sequence":
						if ("file".equals(attr)) {
							String seqFile = value;
							List<String> lines = Files.readAllLines(Paths.get(workdir, seqFile));
							sequenceTarget = lines.toArray(sequenceTarget);
						}
						break;
					}
				}
				iscanner.close();
			}
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
		// read the solvent content if available
		File xmlfile = new File(workdir + "/" + "crank2/faest.xml");
		/* parsing the xml file seems to fail
		try {
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance(); 
			DocumentBuilder dBuilder;
			dBuilder = dbFactory.newDocumentBuilder();
			Document doc = dBuilder.parse(xmlfile);
			doc.getDocumentElement().normalize();
			NodeList nList = doc.getElementsByTagName("solvent_content");
			if(nList.getLength() > 0) {
				solvent_content = Double.valueOf(nList.item(0).getNodeValue());
			}
		} catch (Exception e) {
			//e.printStackTrace();
		} 
		*/
		// just read the file normally
		try(BufferedReader br = new BufferedReader(new FileReader(xmlfile))) {
			String line;
			while((line = br.readLine()) != null) {
				Pattern pattern = Pattern.compile("<solvent_content>([0-9.]+)</solvent_content>$");
				Matcher matcher = pattern.matcher(line.trim());
				if(matcher.find()) {
					System.out.println(matcher.group(1));
					solvent_content = Double.valueOf(matcher.group(1));
					break;
				}
			}
		} catch (NumberFormatException e) {
		} catch (FileNotFoundException e) {
		} catch (IOException e) {
		}
	}
}
