package rest;

import filter.LoginFilter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import model.Model;

/**
 * Servlet Filter implementation class RestLoginFilter
 */
@WebFilter(description = "Login filter for the 'restful' API", urlPatterns = { "/rest/*" })
public class RestLoginFilter extends LoginFilter implements Filter {

	private class RestRequest {
		// possible strings that match:
		// /program/user
		// /program/user/
		// /program/user/9143
		// /program/user/9143/input
		private Pattern regExAllPattern = Pattern
				.compile("^/rest/(?<program>[^\\s/]+)/(?<user>[^\\s/]+)(/\\d+|/?+)($|/input$)");

		private String program;
		private String user;

		public RestRequest(String path) throws ServletException {
			// regex parse pathInfo
			Matcher matcher;

			matcher = regExAllPattern.matcher(path);
			if (matcher.find()) {
				program = matcher.group("program");
				user = matcher.group("user");
				return;
			}

			throw new ServletException("Invalid URI");
		}

		public String getProgram() {
			return program;
		}

		public void setProgram(String program) {
			this.program = program;
		}

		public String getUser() {
			return user;
		}

		public void setUser(String user) {
			this.user = user;
		}

	}

	/**
	 * Default constructor.
	 */
	public RestLoginFilter() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @see Filter#destroy()
	 */
	public void destroy() {
		// TODO Auto-generated method stub
	}

	/**
	 * @see Filter#doFilter(ServletRequest, ServletResponse, FilterChain)
	 */
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		super.doFilter(request, response, chain);
	}

	/**
	 * @see Filter#init(FilterConfig)
	 */
	public void init(FilterConfig fConfig) throws ServletException {
		super.init(fConfig);
	}

	protected boolean isAuth(HttpServletRequest request) {
		HttpSession session = request.getSession();
		String uri = request.getRequestURI();
		int cl = request.getContextPath().length();
		String path = uri.substring(cl);
		Model model = (Model) session.getAttribute("model");
		String username = "";
		if(model != null) {
			username = model.getUsername();
		}
		boolean loggedIn = false;
		try {
			RestRequest resourceValues = new RestRequest(path);
			String user = resourceValues.getUser();
			try {
				if (!"".equals(username) && username.equals(user)) {
					loggedIn = true;
				}
			} catch (Exception e) {
			}
		} catch (Exception e) {
		}
		return loggedIn;
	}

}
