package model;

import java.io.*;
import java.util.*;

public class Stats {
    
    private int programTypeCount      = 0;
    private int[][] programTypeArray  = new int[10][13];

    private int sgTypeCount           = 0;
    private int[][] sgTypeArray       = new int[10][13];

    private int arpTypeCount           = 0;
    private int[][] arpTypeArray      = new int[10][13];

    private String[] programTypeUsers = new String[10000];
    private int uniqueUsersCount = 0;
        
    public int getProgramTypeCount() {
        return programTypeCount;
    }
    
    public int getUniqueUsersCount() {
        return uniqueUsersCount;
    }
    
    public int[][] getProgramTypeArray() {
        return programTypeArray;
    }
        
    public int[][] getSgTypeArray() {
        return sgTypeArray;
    }
        
    public int[][] getArpTypeArray() {
        return arpTypeArray;
    }
        
    public Stats getStats(String program, String runnableProgramsBaseDir) throws IOException {
       
        String line = "";
        String time = "", date = "", programType = "", user = "", id = "", status = "";
        String month;
        int monthInt = 0;
        int day = 0, year = 0;
        
        for (int i = 0; i < programTypeUsers.length; i++) programTypeUsers[i] = "";
        
        try {
            
            BufferedReader b = new BufferedReader(new FileReader(runnableProgramsBaseDir + "/previousRuns.txt"));
            
            while ((line = b.readLine()) != null) {
                
                StringTokenizer st = new StringTokenizer(line, ":");
                
                time = st.nextToken();
                date = st.nextToken();
                
                StringTokenizer st2 = new StringTokenizer(date, "-");
                
                if (st2.countTokens() == 3) {
                    day = Integer.parseInt(st2.nextToken());
                    month = st2.nextToken();
                    year = Integer.parseInt(st2.nextToken());
                    monthInt = getMonthInt(month);
                    year = year - 2007;
                    
                    programType = st.nextToken();
                    user = st.nextToken();
                    id = st.nextToken();
                    status = st.nextToken();
                
                    if (programType.equals(program) && !status.equals("none")) {
                        if (isValidUser(user)) {
                            this.programTypeArray[year][monthInt]++;
                            this.programTypeCount++;
                            uniqueUsers(programTypeUsers, user);
                        }
                    }
                }
            }
        } catch (IOException e) {
            throw e;
        }
        
        int i;
        
        for (i = 0; i < programTypeUsers.length; i++) {
            if (programTypeUsers[i].equals("")) break;
        }
        
        this.uniqueUsersCount = i;
        
        return this;
    }
    
    public void uniqueUsers(String[] uniqueUsers, String user) {
            
        boolean userExists = false;
        
        int i;
        
        for (i = 0; i < uniqueUsers.length; i++) {
            if (uniqueUsers[i].equals("")) {
                break;
            }
            
            if (uniqueUsers[i].equals(user)) {
                userExists = true;
            }    
        }
        
        int nextIndex = i;
        if (userExists == false) uniqueUsers[nextIndex] = user;
    }
    
    public boolean isValidUser(String user) {
        // changes !!
        if (user.equals("fei123") ||
            user.equals("long123") ||
            user.equals("garibM")) {
            return false;
        } else {
            return true;
        }
    }
    
    public int getMonthInt(String month) {
        if (month.equals("Jan")) return 1;
        if (month.equals("Feb")) return 2;
        if (month.equals("Mar")) return 3;
        if (month.equals("Apr")) return 4;
        if (month.equals("May")) return 5;
        if (month.equals("Jun")) return 6;
        if (month.equals("Jul")) return 7;
        if (month.equals("Aug")) return 8;
        if (month.equals("Sep")) return 9;
        if (month.equals("Oct")) return 10;
        if (month.equals("Nov")) return 11;
        if (month.equals("Dec")) return 12;
        else return -1;
    }
    
    public String getMonthString(int month) {
        if (month == 1) return "Jan";
        if (month == 2) return "Feb";
        if (month == 3) return "Mar";
        if (month == 4) return "Apr";
        if (month == 5) return "May";
        if (month == 6) return "Jun";
        if (month == 7) return "Jul";
        if (month == 8) return "Aug";
        if (month == 9) return "Sep";
        if (month == 10) return "Oct";
        if (month == 11) return "Nov";
        if (month == 12) return "Dec";
        else return "";
    }
}
