package model;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.Path;
import java.text.*;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import uk.ac.york.ysbl.dom.*;

import java.net.MalformedURLException;
import java.net.URL;

public class Model implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8107290657507303224L;
	private Logger logger = LoggerFactory.getLogger("model.Model");

	private String fs = File.separator;

	// private variables
	private String dictionaryStatus = "expand";
	private String programsStatus = "expand";
	private String runnableProgramsStatus = "expand";

	// bean properties (with getters and setters)
	private String currentSpacegroup = "";
	private String runnableProgramsInputBaseDir = "";
	private String runnableProgramsOutputBaseDir = "";
	private String runnableProgramsOutputFile = "";
	private String runnableProgramsPasswdFile = "";
	private String runnableProgramsFilename = "";
	private String runnableProgramsFilenameDir = "";
	private String runnableProgramsExistingId = "";
	private String runnableProgramsExistingJobDir = "";
	private String runnableProgramsType = "";
	private String runStartedId = "";
	private String username = "";
	private String userDir = "";
	private String page = "";
	private Long filesExpireTime = 10L;
	private HashMap<String, String> inputFiles = new HashMap<String, String>();
	private HashMap<String, String> parameters = new HashMap<String, String>();
	private String publicOutputDir = "";
	private String publicOutputURI = "";
	private String isRunStartedId = "";
	private boolean isDuplicate = false;
	private String adminSort = "programType";
	private int noLines = 0;

	private String publicOutputURL = "";
	private String userdir = "";
	private String navBar = "";

	public void resetModel() {
		inputFiles = new HashMap<String, String>();
		parameters = new HashMap<String, String>();
	}

	public String getRunnableProgramsExistingInputDir() {
		return runnableProgramsInputBaseDir + fs + runnableProgramsType + fs
				+ username + fs + runnableProgramsExistingId;
	}

	public String getPublicOutputDir() {
		return publicOutputDir;
	}

	public String getPublicOutputURI() {
		return publicOutputURI;
	}

	public String getPublicOutputURL() {
		return publicOutputURL;
	}

	public String getUserdir() {
		return userdir;
	}

	public String getRunStartedId() {
		return runStartedId;
	}

	public String getRunnableProgramsExistingJobDir() {
		return runnableProgramsExistingJobDir;
	}

	public String getRunnableProgramsExistingStatus() {
		String status = "starting process";
		String jobdir = runnableProgramsExistingJobDir;
		if (new File(jobdir + fs + "processRunning.txt").exists()) {
			status = "process running";
		}
		if (new File(jobdir + fs + "stoppingProcess.txt").exists()) {
			status = "stopping process";
		}
		if (new File(jobdir + fs + "processStopped.txt").exists()) {
			status = "process stopped";
		}
		if (new File(jobdir + fs + "processEnded.txt").exists()) {
			status = "process ended";
		}
		// try to check if the job has crashed
		File summaryFile = new File(jobdir + fs + "output" + fs + "summary.log");
		String lastline = Utility.tail(summaryFile);
		boolean crashed = Pattern.matches(".*error.*", lastline)
				|| Pattern.matches(".*Error.*", lastline);
		if (crashed) {
			status = "process failed";
		}
		return status;
	}

	public String getCurrentSpacegroup() {
		return currentSpacegroup;
	}

	public String getCurrentSpacegroup2() {
		String spacegroup = currentSpacegroup;
		spacegroup.replaceAll("\\(", "_");
		spacegroup.replaceAll("\\)", "");
		return spacegroup;
	}

	public void setCurrentSpacegroup(String currentSpacegroup) {
		this.currentSpacegroup = currentSpacegroup;
	}

	// public get methods
	public String getDictionaryStatus() {
		return dictionaryStatus;
	}

	public String getProgramsStatus() {
		return programsStatus;
	}

	public String getRunnableProgramsStatus() {
		return runnableProgramsStatus;
	}

	public String getRunnableProgramsType() {
		return runnableProgramsType;
	}

	public String getRunnableProgramsInputBaseDir() {
		return runnableProgramsInputBaseDir;
	}

	public String getRunnableProgramsOutputBaseDir() {
		return runnableProgramsOutputBaseDir;
	}

	public String getRunnableProgramsOutputFile() {
		return runnableProgramsOutputFile;
	}

	public String getRunnableProgramsPasswdFile() {
		return runnableProgramsPasswdFile;
	}

	public String getRunnableProgramsFilename() {
		return runnableProgramsFilename;
	}

	public String getRunnableProgramsFilenameDir() {
		return runnableProgramsFilenameDir;
	}

	public String getRunnableProgramsExistingId() {
		return runnableProgramsExistingId;
	}

	// public String getRunnableProgramsRefresh() {
	// return runnableProgramsRefresh;
	// }

	public String getUsername() {
		return username;
	}

	public String getUserDir() {
		return userDir;
	}

	public Long getFilesExpireTime() {
		return filesExpireTime;
	}

	public HashMap<String, String> getInputFiles() {
		return inputFiles;
	}

	public HashMap<String, String> getParameters() {
		return parameters;
	}

	// public set methods
	public void setRunnableProgramsInputBaseDir(
			String runnableProgramsInputBaseDir) {
		this.runnableProgramsInputBaseDir = runnableProgramsInputBaseDir;
	}

	public void setRunnableProgramsOutputBaseDir(
			String runnableProgramsOutputBaseDir) {
		this.runnableProgramsOutputBaseDir = runnableProgramsOutputBaseDir;
	}

	public void setRunnableProgramsOutputFile(String runnableProgramsOutputFile) {
		this.runnableProgramsOutputFile = runnableProgramsOutputFile;
	}

	public void setRunnableProgramsPasswdFile(String runnableProgramsPasswdFile) {
		this.runnableProgramsPasswdFile = runnableProgramsPasswdFile;
	}

	public void setRunnableProgramsFilename(String runnableProgramsFilename) {
		this.runnableProgramsFilename = runnableProgramsFilename;
	}

	public void setRunnableProgramsFilenameDir(
			String runnableProgramsFilenameDir) {
		this.runnableProgramsFilenameDir = runnableProgramsFilenameDir;
	}

	public void setRunnableProgramsExistingId(String runnableProgramsExistingId) {
		this.runnableProgramsExistingId = runnableProgramsExistingId;
	}

	public void setRunnableProgramsExistingJobDir(
			String runnableProgramsExistingJobDir) {
		this.runnableProgramsExistingJobDir = runnableProgramsExistingJobDir;
	}

	// public void setRunnableProgramsRefresh(String runnableProgramsRefresh) {
	// this.runnableProgramsRefresh = runnableProgramsRefresh;
	// }

	public void setRunnableProgramsType(String runnableProgramsType) {
		this.runnableProgramsType = runnableProgramsType.trim();
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public void setRunStartedId(String runStartedId) {
		this.runStartedId = runStartedId;
	}

	public void setUserDir(String userDir) {
		this.userDir = userDir;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public void setFilesExpireTime(Long filesExpireTime) {
		this.filesExpireTime = filesExpireTime;
	}

	public void setInputFiles(HashMap<String, String> inputFiles) {
		this.inputFiles = inputFiles;
	}

	public void setParameters(HashMap<String, String> parameters) {
		this.parameters = parameters;
	}

	public void setPublicOutputDir() {
		// this sets two properties publicOutputURI and
		// publicOutputDir
		String wwwroot = new GetPropertyValues().getProperty("publicroot");
		Path path = Paths.get(wwwroot, username, runnableProgramsExistingId);
		publicOutputDir = path.toString();
		setPublicOutputURI();
	}

	public void setPublicOutputURI() {
		GetPropertyValues gpv = new GetPropertyValues();
		publicOutputURI = gpv.getProperty("publicrooturi") + "/" + username
				+ "/" + runnableProgramsExistingId;
//		try {
			if ("CRANK2".equals(runnableProgramsType) || "SHELX".equals(runnableProgramsType)) {
				//publicOutputURL = new URL("https", gpv.getProperty("server"),
				//		publicOutputURI + "/crank2").toString();
				publicOutputURL = gpv.getProperty("server") + publicOutputURI + "/crank2";
			} else if ("Zanuda".equals(runnableProgramsType)) {
				//publicOutputURL = new URL("https", gpv.getProperty("server"),
				//		publicOutputURI + "/zanuda_jsrview").toString();
				publicOutputURL = gpv.getProperty("server") + "/zanuda_jsrview";
			} else if ("AMPLE".equals(runnableProgramsType)) {
				//publicOutputURL = new URL("http", gpv.getProperty("server"),
				//		publicOutputURI).toString();
				publicOutputURL = gpv.getProperty("server") + publicOutputURI;
			} else if ("MoRDa".equals(runnableProgramsType)) {
				//publicOutputURL = new URL("https", gpv.getProperty("server"),
				//		publicOutputURI + "/jsrview").toString();
				publicOutputURL = gpv.getProperty("server") + publicOutputURI + "/jsrview";
			}
//		} catch (MalformedURLException x) {
//			x.printStackTrace();
//		}
	}

	// index menu choice
	public void changeChoice(String choice) {
		if ("dictionary".equals(choice)) {
			if ("collapse".equals(dictionaryStatus))
				dictionaryStatus = "expand";
			else
				dictionaryStatus = "collapse";
		}

		if ("programs".equals(choice)) {
			if ("collapse".equals(programsStatus))
				programsStatus = "expand";
			else
				programsStatus = "collapse";
		}

		if ("runnablePrograms".equals(choice)) {
			if ("collapse".equals(runnableProgramsStatus))
				runnableProgramsStatus = "expand";
			else
				runnableProgramsStatus = "collapse";
		}
	}

	// get 10 digit id until it is unique
	public String getUniqueId() {

		String r = "";

		while (true) {

			for (int i = 0; i < 10; i++) {
				r += String.valueOf((int) (Math.random() * 10));
			}

			File f = new File(userDir + fs + r);

			if (!f.exists()) {
				break;
			}
		}

		return r;
	}

	// id error messages
	public static final String ERROR_ONLY_TESTUSER_ALLOWED = "only the test user can login";
	public static final String ERROR_FIELD_COMPULSORY = "this field is compulsory";
	public static final String ERROR_ID_DOES_NOT_EXIST = "id does not exist";
	public static final String ERROR_FIELD_TOO_LARGE = "field must be less that 50 characters";
	public static final String ERROR_USERNAME_ALREADY_EXISTS = "username already exists";
	public static final String ERROR_PASSWORD_ALREADY_EXISTS = "password already exists";
	public static final String ERROR_USERNAME_DOES_NOT_EXIST = "username does not exist";
	public static final String ERROR_PASSWORD_DOES_NOT_MATCH_USERNAME = "password is not valid for the above username";
	public static final String ERROR_USERNAME_OUT_OF_BOUNDS = "username must be 6 - 30 characters";
	public static final String ERROR_PASSWORD_OUT_OF_BOUNDS = "password must be 6 - 30 characters";
	public static final String ERROR_PASSWORDS_DO_NOT_MATCH = "password does not match the one above";
	public static final String ERROR_EMAIL_DOES_NOT_EXIST = "email address is not valid for the username";
	public static final String ERROR_USERNAME_INVALID = "username may only consist of alphanumeric characters (a-z A-Z 0-9)";

	// get spacegroups
	public String[][] getSpacegroups() throws Exception {

		String[][] elements = null;

		String f = runnableProgramsOutputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId + fs
				+ "alt_sg_list.xml";

		if (new File(f).exists()) {

			WriteXML writeXML = new WriteXML();

			try {
				elements = writeXML.parseFile(f, "balbes");
			} catch (Exception e) {
				throw e;
			}

		}

		return elements;
	}

	// get spacegroups from the doc file
	public ArrayList<String> getSpacegroups2() throws Exception {
		ArrayList<String> elements = new ArrayList<>();
		String f = runnableProgramsOutputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId + fs
				+ "alt_sg_list.doc";
		if (new File(f).exists()) {
			String fileContents;
			fileContents = new String(Files.readAllBytes(Paths.get(f)));
			Pattern pattern = Pattern.compile("\"(.+)\"");
			Matcher matcher = pattern.matcher(fileContents);
			while (matcher.find()) {
				elements.add(matcher.group().replaceAll("[\\s\"]", ""));
			}
		}
		return elements;
	}

	// add asterisk to error message
	public static String addAsterisk(String errorMessage) {
		return "<span class='error'>* " + errorMessage + "</span>";
	}

	// start process
	public void runnableProgramsStartProcess(String idDir) throws IOException {

		try {
			File f = new File(idDir + fs + "startingProcess.txt");
			PrintWriter out = new PrintWriter(new FileWriter(f));
			out.close();
		} catch (IOException e) {
			throw e;
		}
	}

	// get the drop-down directory file list
	public Vector<String> getRunnableProgramsDropDownList(String dirPath)
			throws IOException {

		Vector<String> v = new Vector<String>();
		String t = "";

		if (isBalbesSpacegroupRun())
			t = currentSpacegroup + fs;

		String path = runnableProgramsOutputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId + fs + t
				+ dirPath;

		File dir = new File(path);

		if (dir.exists()) {

			String[] fileList = dir.list(); // get list of files in directory

			for (int i = 0; i < fileList.length; i++) {

				String filename = fileList[i];
				File file = new File(path + fs + filename);

				String fileExtension = "";
				String fileRoot = "";

				if (!file.isDirectory()) {
					int lastDot = filename.lastIndexOf('.');
					fileExtension = filename.substring(lastDot);

					if (!fileExtension.equals(".dmp")
							&& !fileExtension.equals(".ps")) {
						v.add(filename);
					}
				}
			}
		}

		return v;
	}

	public ArrayList<String> getRunnableProgramsDropDownList2(String dirPath)
			throws IOException {

		ArrayList<String> v = new ArrayList<>();
		String t = "";

		if (isBalbesSpacegroupRun())
			t = currentSpacegroup + fs;

		String path = runnableProgramsOutputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId + fs + t
				+ dirPath;

		File dir = new File(path);

		if (dir.exists()) {

			String[] fileList = dir.list(); // get list of files in directory

			for (int i = 0; i < fileList.length; i++) {

				String filename = fileList[i];
				File file = new File(path + fs + filename);

				String fileExtension = "";
				String fileRoot = "";

				if (!file.isDirectory()) {
					int lastDot = filename.lastIndexOf('.');
					fileExtension = filename.substring(lastDot);

					if (!fileExtension.equals(".dmp")
							&& !fileExtension.equals(".ps")) {
						v.add(filename);
					}
				}
			}
		}

		return v;
	}

	public int getNoLines() {
		return noLines;
	}

	public void setNoLines(int noLines) {
		this.noLines = noLines;
	}

	// sfcheck replace strings
	public String replaceString1 = "";
	public String replaceString2 = "";

	// get sfcheck xml results
	public String[][] getRunnableProgramsSfCheckXML() throws Exception {

		WriteXML writeXML = new WriteXML();
		String[][] elements = null;
		String filename = runnableProgramsInputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "output" + fs
				+ "summary.log";

		if (new File(filename).exists()) {
			try {
				elements = writeXML.parseFile(filename, "sfcheck");
			} catch (Exception e) {
				throw e;
			}
		}

		return elements;
	}

	// get file results
	public String getRunnableProgramsResults() throws IOException {

		String dir = runnableProgramsFilenameDir;
		if (!dir.equals(""))
			dir += fs;

		String filename = runnableProgramsFilename;

		String fileExtension = "";
		String fileRoot = "";

		int lastDot = runnableProgramsFilename.lastIndexOf('.');
		fileExtension = runnableProgramsFilename.substring(lastDot);
		fileRoot = runnableProgramsFilename.substring(0, lastDot);
		if (fileExtension.equals(".mtz"))
			filename = fileRoot + ".dmp";

		filename = runnableProgramsOutputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId + fs + dir
				+ filename;
		File file = new File(filename);
		byte[] bytes = new byte[(int) file.length()];

		// int noLines = 0;

		if (file.exists()) {

			try {

				BufferedInputStream bis = new BufferedInputStream(
						new FileInputStream(file));
				bis.read(bytes);
				bis.close();

				// String line = "";

				// while ((line = in.readLine()) != null) {
				// noLines++;

				// line = line.replaceAll(">", "&gt;");
				// line = line.replaceAll("<", "&lt;");

				// if ("SfCheck".equals(runnableProgramsType)) {
				// line = line.replaceAll(replaceString1 + fs + username + fs +
				// runnableProgramsExistingId, "<i>server_path</i>");
				// line = line.replaceAll(replaceString2, "<i>server_path</i>");
				// }

				// results += line + "<br />";
				// }

			} catch (IOException e) {
				throw e;
			}
		}

		// this.setNoLines(noLines);

		// File f1 = new File(runnableProgramsBaseDir + fs +
		// runnableProgramsType + fs + username + fs +
		// runnableProgramsExistingId + fs + "processStopped.txt");
		// File f2 = new File(runnableProgramsBaseDir + fs +
		// runnableProgramsType + fs + username + fs +
		// runnableProgramsExistingId + fs + "processEnded.txt");

		// if (f1.exists() || f2.exists()) {
		// runnableProgramsRefresh = "OFF";
		// }

		String r = new String(bytes);
		return r;
	}

	// stop process
	public void runnableProgramsStopProcess(String id) throws IOException {

		try {
			File f = new File(runnableProgramsInputBaseDir + fs
					+ runnableProgramsType + fs + username + fs
					+ id + fs + "stoppingProcess.txt");
			PrintWriter out = new PrintWriter(new FileWriter(f));
			out.println("stopProcess");
			out.close();
		} catch (IOException e) {
			throw e;
		}
	}

	// delete process
	public void runnableProgramsDeleteProcess(String id) throws IOException {

		try {
			File f = new File(runnableProgramsInputBaseDir + fs
					+ runnableProgramsType + fs + username + fs + id + fs
					+ "deletingProcess.txt");
			PrintWriter out = new PrintWriter(new FileWriter(f));
			out.println("deletingProcess");
			out.close();
		} catch (IOException e) {
			throw e;
		}
	}

	public Stats getStats(String programType) throws IOException {
		Stats stats = new Stats();
		return stats.getStats(programType, runnableProgramsOutputBaseDir);
	}

	public String getMonthString(int month) {
		if (month == 1)
			return "Jan";
		if (month == 2)
			return "Feb";
		if (month == 3)
			return "Mar";
		if (month == 4)
			return "Apr";
		if (month == 5)
			return "May";
		if (month == 6)
			return "Jun";
		if (month == 7)
			return "Jul";
		if (month == 8)
			return "Aug";
		if (month == 9)
			return "Sep";
		if (month == 10)
			return "Oct";
		if (month == 11)
			return "Nov";
		if (month == 12)
			return "Dec";
		else
			return "";
	}

	// search all programType directories for current runs
	public List<Admin> getAdminList() throws IOException,
			java.text.ParseException, Exception {

		Vector<Admin> programListVector = new Vector<Admin>();

		Date d = null;
		DateFormat df = new SimpleDateFormat("hh-mm-dd-MMM-yyyy");
		String dLong = "";
		Vector<String> longDates = new Vector<String>();

		File baseDir = new File(runnableProgramsOutputBaseDir);

		if (baseDir.exists()) {

			String[] baseDirList = baseDir.list();

			for (int i = 0; i < baseDirList.length; i++) {

				File programTypeDir = new File(runnableProgramsOutputBaseDir
						+ fs + baseDirList[i]);

				if (programTypeDir.isDirectory()) {

					String[] programTypeDirList = programTypeDir.list();

					for (int j = 0; j < programTypeDirList.length; j++) {

						File userDir = new File(runnableProgramsOutputBaseDir
								+ fs + baseDirList[i] + fs
								+ programTypeDirList[j]);

						if (userDir.isDirectory()) {

							String[] userDirList = userDir.list(new FilenameFilter() {
								@Override
								public boolean accept(File pathname, String name) {
									return name.matches("[0-9]+");
								}
							}); 

							for (int k = 0; k < userDirList.length; k++) {

								File idDir = new File(
										runnableProgramsOutputBaseDir + fs
												+ baseDirList[i] + fs
												+ programTypeDirList[j] + fs
												+ userDirList[k]);

								if (idDir.isDirectory()) {

									File infoFile = new File(
											runnableProgramsOutputBaseDir + fs
													+ baseDirList[i] + fs
													+ programTypeDirList[j]
													+ fs + userDirList[k] + fs
													+ "info.txt");

									// get date from info file
									if (infoFile.exists()) {

										StringTokenizer st;
										String date = "";
										String hour = "", minute = "";
										String day = "", month = "", year = "";

										try {
											BufferedReader in = new BufferedReader(
													new FileReader(infoFile));
											String line = "";

											while ((line = in.readLine()) != null) {
												st = new StringTokenizer(line,
														":");
												date = st.nextToken();

												st = new StringTokenizer(date,
														"-");
												hour = st.nextToken();
												minute = st.nextToken();
												day = st.nextToken();
												month = st.nextToken();
												year = st.nextToken();

												try {
													d = df.parse(date);
													dLong = String.valueOf(d
															.getTime());
												} catch (java.text.ParseException e) {
													throw e;
												}
											}
										} catch (IOException e) {
											throw e;
										}

										// get current status of program run
										String status = "";
										String dd = runnableProgramsInputBaseDir
												+ fs
												+ baseDirList[i]
												+ fs
												+ programTypeDirList[j]
												+ fs
												+ userDirList[k] + fs;

										File startingProcessFile = new File(dd
												+ "startingProcess.txt");
										long startingProcessTime = 0;
										if (startingProcessFile.exists()) {
											status = "starting process";
											startingProcessTime = startingProcessFile
													.lastModified();
										}

										File processQueuedFile = new File(dd
												+ "processQueued.txt");
										long processQueuedTime = 0;
										if (processQueuedFile.exists()) {
											status = "QUEUED";
											processQueuedTime = processQueuedFile
													.lastModified();
										}

										File processRunningFile = new File(dd
												+ "processRunning.txt");
										long processRunningTime = 0;
										if (processRunningFile.exists()) {
											status = "RUNNING";
											processRunningTime = processRunningFile
													.lastModified();
										}

										File stoppingProcessFile = new File(dd
												+ "stoppingProcess.txt");
										if (stoppingProcessFile.exists())
											status = "stopping process";

										File processStoppedFile = new File(dd
												+ "processStopped.txt");
										if (processStoppedFile.exists())
											status = "STOPPED";

										File processEndedFile = new File(dd
												+ "processEnded.txt");
										if (processEndedFile.exists())
											status = "ENDED";

										File deletingProcessFile = new File(dd
												+ "deletingProcess.txt");
										if (deletingProcessFile.exists())
											status = "DELETED";

										if (!status.equals("")) {
											String str = "";
											if (baseDirList[i].equals("Balbes")) {
												str = "balbes";
											} else if (baseDirList[i]
													.equals("CRANK2")) {
												str = dd + fs + "summary.log";
											} else {
												str = dd + "output" + fs
														+ "summary.log";
											}

											// add SG and Arp/wARP info here,
											// temporarily (or maybe add the
											// indicators into file "info.txt"
											// already exists)
											File processARPFile = new File(dd
													+ "arpWarp.txt");
											File processSGFile = new File(dd
													+ "SGjobsummary.txt");
											if (processARPFile.exists()
													&& processSGFile.exists()) {
												status = status
														+ "(+SG+ARP/wARP)";
											} else if (processARPFile.exists()) {
												status = status + "(+ARP/wARP)";
											} else if (processSGFile.exists()) {
												status = status + "(+SG)";
											}
											// status =
											// "<a href=\"javascript:showHelp21('"
											// + str + "')\">" + status +
											// "</a>";
											// check "javascript:showHelp21

											status = "<span style='color: blue;'>"
													+ status + "</style>";
										}

										// if no status, an error has occurred,
										// therefore display the error code
										if (status.equals("")) {

											String errorFilename = runnableProgramsOutputBaseDir
													+ fs
													+ baseDirList[i]
													+ fs
													+ programTypeDirList[j]
													+ fs
													+ userDirList[k]
													+ fs
													+ "error.txt";

											File errorFile = new File(
													errorFilename);

											if (errorFile.exists()) {

												try {
													BufferedReader in = new BufferedReader(
															new FileReader(
																	errorFile));
													String line = "";
													int noLine = 0;

													while ((line = in
															.readLine()) != null) {
														if (!line.equals("")) {
															noLine++;
															String title = line;
															if (line.startsWith("ERROR_BUCCANEER_PARAMETERS_MISSING")) {
																title = "ERROR_BUCCANEER_PARAMETERS_MISSING";
															}
															// String m =
															// "<a href=\"javascript:showHelp10('"
															// + title + "', '"
															// +
															// getErrorString(line)
															// + "')\">";
															if (noLine == 1) {
																status = "<span style='color: red;'>"
																		+ getErrorString2(title)
																		+ "</style>";
															} else {
																status += "<br/><span style='color: red;'>"
																		+ getErrorString2(title)
																		+ "</style>";
															}
														}
													}

												} catch (IOException e) {
													throw e;
												}
											}
										}

										longDates.add(new String(dLong));

										// populate admin object with required
										// data and add to arrayList l
										Admin admin = new Admin();

										admin.setProgramType(baseDirList[i]);
										admin.setUser(programTypeDirList[j]);
										admin.setId(userDirList[k]);
										admin.setDay(day);
										admin.setMonth(month);
										admin.setYear(year);
										admin.setHour(hour);
										admin.setMinute(minute);
										admin.setStatus(status);
										admin.setStartingProcessTime(startingProcessTime);
										admin.setProcessQueuedTime(processQueuedTime);
										admin.setProcessRunningTime(processRunningTime);
										programListVector.add(admin);
									}
								}
							}
						}
					}
				}
			}
		}

		try {
			programListVector = bubbleSort(programListVector);
		} catch (Exception e) {
			throw e;
		}

		return programListVector;
	}

	private String getFileEndText(String str) {
		return "some text";
	}

	private int totalUsers = 0;

	public String getTotalUsers() {
		return String.valueOf(totalUsers);
	}

	public String getCurrentUsers() throws IOException {

		String currentUsers = "";
		String user = "";
		int usersPerLine = 0;
		int columns = 6;
		totalUsers = 0;

		try {
			BufferedReader in = new BufferedReader(new FileReader(
					runnableProgramsPasswdFile));
			String line;
			while ((line = in.readLine()) != null) {
				StringTokenizer st = new StringTokenizer(line, ":");
				while (st.hasMoreTokens()) {
					user = st.nextToken();
					st.nextToken();
					st.nextToken();
					st.nextToken();

					if (isValidUser(user) == true) {

						totalUsers++;

						if (usersPerLine == 0) {
							currentUsers += "<tr>";
						}

						currentUsers += "<td>" + user + "</td>";

						usersPerLine++;

						if (usersPerLine >= columns) {
							currentUsers += "</tr>";
							usersPerLine = 0;
						}
					}
				}
			}
		} catch (IOException e) {
			throw e;
		}

		for (int i = 0; i < (columns - usersPerLine); i++) {
			currentUsers += "<td>&nbsp;</td>";
		}

		return currentUsers;
	}

	public boolean isValidUser(String user) {
		// changes are required here for new admins
		if ("adminUser".equals(user)) {
			return false;
		} else {
			return true;
		}
	}

	public String getMemoryUsage() throws IOException, Exception {

		String f = runnableProgramsOutputBaseDir + fs + "memoryUsage.txt";

		String[] command = { "sh", "-c",
				"du -sh " + runnableProgramsOutputBaseDir + " > " + f };

		try {
			Runtime rt = Runtime.getRuntime();
			Process proc = rt.exec(command);
			int exitVal = proc.waitFor();
		} catch (Exception e) {
			throw e;
		}

		String memoryUsage = "";

		try {
			BufferedReader in = new BufferedReader(new FileReader(f));

			String line;

			while ((line = in.readLine()) != null) {
				StringTokenizer st = new StringTokenizer(line, "\t");
				memoryUsage = st.nextToken();
			}

		} catch (IOException e) {
			throw e;
		}

		return memoryUsage;
	}

	// get invalid characters
	public String getInvalidCharacters() throws IOException {

		String filename = "invalidCharacters.txt";

		File f = new File(runnableProgramsInputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + filename);

		String invalidCharacters = "";

		if (f.exists()) {
			try {
				BufferedReader in = new BufferedReader(new FileReader(f));
				invalidCharacters = in.readLine();
			} catch (IOException e) {
				throw e;
			}
		}

		int invalidCharactersLength = invalidCharacters.length();
		if (invalidCharactersLength > 40) {
			invalidCharacters = invalidCharacters.substring(0, 40);
		}

		return invalidCharacters;
	}

	public String getAdminSort() {
		return adminSort;
	}

	public void setAdminSort(String adminSort) {
		this.adminSort = adminSort;
	}

	public Vector<Admin> getProgramRunList() throws IOException,
			java.text.ParseException, Exception {

		Vector<Admin> programListVector = new Vector<Admin>();

		Date d = null;
		DateFormat df = new SimpleDateFormat("hh-mm-dd-MMM-yyyy");
		String dLong = "";
		Vector<String> longDates = new Vector<String>();

		StringTokenizer st;
		String id = "";
		String date = "";
		String hour = "", minute = "";
		String day = "", month = "", year = "";

		File d1 = new File(runnableProgramsInputBaseDir + fs
				+ runnableProgramsType + fs + username);
		File d2 = new File(runnableProgramsOutputBaseDir + fs
				+ runnableProgramsType + fs + username);

		if (d1.exists()) {
			String[] fileList = d1.list(new FilenameFilter() {
								@Override
								public boolean accept(File pathname, String name) {
									return name.matches("[0-9]+");
								}
							});

			for (int i = 0; i < fileList.length; i++) {

				File dir = new File(d1 + fs + fileList[i]);
				File dir2 = new File(d1 + fs + fileList[i] + fs
						+ "startingProcess.txt");
				if (dir.isDirectory() && dir2.exists()) {

					id = fileList[i];

					File f = new File(runnableProgramsInputBaseDir + fs
							+ runnableProgramsType + fs + username + fs + id
							+ fs + "info.txt");

					try (BufferedReader in = new BufferedReader(new FileReader(
							f))) {
						;
						String line = "";

						while ((line = in.readLine()) != null) {
							st = new StringTokenizer(line, ":");
							date = st.nextToken();
							st = new StringTokenizer(date, "-");
							hour = st.nextToken();
							minute = st.nextToken();
							day = st.nextToken();
							month = st.nextToken();
							year = st.nextToken();

							try {
								d = df.parse(date);
								dLong = String.valueOf(d.getTime());
							} catch (java.text.ParseException e) {
								throw e;
							}
						}
					} catch (IOException e) {
						throw e;
					}
					String status = "";
					String dd = runnableProgramsInputBaseDir + fs
							+ runnableProgramsType + fs + username + fs + id
							+ fs;

					File startingProcessFile = new File(dd
							+ "startingProcess.txt");
					if (startingProcessFile.exists())
						status = "starting process";

					// the following files are searched for in the output
					// directory, if it has been created
					String dout = runnableProgramsOutputBaseDir + fs
							+ runnableProgramsType + fs + username + fs + id
							+ fs;

					File processRunningFile = new File(dout
							+ "processRunning.txt");
					if (processRunningFile.exists())
						status = "process running";

					File stoppingProcessFile = new File(dout
							+ "stoppingProcess.txt");
					if (stoppingProcessFile.exists())
						status = "stopping process";

					File processStoppedFile = new File(dout
							+ "processStopped.txt");
					if (processStoppedFile.exists())
						status = "process stopped";

					File processEndedFile = new File(dout + "processEnded.txt");
					if (processEndedFile.exists())
						status = "process ended";

					// try to check if the job has crashed
					File summaryFile = new File(dd + "output" + fs
							+ "summary.log");
					String lastline = Utility.tail(summaryFile);
					boolean crashed = Pattern.matches(".*error.*", lastline)
							|| Pattern.matches(".*Error.*", lastline);
					if (crashed) {
						status = "process failed";
					}

					// This files is searched for in the input directory.
					File deletingProcessFile = new File(dd
							+ "deletingProcess.txt");
					if (deletingProcessFile.exists())
						status = "deleting run";

					String jobtitle = "";

					File jobTitleFile = new File(dd + "jobtitle.txt");
					if (jobTitleFile.exists()) {
						try (BufferedReader br = new BufferedReader(
								new FileReader(jobTitleFile))) {
							jobtitle = br.readLine();
						} catch (Exception ex) {
						}
					}

					if (jobtitle.equals("")) {
						jobtitle = "N/A";
					}

					longDates.add(new String(dLong));

					Admin admin = new Admin();

					admin.setId(id);
					admin.setTitle(jobtitle);
					admin.setDay(day);
					admin.setMonth(month);
					admin.setYear(year);
					admin.setHour(hour);
					admin.setMinute(minute);
					admin.setStatus(status);

					programListVector.add(admin);
				}
			}
		}

		try {
			programListVector = bubbleSort(programListVector);
		} catch (Exception e) {
			throw e;
		}

		return programListVector;
	}

	public List sortByDate(Vector l, Vector<String> longDates) {
		Vector<String> longDatesClone = (Vector<String>) longDates.clone();
		List lClone = new ArrayList();

		Collections.sort(longDates);
		Collections.reverse(longDates);

		for (int i = 0; i < longDates.size(); i++) {
			String str = String.valueOf((longDates.get(i).toString()));
			for (int j = 0; j < longDatesClone.size(); j++) {
				if (str.equals(String.valueOf(longDatesClone.elementAt(j)))) {
					lClone.add(l.elementAt(j));
					longDatesClone.remove(j);
					longDatesClone.insertElementAt(new String("x"), j);
					break;
				}
			}
		}

		return lClone;
	}

	public String getErrorString(String error) {

		String err = "";

		if ("ERROR_DUPLICATE_RUN".equals(error)) {
			err = "Error - This appears to be a duplicate run - did you click submit twice or click the browser Refresh button?";

		} else if ("ERROR_MAXIMUM_RUNS_EXCEEDED".equals(error)) {
			err = "Error - The maximum number of program runs has been exceeded - please try again later";

		} else if ("ERROR_MISSING_SUBSTRUCTURE_ATOM".equals(error)) {
			err = "Error - The substructure atom type is required";

		} else if ("ERROR_NO_STRUCTURE_FACTORS_FILE".equals(error)) {
			err = "Error - A Structure Factors file was not entered";

		} else if ("ERROR_NO_STRUCTURE_FACTORS_FILE1".equals(error)) {
			err = "Error - The Structure Factors file for dataset 1 was not entered";

		} else if ("ERROR_NO_STRUCTURE_FACTORS_FILE2".equals(error)) {
			err = "Error - The Structure Factors file for dataset 2 was not entered";

		} else if ("ERROR_NO_STRUCTURE_FACTORS_FILE3".equals(error)) {
			err = "Error - The Structure Factors file for dataset 3 was not entered";

		} else if ("ERROR_NO_STRUCTURE_FACTORS_FILE4".equals(error)) {
			err = "Error - The Structure Factors file for dataset 4 was not entered";

		} else if ("ERROR_NO_NATIVE_STRUCTURE_FACTORS_FILE".equals(error)) {
			err = "Error - The Structure Factors file for the native dataset was not entered";

		} else if ("ERROR_NATIVE_STRUCTURE_FACTORS_FILESIZE_ZERO".equals(error)) {
			err = "Error - The Structure Factors file for the native dataset has zero size";

		} else if ("ERROR_NO_COORDINATES_FILE".equals(error)) {
			err = "Error - A Coordinates file was not entered";

		} else if ("ERROR_INVALID_DATATYPE1".equals(error)) {
			err = "Error - Invalid datatype for dataset 1";

		} else if ("ERROR_INVALID_DATATYPE2".equals(error)) {
			err = "Error - Invalid datatype for dataset 2";

		} else if ("ERROR_INVALID_DATATYPE3".equals(error)) {
			err = "Error - Invalid datatype for dataset 3";

		} else if ("ERROR_INVALID_DATATYPE4".equals(error)) {
			err = "Error - Invalid datatype for dataset 4";

		} else if ("ERROR_NO_SEQUENCE_TARGET_FILE_OR_TEXTAREA".equals(error)) {
			err = "Error - A Sequence Target file was not entered (or a sequence was not pasted in the text area)";

		} else if ("ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_SPACES".equals(error)) {
			err = "Error - Structure Factors filename contains spaces - please remove and try again";

		} else if ("ERROR_COORDINATES_FILE_CONTAINS_SPACES".equals(error)) {
			err = "Error - Coordinates filename contains spaces - please remove and try again";

		} else if ("ERROR_SEQUENCE_TARGET_FILE_CONTAINS_SPACES".equals(error)) {
			err = "Error - Sequence Target filename contains spaces - please remove and try again";

		} else if (error
				.equals("ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_BRACKETS")) {
			err = "Error - Structure Factors filename contains brackets - please remove and try again";

		} else if ("ERROR_COORDINATES_FILE_CONTAINS_BRACKETS".equals(error)) {
			err = "Error - Coordinates filename contains brackets - please remove and try again";

		} else if ("ERROR_SEQUENCE_TARGET_FILE_CONTAINS_BRACKETS".equals(error)) {
			err = "Error - Sequence Target filename contains brackets - please remove and try again";

		} else if ("ERROR_STRUCTURE_FACTORS_FILESIZE_ZERO".equals(error)) {
			err = "Error - Structure Factors filesize is zero";

		} else if ("ERROR_COORDINATES_FILESIZE_ZERO".equals(error)) {
			err = "Error - Coordinates filesize is zero";

		} else if ("ERROR_SEQUENCE_TARGET_FILESIZE_ZERO".equals(error)) {
			err = "Error - Sequence Target filesize is zero";

		} else if (error
				.equals("ERROR_STRUCTURE_FACTORS_EXCEEDS_LIMIT")) {
			err = "Error - Structure Factors file size exceeds limit for this type - please contact admin";

		} else if ("ERROR_COORDINATES_FILESIZE_EXCEEDS_LIMIT".equals(error)) {
			err = "Error - Coordinates file size exceeds limit for this type - please contact admin";

		} else if ("ERROR_SEQUENCE_TARGET_FILESIZE_EXCEEDS_LIMIT".equals(error)) {
			err = "Error - Sequence Target file size exceeds limit for this type - did you enter a valid sequence?";

		} else if (error
				.equals("ERROR_SEQUENCE_TARGET_FILE_AND_TEXT_AREA_EXIST")) {
			err = "Error - Please choose a Sequence Target file OR paste your sequence in the text area - not both!";

		} else if ("ERROR_STRUCTURE_FACTORS_INVALID".equals(error)) {
			err = "Error - Structure Factors file appears to be invalid";

		} else if ("ERROR_COORDINATES_INVALID".equals(error)) {
			err = "Error - Coordinates file appears to be invalid";

		} else if ("ERROR_SEQUENCE_TARGET_INVALID".equals(error)) {
			err = "Error - Sequence Target file invalid - is it missing the comment line? Please see the FASTA link above";

		} else if ("ERROR_VALIDATING_STRUCTURE_FACTORS_FILE".equals(error)) {
			err = "There was a problem validating the Structure Factors file - please contact flong@mrc-lmb.cam.ac.uk";

		} else if ("ERROR_VALIDATING_COORDINATES_FILE".equals(error)) {
			err = "There was a problem validating the Coordinates file - please contact flong@mrc-lmb.cam.ac.uk";

		} else if ("ERROR_REMOTE_COMMUNICATION_PROBLEM".equals(error)) {
			err = "Error - The files could not be validated, possibly due to a communication problem between the server computers - please try again (if it happens more than once please contact flong@mrc-lmb.cam.ac.uk)";

		} else if (error.startsWith("ERROR_BUCCANEER_PARAMETERS_MISSING")) {
			String parameterString = "";
			if (error.matches(".*PHI_FOM / HL.*")) {
				parameterString += "Phase Information (PHI_FOM or HL)";
			}
			if (error.matches(".*FP / sigFP.*")) {
				if (!parameterString.equals(""))
					parameterString += " and ";
				parameterString += "Structure Factors (FP_sigFP)";
			}
			if (error.matches(".*FREE R FLAG.*")) {
				if (!parameterString.equals(""))
					parameterString += " and ";
				parameterString += "Free R Flag";
			}
			err = "Error - these parameter(s) are missing from the mtz file: "
					+ parameterString;

		} else if ("ERROR_BUCCANEER_STRUCTURE_FACTORS_INVALID".equals(error)) {
			err = "Error - Structure Factors file appears to be invalid - please make sure it is an mtz file";

		} else if ("ERROR_BUCCANEER_DMP_DOES_NOT_EXIST".equals(error)) {
			err = "Error - please contact flong@mrc-lmb.cam.ac.uk";

		} else if ("ERROR_ALT_FILE_NOT_FOUND".equals(error)) {
			err = "Error - The files could not be validated, possibly due to a communication problem between the server computers - please try again (if it happens more than once please contact flong@mrc-lmb.cam.ac.uk)";
		}

		return err;
	}

	public String getErrorString2(String error) {

		String err = "";

		if ("ERROR_DUPLICATE_RUN".equals(error)) {
			err = "err_dup_run";

		} else if ("ERROR_MAXIMUM_RUNS_EXCEEDED".equals(error)) {
			err = "err_max_runs_ex";

		} else if ("ERROR_NO_STRUCTURE_FACTORS_FILE".equals(error)) {
			err = "err_no_SF";

		} else if ("ERROR_NO_COORDINATES_FILE".equals(error)) {
			err = "err_no_CO";

		} else if ("ERROR_NO_SEQUENCE_TARGET_FILE_OR_TEXTAREA".equals(error)) {
			err = "err_no_ST";

		} else if ("ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_SPACES".equals(error)) {
			err = "err_SF_spaces";

		} else if ("ERROR_COORDINATES_FILE_CONTAINS_SPACES".equals(error)) {
			err = "err_CO_spaces";

		} else if ("ERROR_SEQUENCE_TARGET_FILE_CONTAINS_SPACES".equals(error)) {
			err = "err_ST_spaces";

		} else if (error
				.equals("ERROR_STRUCTURE_FACTORS_FILE_CONTAINS_BRACKETS")) {
			err = "err_SF_brackets";

		} else if ("ERROR_COORDINATES_FILE_CONTAINS_BRACKETS".equals(error)) {
			err = "err_CO_brackets";

		} else if ("ERROR_SEQUENCE_TARGET_FILE_CONTAINS_BRACKETS".equals(error)) {
			err = "err_ST_brackets";

		} else if ("ERROR_STRUCTURE_FACTORS_FILESIZE_ZERO".equals(error)) {
			err = "err_SF_filesize";

		} else if ("ERROR_COORDINATES_FILESIZE_ZERO".equals(error)) {
			err = "err_CO_filesize";

		} else if ("ERROR_SEQUENCE_TARGET_FILESIZE_ZERO".equals(error)) {
			err = "err_ST_filesize";

		} else if (error
				.equals("ERROR_STRUCTURE_FACTORS_FILESIZE_EXCEEDS_LIMIT")) {
			err = "err_SF_filesiz_ex";

		} else if ("ERROR_COORDINATES_FILESIZE_EXCEEDS_LIMIT".equals(error)) {
			err = "err_CO_filesiz_ex";

		} else if ("ERROR_SEQUENCE_TARGET_FILESIZE_EXCEEDS_LIMIT".equals(error)) {
			err = "err_ST_filesiz_ex";

		} else if (error
				.equals("ERROR_SEQUENCE_TARGET_FILE_AND_TEXT_AREA_EXIST")) {
			err = "err_ST_and_textarea";

		} else if ("ERROR_STRUCTURE_FACTORS_INVALID".equals(error)) {
			err = "err_SF_invalid";

		} else if ("ERROR_COORDINATES_INVALID".equals(error)) {
			err = "err_CO_invalid";

		} else if ("ERROR_SEQUENCE_TARGET_INVALID".equals(error)) {
			err = "err_ST_invalid";

		} else if ("ERROR_VALIDATING_STRUCTURE_FACTORS_FILE".equals(error)) {
			err = "err_SF_validation";

		} else if ("ERROR_VALIDATING_COORDINATES_FILE".equals(error)) {
			err = "err_CO_validation";

		} else if ("ERROR_REMOTE_COMMUNICATION_PROBLEM".equals(error)) {
			err = "err_com_problem";

		} else if ("ERROR_BUCCANEER_PARAMETERS_MISSING".equals(error)) {
			err = "err_bucc_params";

		} else if ("ERROR_BUCCANEER_STRUCTURE_FACTORS_INVALID".equals(error)) {
			err = "err_bucc_SF_invalid";

		} else if ("ERROR_BUCCANEER_DMP_DOES_NOT_EXIST".equals(error)) {
			err = "err_no_bucc_dmp";

		} else if ("ERROR_ALT_FILE_NOT_FOUND".equals(error)) {
			err = "err_no_alt_file";
		}

		return err;
	}

	public Vector<String> getProgramRunErrors() throws IOException {

		File errorFile = new File(runnableProgramsInputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "error.txt");

		Vector<String> errorVector = new Vector<String>();

		boolean lines = false;
		boolean tryAgain = true;

		if (errorFile.exists()) {
			
			logger.info("errorfile exists");

			try {

				BufferedReader in = new BufferedReader(
						new FileReader(errorFile));

				String line = "";

				while ((line = in.readLine()) != null) {
					line = line.trim();
					if (!"".equals(line)) {
						logger.info("line: "+line);
						lines = true;
						if ("E1".equals(line) || "E2".equals(line)
								|| "E11".equals(line) || "E12".equals(line)) {
							tryAgain = false;
						}
						errorVector.add(getErrorString(line));
					}
				}

			} catch (IOException e) {
				throw e;
			}
		}

		if (lines == true && tryAgain == true)
			errorVector.add("PLEASE RE-ENTER YOUR FORM DETAILS AND TRY AGAIN");

		return errorVector;
	}

	public void setIsDuplicate(boolean isDuplicate) {
		this.isDuplicate = isDuplicate;
	}

	public boolean getIsDuplicate() {
		return isDuplicate;
	}

	public void createStandardDirectories() throws IOException {

		String idDir = runnableProgramsInputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId;

		File outputDir = new File(idDir, "output");

		if (!outputDir.exists()) {
			outputDir.mkdir();
		}

		File summaryFile = new File(outputDir, "summary.log");

		if (!summaryFile.exists()) {
			try {
				PrintWriter out = new PrintWriter(new FileWriter(summaryFile));
				out.println("");
				out.close();
			} catch (IOException e) {
				throw e;
			}
		}
	}

	public void createModSearchDirectories() throws IOException {

		String idDir = runnableProgramsInputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId;

		File processDetailsDir = new File(idDir, "process_details");
		if (!processDetailsDir.exists())
			processDetailsDir.mkdir();

		File templateModelsDir = new File(idDir, "template_models");
		if (!templateModelsDir.exists())
			templateModelsDir.mkdir();
	}

	public void createBalbesDirectories() throws IOException {

		String idDir = runnableProgramsInputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId;

		File processDetailsDir = new File(idDir, "process_details");
		if (!processDetailsDir.exists())
			processDetailsDir.mkdir();

		File templateModelsDir = new File(idDir, "template_models");
		if (!templateModelsDir.exists())
			templateModelsDir.mkdir();

		File templateSolutionsDir = new File(processDetailsDir,
				"template_solutions");
		if (!templateSolutionsDir.exists())
			templateSolutionsDir.mkdir();

		File resultsDir = new File(idDir, "results");
		if (!resultsDir.exists())
			resultsDir.mkdir();
	}

	public void createMultipleBalbesDirectories() throws Exception {

		String idDir = runnableProgramsInputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId;

		String[][] elements = null;

		try {
			elements = getSpacegroups();
		} catch (Exception e) {
			throw e;
		}

		String el = "";

		for (int i = 0; i < elements.length; i++) {

			el = elements[i][0].replaceAll(" ", "");

			File d = new File(idDir + fs + el);

			if (!d.exists()) {
				d.mkdir();
			}

			File outputDir = new File(d, "output");

			if (!outputDir.exists()) {
				outputDir.mkdir();
			}

			File summaryFile = new File(outputDir, "summary.log");

			if (!summaryFile.exists()) {
				try {
					PrintWriter out = new PrintWriter(new FileWriter(
							summaryFile));
					out.println("");
					out.close();
				} catch (IOException e) {
					throw e;
				}
			}

			File processDetailsDir = new File(d, "process_details");
			if (!processDetailsDir.exists())
				processDetailsDir.mkdir();

			File templateModelsDir = new File(d, "template_models");
			if (!templateModelsDir.exists())
				templateModelsDir.mkdir();

			File templateSolutionsDir = new File(d, "template_solutions");
			if (!templateSolutionsDir.exists())
				templateSolutionsDir.mkdir();

			File resultsDir = new File(d, "results");
			if (!resultsDir.exists())
				resultsDir.mkdir();
		}
	}

	public boolean isBalbesSpacegroupRun() {

		String spacegroupFilename = runnableProgramsInputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "checkFullSpacegroup.txt";

		File spacegroupFile = new File(spacegroupFilename);

		if (spacegroupFile.exists()) {
			return true;
		} else {
			return false;
		}
	}

	public boolean SGjobsummaryFileExists() {

		String idDir = runnableProgramsOutputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "SGjobsummary.txt";

		File d = new File(idDir);

		if (d.exists()) {
			return true;
		} else {
			return false;
		}
	}

	public boolean summaryFileExists() {

		String idDir = runnableProgramsOutputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "output" + fs
				+ "summary.log";

		File d = new File(idDir);

		if (d.exists()) {
			return true;
		} else {
			return false;
		}
	}

	public boolean isArpWarpRun() {

		String idDir = runnableProgramsInputBaseDir + fs + runnableProgramsType
				+ fs + username + fs + runnableProgramsExistingId + fs
				+ "arpWarp.txt";

		File d = new File(idDir);

		if (d.exists()) {
			return true;
		} else {
			return false;
		}
	}

	public String arpWarpJobFinishFile() throws IOException {

		String filename = runnableProgramsOutputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "ARPJobfinish.txt";

		File file = new File(filename);

		if (file.exists()) {

			String str = "";

			try {
				BufferedReader in = new BufferedReader(new FileReader(file));
				str = in.readLine();
				in.close();
			} catch (IOException e) {
				throw e;
			}

			if (str == null || str.equals("")) {
				return "";
			} else if (str.startsWith("One job has been sent to ARP/wARP")) {
				return "true";
			} else {
				return "false";
			}
		}

		return "";
	}

	public String getArpWarpLink() throws IOException {

		String link = "";

		String filename = runnableProgramsOutputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + "results" + fs
				+ "Arpwarpweblink.txt";

		File file = new File(filename);

		if (file.exists()) {

			try {
				BufferedReader in = new BufferedReader(new FileReader(file));
				link = in.readLine();
				in.close();
			} catch (IOException e) {
				throw e;
			}

			if (link == null || link.equals("")) {
				link = "";
			}

		} else {
			link = "";
		}

		return link;
	}

	public String getLocalSpacegroup() throws Exception {

		try {

			String[][] elements = getSpacegroups();

			for (int i = 0; i < elements.length; i++) {

				if (elements[i][0] != null
						&& !elements[i][0].matches(".*\\(.\\)")) {
					String element = elements[i][0].replaceAll(" ", "");
					String link = getArpWarpLink(element);

					if (!link.equals("")) {
						return element;
					}
				}
			}

		} catch (Exception e) {
			throw e;
		}

		return "";
	}

	public String getArpWarpLink(String spacegroup) throws IOException {

		String link = "";

		String filename = runnableProgramsOutputBaseDir + fs
				+ runnableProgramsType + fs + username + fs
				+ runnableProgramsExistingId + fs + spacegroup + fs + "results"
				+ fs + "Arpwarpweblink.txt";

		File file = new File(filename);

		if (file.exists()) {

			try {
				BufferedReader in = new BufferedReader(new FileReader(file));
				link = in.readLine();
				in.close();
			} catch (IOException e) {
				throw e;
			}

			if (link == null || link.equals("")) {
				link = "";
			}

		} else {
			link = "";
		}

		return link;
	}

	public String getIsRunStartedId() {
		return isRunStartedId;
	}

	public void setIsRunStartedId(String isRunStartedId) {
		this.isRunStartedId = isRunStartedId;
	}

	public Buccaneer getBuccaneerParameters() throws IOException {

		String idDir = runnableProgramsInputBaseDir + fs + "Buccaneer" + fs
				+ username + fs + runnableProgramsExistingId;
		String infoFile = idDir + fs + "info.txt";
		String inputDir = idDir + fs + "input";

		Buccaneer buccaneer = new Buccaneer();

		String mtzFilename = "";

		// get the path of the mtz file from info.txt
		try {

			BufferedReader in = new BufferedReader(new FileReader(infoFile));
			StringTokenizer st = null;
			String line = "";

			while ((line = in.readLine()) != null) {
				st = new StringTokenizer(line, ":");
				st.nextToken();
				mtzFilename = inputDir + fs + st.nextToken();
				st.nextToken();
			}

		} catch (IOException e) {
			throw e;
		}

		// get dmpFilename by replacing the mtzFilename extension with dmp
		String dmpFilename = mtzFilename.replaceFirst(".mtz", ".dmp");

		// set the buccaneer parameters
		String dummy = buccaneer.setParameters(dmpFilename);

		return buccaneer;
	}

	public int convertMonth(String month) {

		if ("Jan".equals(month)) {
			return 1;
		} else if ("Feb".equals(month)) {
			return 2;
		} else if ("Mar".equals(month)) {
			return 3;
		} else if ("Apr".equals(month)) {
			return 4;
		} else if ("May".equals(month)) {
			return 5;
		} else if ("Jun".equals(month)) {
			return 6;
		} else if ("Jul".equals(month)) {
			return 7;
		} else if ("Aug".equals(month)) {
			return 8;
		} else if ("Sep".equals(month)) {
			return 9;
		} else if ("Oct".equals(month)) {
			return 10;
		} else if ("Nov".equals(month)) {
			return 11;
		} else if ("Dec".equals(month)) {
			return 12;
		} else {
			return 0;
		}
	}

	public Vector<Admin> bubbleSort(Vector<Admin> oldVector) throws Exception {

		Vector<Admin> itemsVector = (Vector<Admin>) oldVector.clone();

		boolean swapped = false;
		int greater = 1;
		int swaps = 0;
		int swapsLimit = 50000;

		try {
			do {
				if (swaps > swapsLimit) {
					throw new Exception();
				}
				swapped = false;

				for (int i = 0; i < itemsVector.size() - 1; i++) {

					Admin admin1 = itemsVector.elementAt(i);
					Admin admin2 = itemsVector.elementAt(i + 1);

					int year1 = Integer.parseInt(admin1.getYear());
					int year2 = Integer.parseInt(admin2.getYear());
					int month1 = convertMonth(admin1.getMonth());
					int month2 = convertMonth(admin2.getMonth());
					int day1 = Integer.parseInt(admin1.getDay());
					int day2 = Integer.parseInt(admin2.getDay());
					int hour1 = Integer.parseInt(admin1.getHour());
					int hour2 = Integer.parseInt(admin2.getHour());
					int minute1 = Integer.parseInt(admin1.getMinute());
					int minute2 = Integer.parseInt(admin2.getMinute());

					greater = 2;

					if (year1 > year2) {
						greater = 1;
					} else if (year1 == year2) {
						if (month1 > month2) {
							greater = 1;
						} else if (month1 == month2) {
							if (day1 > day2) {
								greater = 1;
							} else if (day1 == day2) {
								if (hour1 > hour2) {
									greater = 1;
								} else if (hour1 == hour2) {
									if (minute1 > minute2) {
										greater = 1;
									} else if (minute1 == minute2) {
										greater = 1;
									}
								}
							}
						}
					}

					if (greater == 2) {
						itemsVector.insertElementAt(admin2, i);
						itemsVector.remove(i + 2);
						swapped = true;
						swaps++;
					}
				}
			} while (swapped == true);

		} catch (StringIndexOutOfBoundsException e) {
			System.out.println(e);
			return oldVector;
		} catch (Exception e2) {
			System.out.println("swaps > " + swapsLimit + "in bubble sort");
			return oldVector;
		}

		if (swaps > 10000)
			System.out.println("\nswaps = " + swaps);

		return itemsVector;
	}

	public boolean validAdminUser() {
		// changes !!
		if ("adminUser".equals(username)) {
			return true;
		} else {
			return false;
		}
	}

	public void sendMail(String subject) throws MessagingException {
		SendMail sendMail = new SendMail();
		try {
			sendMail.sendMail(subject);
		} catch (MessagingException e) {
			throw e;
		}
	}
}
