package model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class GetPropertyValues {
	
	public String getProperty(String propertyName) {
		// read the property values from the config.properties file, which should be in the class path
		Properties prop = new Properties();
		String propFileName = "config.properties";
		
		try (InputStream input = getClass().getClassLoader().getResourceAsStream(propFileName)) {
			prop.load(input);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		return prop.getProperty(propertyName);
	}

}
