package model;

import java.util.Formatter;
import java.util.Locale;

public class Cell {
	
	private double[] params = new double[6];
	
	public Cell() {
		// initial the parameters to nonsensical values
		for(int i=0; i < 6; i++) params[i] = -1.0;
	}
	
	public void setParam(String pname, double value) {
		switch(pname) {
		case "a": params[0] = value;
			break;
		case "b": params[1] = value;
			break;
		case "c": params[2] = value;
			break;
		case "alpha": params[3] = value;
			break;
		case "beta": params[4] = value;
			break;
		case "gamma": params[5] = value;
			break;
		}
	}
	
	public String toString() {
		return String.format("%.3f,%.3f,%.3f,%.3f,%.3f,%.3f",params[0], params[1], params[2], params[3], params[4], params[5]);
	}
	
	public boolean isValid() {
		for(int i = 0; i < 6; i++) {
			if(params[i] <= 0.0) return false;
		}
		return true;
	}

}
