package model;

import java.io.*;
import java.util.*;

public class Admin implements Serializable {
    
    /* private properties */
    private String programType = "";
    private String user = "";
    private String id = "";
    private String title = "";
    private String day = "";
    private String month = "";
    private String year = "";
    private String hour = "";
    private String minute = "";
    private String status = "";
    private long startingProcessTime;
    private long processQueuedTime;
    private long processRunningTime;
    
    public String getProgramType() {
        return programType;
    }
    
    public String getUser() {
        return user;
    }
    
    public String getId() {
        return id;
    }

    public String getTitle() {
        return title;
    }
    
    public String getDay() {
        return day;
    }
    
    public String getMonth() {
        return month;
    }
    
    public String getYear() {
        return year;
    }
    
    public String getHour() {
        return hour;
    }
    
    public String getMinute() {
        return minute;
    }
    
    public String getStatus() {
        return status;
    }
    
    public String getDate() {
        return day + "&nbsp;" + month + "&nbsp;" + year + "&nbsp;[" + hour + ":" + minute + "]";
    }

    public String getStartingProcessTime() {
        if (startingProcessTime == 0) return "";
        Date d = new Date(startingProcessTime);
        String h = String.valueOf(d.getHours());
        if (h.length() < 2) h = "0" + h;
        String m = String.valueOf(d.getMinutes());
        if (m.length() < 2) m = "0" + m;
        String s = String.valueOf(d.getSeconds());
        if (s.length() < 2) s = "0" + s;
        String dd = h + ":" + m + ":" + s;
        return dd;
    }

    public String getProcessQueuedTime() {
        if (processQueuedTime == 0) return "";
        Date d = new Date(processQueuedTime);
        String h = String.valueOf(d.getHours());
        if (h.length() < 2) h = "0" + h;
        String m = String.valueOf(d.getMinutes());
        if (m.length() < 2) m = "0" + m;
        String s = String.valueOf(d.getSeconds());
        if (s.length() < 2) s = "0" + s;
        String dd = h + ":" + m + ":" + s;
        return dd;
    }

    public String getProcessRunningTime() {
        if (processRunningTime == 0) return "";
        Date d = new Date(processRunningTime);
        String h = String.valueOf(d.getHours());
        if (h.length() < 2) h = "0" + h;
        String m = String.valueOf(d.getMinutes());
        if (m.length() < 2) m = "0" + m;
        String s = String.valueOf(d.getSeconds());
        if (s.length() < 2) s = "0" + s;
        String dd = h + ":" + m + ":" + s;
        return dd;
    }
    
    public void setProgramType(String programType) {
        this.programType = programType;
    }
    
    public void setUser(String user) {
        this.user = user;
    }
    
    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    
    public void setDay(String day) {
        this.day = day;
    }
    
    public void setMonth(String month) {
        this.month = month;
    }
    
    public void setYear(String year) {
        this.year = year;
    }
    
    public void setHour(String hour) {
        this.hour = hour;
    }
    
    public void setMinute(String minute) {
        this.minute = minute;
    }
    
    public void setStatus(String status) {
        this.status = status;
    }

    public void setStartingProcessTime(long startingProcessTime) {
        this.startingProcessTime = startingProcessTime;
    }

    public void setProcessQueuedTime(long processQueuedTime) {
        this.processQueuedTime = processQueuedTime;
    }

    public void setProcessRunningTime(long processRunningTime) {
        this.processRunningTime = processRunningTime;
    }
}
