/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package filedownload;

import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpSession;
import javax.servlet.annotation.WebServlet;
import model.*;

/**
 *
 * @author ville
 */
@WebServlet(urlPatterns = { "/downloads" })
public class FileDownloadServlet extends HttpServlet {
    
    private static final long serialVersionUID = 7583L;

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        HttpSession session = request.getSession();
        boolean loggedIn = false;
        String fs = File.separator;
        String f1 = request.getParameter("file");
        String filename = "";
        try {
            Model model = (Model) session.getAttribute("model");
            String username = model.getUsername();
            filename = model.getRunnableProgramsOutputBaseDir() + fs + f1;
            String[] fparts = f1.split(fs);
            if(!username.equals("") && Arrays.asList(fparts).contains(username)) {
                loggedIn = true;
            }
        } catch (Exception e) {
            loggedIn = false;
        }
        if(!loggedIn) {
            RequestDispatcher dispatcher = request.getRequestDispatcher("/login.jsp");
            dispatcher.forward(request,response);
            return;
        }
        String shortname = filename.substring(filename.lastIndexOf(fs)+1);
        File file = new File(filename);
        if (file.exists()) {
            if (filename.endsWith(".pdf")) {
                response.setContentType("application/pdf");
            } else {
                response.setContentType("application/octet-stream");
            }
            response.addHeader("Content-Disposition","attachment; filename="+shortname);
            byte[] buffer = new byte[1024];
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                OutputStream os = response.getOutputStream();
                int i = bis.read(buffer);
                while(i != -1) {
                    os.write(buffer,0,i);
                    i = bis.read(buffer);
                }
            } catch (IOException ex) {
                System.out.println(ex.toString());
            } finally {
                if(bis != null) {
                    bis.close();
                }
                if(fis != null) {
                    fis.close();
                }
            }
        }
    }
}
