package controller;

import java.io.*;

import javax.servlet.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import model.GetPropertyValues;

import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.charset.Charset;

public class RunnableProgramsViewResultsAction extends Action {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8545625793920259526L;
	private Logger logger = LoggerFactory.getLogger("controller.RunnableProgramsViewResultsAction");

	//public void run() throws ServletException, IOException, Exception {
	public void run() throws ServletException, IOException {

		// set the program run id
		String id = request.getParameter("id");
		String programType = model.getRunnableProgramsType();
		String outputDir = model.getRunnableProgramsOutputBaseDir();
		String username = model.getUsername();
		model.setRunnableProgramsExistingId(id);
		model.setRunnableProgramsExistingJobDir(Paths.get(outputDir,
				programType, username, id).toString());

		// set the initial file and directory for the results page
		// changes if multiple balbes run
		String initialFile = "summary.log";
		String initialDirectory = "output";
		String uri = "/runnableProgramsViewResults.jsp?process=false";
		// String url = null;

		if (model.isBalbesSpacegroupRun()) {
			initialFile = "SGjobsummary.txt";
			initialDirectory = "";
		} else if ("Balbes".equals(model.getRunnableProgramsType())) {
			initialFile = "Process_information.txt";
			initialDirectory = "results";
		} else if ("CRANK2".equals(model.getRunnableProgramsType())
				|| "SHELX".equals(model.getRunnableProgramsType())) {
			initialDirectory = "crank2";
			// link the output dir to a public area if it exists
			// this is a hack to get the output working quickly.
			model.setPublicOutputDir();
			Path outputdir = Paths.get(model
					.getRunnableProgramsExistingJobDir());
			Path publicdir = Paths.get(model.getPublicOutputDir());
			if (!Files.exists(publicdir)) {
				try {
					Files.createSymbolicLink(publicdir, outputdir);
				} catch (IOException x) {
					logger.error("Failed to create a symbolic link from "+outputdir+" to "+publicdir,x);
				}
			}
			Path jsrviewDir = Paths.get(outputdir.toString(), initialDirectory);
			Path taskFile = Paths.get(outputdir.toString(), initialDirectory,
					"task.tsk");
			Path jsrview = Paths.get(jsrviewDir.toString(), "jsrview.html");
			//if (Files.exists(jsrviewDir) && Files.exists(taskFile) && !Files.exists(jsrview)) {
			if (Files.exists(jsrviewDir) && Files.exists(taskFile)) {
				writeJsrviewHTML(jsrview);
			}
			// create a symbolic link to the input directory, so the input files
			// can be downloaded
			Path inputDir = Paths.get(outputdir.toString(), "input");
			Path inputDirLink = Paths.get(jsrviewDir.toString(), "input");
			if (!Files.exists(inputDirLink, LinkOption.NOFOLLOW_LINKS) && Files.exists(inputDir) && Files.exists(jsrviewDir)) {
				try {
					Files.createSymbolicLink(inputDirLink, inputDir);
				} catch (IOException x) {
					logger.error("Failed to create a symbolic link from "+inputDir+" to "+inputDirLink,x);
				}
			}
			uri = "/runnableProgramsJSRView.jsp";
		} else if ("AMPLE".equals(model.getRunnableProgramsType())) {
			initialDirectory = "AMPLE_0/jsrview";
			// link the output dir to a public area if it exists
			// this is a hack to get the output working quickly.
			model.setPublicOutputDir();
			Path outputdir = Paths.get(model
					.getRunnableProgramsExistingJobDir());
			Path publicdir = Paths.get(model.getPublicOutputDir());
			if (!Files.exists(publicdir)) {
				try {
					Files.createSymbolicLink(publicdir, outputdir);
				} catch (IOException x) {
					x.printStackTrace();
				}
			}
			Path jsrviewDir = Paths.get(outputdir.toString(), initialDirectory);
			Path jsrview = Paths.get(jsrviewDir.toString(), "jsrview.html");
			//if (Files.exists(jsrviewDir) && !Files.exists(jsrview)) {
			if (Files.exists(jsrviewDir)) {
				writeJsrviewHTML(jsrview);
			}
			uri = "/runnableProgramsJSRView.jsp";
		} else if ("Zanuda".equals(model.getRunnableProgramsType())) {
			/* commented out to restore the old-style output
			initialDirectory = "zanuda_jsrview";
			// link the output dir to a public area if it exists
			// this is a hack to get the output working quickly.
			model.setPublicOutputDir();
			Path outputdir = Paths.get(model
					.getRunnableProgramsExistingJobDir());
			Path publicdir = Paths.get(model.getPublicOutputDir());
			if (!Files.exists(publicdir)) {
				try {
					Files.createSymbolicLink(publicdir, outputdir);
				} catch (IOException x) {
					x.printStackTrace();
				}
			}
			Path jsrviewDir = Paths.get(outputdir.toString(), initialDirectory);
			Path jsrview = Paths.get(jsrviewDir.toString(), "jsrview.html");
			if (Files.exists(jsrviewDir) && !Files.exists(jsrview)) {
				writeJsrviewHTML(jsrview);
			}
			uri = "/runnableProgramsJSRView.jsp";
			*/
		} else if ("MoRDa".equals(model.getRunnableProgramsType())) {
			initialDirectory = "jsrview";
			model.setPublicOutputDir();
			Path outputdir = Paths.get(model
					.getRunnableProgramsExistingJobDir());
			Path publicdir = Paths.get(model.getPublicOutputDir());
			if (!Files.exists(publicdir)) {
				try {
					Files.createSymbolicLink(publicdir, outputdir);
				} catch (IOException x) {
					x.printStackTrace();
				}
			}
			Path jsrviewDir = Paths.get(outputdir.toString(), initialDirectory);
			Path jsrview = Paths.get(jsrviewDir.toString(), "jsrview.html");
			//if (Files.exists(jsrviewDir) && !Files.exists(jsrview)) {
			if (Files.exists(jsrviewDir)) {
				writeJsrviewHTML(jsrview);
			}
			uri = "/runnableProgramsJSRView.jsp";
		}

		model.setRunnableProgramsFilename(initialFile);
		model.setRunnableProgramsFilenameDir(initialDirectory);

		// if (url != null) {
		// // this redirects to the output page (used with CRANK2)
		// response.sendRedirect(url);
		// } else {
		final String next = uri;
		RequestDispatcher rd = application.getRequestDispatcher(next);
		if (rd == null)
			throw new ServletException("Could not find " + next);
		rd.forward(request, response);
		// }
	}

	private void writeJsrviewHTML(Path target) {
		try (BufferedWriter bw = Files.newBufferedWriter(target,
				Charset.defaultCharset())) {
			GetPropertyValues gpv = new GetPropertyValues();
			String jsrview = gpv.getProperty("jsrview");
			bw.write("<!DOCTYPE html>\n");
			bw.write("<html style='height:100%;'>\n");
			bw.write("<head>\n");
			bw.write("<meta charset='UTF-8'>\n");
			bw.write("<meta http-equiv='pragma' content='no-cache'>\n");
			bw.write("<meta http-equiv='expires' content='0'>\n");
			bw.write("<link rel='stylesheet' type='text/css' href='" + jsrview
					+ "jquery-ui/css/jquery-ui.css'>\n");
			bw.write("<link rel='stylesheet' type='text/css'\n");
			bw.write("href='" + jsrview + "jqplot/css/jquery.jqplot.css'>\n");
			bw.write("<link rel='stylesheet' type='text/css'\n");
			bw.write("href='" + jsrview + "jqtree/css/jqtree.css'>\n");
			bw.write("<link rel='stylesheet' type='text/css'\n");
			bw.write("href='" + jsrview + "css/jsrview.css'>\n");
			bw.write("<script src='" + jsrview
					+ "jquery-ui/js/jquery.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jquery-ui/js/jquery-ui.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqplot/js/jquery.jqplot.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqplot/js/jqplot.cursor.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqplot/js/jqplot.highlighter.min.js'></script>\n");
			bw.write("<script src='"
					+ jsrview
					+ "jqplot/js/jqplot.canvasAxisLabelRenderer.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqplot/js/jqplot.canvasTextRenderer.min.js'></script>\n");
			bw.write("<script src='"
					+ jsrview
					+ "jqplot/js/jqplot.canvasAxisTickRenderer.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqplot/js/jqplot.logAxisRenderer.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqplot/js/jqplot.barRenderer.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "jqtree/js/tree.jquery.js'></script>\n");
			bw.write("<script src='" + jsrview + "d3/d3.v3.min.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "d3/radar-chart.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.buttons.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.checkbox.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.combobox.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.content.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.dropdown.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.form.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.global.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.graph.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.grid.js'></script>\n");
			bw.write("<script src='" + jsrview + "js/jsrview.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.page.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.progressbar.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.section.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.tabs.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.toolbar.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.tree.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.utils.js'></script>\n");
			bw.write("<script src='" + jsrview
					+ "js/jsrview.window.js'></script>\n");
			bw.write("<!--[if lt IE 9]><script src='" + jsrview
					+ "jqplot/js/excanvas.min.js'></script><![endif]-->\n");
			// bw.write("<link rel='stylesheet' type='text/css' href='"+jsrview+"jsrview.min.css'>\n");
			bw.write("<title>CRANK2</title>\n");
			bw.write("</head>\n");
			bw.write("<body>\n");
			// bw.write("<script src='"+jsrview+"jsrview.min.js'></script>\n");
			// bw.write("<!--[if lt IE 9]<script src='"+jsrview+"excanvas.min.js'></script><![endif]-->\n");
			bw.write("<script>\n");
			bw.write("$(document).ready(function() {\n");
			bw.write("docURI = '';\n");
			bw.write("programDocFile = '';\n");
			bw.write("taskFile = 'task.tsk';\n");
			bw.write("initPage(false,false,true);\n");
			bw.write("readTask();\n");
			bw.write("});\n");
			bw.write("</script>\n");
			bw.write("</body>\n");
			bw.write("</html>\n");
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}

}
