package controller;
import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import model.Model;

public class ControllerServlet extends HttpServlet {
    
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    	String page = request.getRequestURI();
    	if(!page.contains("Login"))
    	{
    		doPost(request, response);
    	} 
    }
    
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        Map actionMap = (Map) session.getAttribute("actionMap");
        
        if (actionMap == null) {
            actionMap = new HashMap();
            session.setAttribute("actionMap", actionMap);
        }

        ServletContext context = getServletContext();
        
        try {
            String pathInfo = request.getPathInfo();
            
            //int p = pathInfo.lastIndexOf("/");
            //if (pathInfo.substring(p + 1).equals("SetFileNameDropDown")) {
            //    pathInfo = pathInfo.substring(p); 
            //}
            
            if (pathInfo == null) throw new ServletException("Invalid internal state - no path info");
            
            Action action = (Action) actionMap.get(pathInfo);
            
            if (action == null) {
                StringTokenizer st = new StringTokenizer(pathInfo, "/");
                
                if (st.countTokens() != 1) throw new ServletException("Invalid internal state - invalid path info [" + pathInfo + "]");
                
                String state = st.nextToken();
                String className = "controller." + state + "Action";
                
                try {
                    Class actionClass = Class.forName(className);
                    action = (Action) actionClass.newInstance();
                } catch (ClassNotFoundException e) {
                    throw new ServletException("Could not load class " + className + ": " + e.getMessage());
                } catch (InstantiationException e) {
                    throw new ServletException("Could not create an instance of " + className + ": " + e.getMessage());
                } catch (IllegalAccessException e) {
                    throw new ServletException(className + ": " + e.getMessage());
                }
                
                actionMap.put(pathInfo, action);
            }
            
            Model model = (Model) session.getAttribute("model");
            
            if (model == null) throw new ServletException("No model found in session (session could not remember attributes)");
            
            action.setRequest(request);
            action.setResponse(response);
            action.setApplication(context);
            action.setModel(model);
            try {
                action.run();
            } catch (Exception e) {
            	if(e instanceof FileNotFoundException) {
            		throw (FileNotFoundException) e;
            	} else {
            		throw new ServletException(e.getMessage());
            	}
            }
        } catch (ServletException e) {
            request.setAttribute("javax.servlet.jsp.jspException", e);
            RequestDispatcher rd = context.getRequestDispatcher("/ErrorPage.jsp");
            if (response.isCommitted()) rd.include(request, response);
            else rd.forward(request, response);
        }
    }
}
